/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.bag.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import net.jcip.annotations.Immutable;
import org.eclipse.collections.api.ByteIterable;
import org.eclipse.collections.api.LazyByteIterable;
import org.eclipse.collections.api.bag.ImmutableBag;
import org.eclipse.collections.api.bag.primitive.ByteBag;
import org.eclipse.collections.api.bag.primitive.ImmutableByteBag;
import org.eclipse.collections.api.bag.primitive.MutableByteBag;
import org.eclipse.collections.api.block.function.primitive.ByteToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectByteToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.BytePredicate;
import org.eclipse.collections.api.block.procedure.primitive.ByteIntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ByteProcedure;
import org.eclipse.collections.api.iterator.ByteIterator;
import org.eclipse.collections.api.list.primitive.MutableByteList;
import org.eclipse.collections.api.set.primitive.MutableByteSet;
import org.eclipse.collections.impl.bag.mutable.HashBag;
import org.eclipse.collections.impl.bag.mutable.primitive.ByteHashBag;
import org.eclipse.collections.impl.factory.primitive.ByteBags;
import org.eclipse.collections.impl.iterator.UnmodifiableByteIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyByteIterableAdapter;
import org.eclipse.collections.impl.list.mutable.primitive.ByteArrayList;
import org.eclipse.collections.impl.set.mutable.primitive.ByteHashSet;

@Immutable
final class ImmutableByteSingletonBag
implements ImmutableByteBag,
Serializable {
    private static final long serialVersionUID = 1L;
    private final byte element1;

    ImmutableByteSingletonBag(byte element) {
        this.element1 = element;
    }

    public ImmutableByteBag newWith(byte element) {
        return ByteBags.immutable.with(new byte[]{this.element1, element});
    }

    public ImmutableByteBag newWithout(byte element) {
        return this.element1 == element ? ByteBags.immutable.with() : this;
    }

    public ImmutableByteBag newWithAll(ByteIterable elements) {
        return ByteHashBag.newBag(elements).with(this.element1).toImmutable();
    }

    public ImmutableByteBag newWithoutAll(ByteIterable elements) {
        return elements.contains(this.element1) ? ByteBags.immutable.with() : this;
    }

    public int size() {
        return 1;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean notEmpty() {
        return true;
    }

    public boolean contains(byte value) {
        return this.element1 == value;
    }

    public boolean containsAll(ByteIterable source) {
        ByteIterator iterator = source.byteIterator();
        while (iterator.hasNext()) {
            if (this.element1 == iterator.next()) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(byte ... source) {
        for (byte value : source) {
            if (this.element1 == value) continue;
            return false;
        }
        return true;
    }

    public void forEach(ByteProcedure procedure) {
        this.each(procedure);
    }

    public void each(ByteProcedure procedure) {
        procedure.value(this.element1);
    }

    public ImmutableByteBag select(BytePredicate predicate) {
        return predicate.accept(this.element1) ? ByteHashBag.newBagWith(this.element1).toImmutable() : new ByteHashBag().toImmutable();
    }

    public ImmutableByteBag reject(BytePredicate predicate) {
        return predicate.accept(this.element1) ? new ByteHashBag().toImmutable() : ByteHashBag.newBagWith(this.element1).toImmutable();
    }

    public <V> ImmutableBag<V> collect(ByteToObjectFunction<? extends V> function) {
        return HashBag.newBagWith(function.valueOf(this.element1)).toImmutable();
    }

    public MutableByteList toList() {
        return ByteArrayList.newListWith(this.element1);
    }

    public int sizeDistinct() {
        return 1;
    }

    public int occurrencesOf(byte item) {
        return this.element1 == item ? 1 : 0;
    }

    public void forEachWithOccurrences(ByteIntProcedure byteIntProcedure) {
        byteIntProcedure.value(this.element1, 1);
    }

    public byte detectIfNone(BytePredicate predicate, byte ifNone) {
        return predicate.accept(this.element1) ? this.element1 : ifNone;
    }

    public int count(BytePredicate predicate) {
        return predicate.accept(this.element1) ? 1 : 0;
    }

    public boolean anySatisfy(BytePredicate predicate) {
        return predicate.accept(this.element1);
    }

    public long sum() {
        return this.element1;
    }

    public byte min() {
        return this.element1;
    }

    public byte max() {
        return this.element1;
    }

    public byte maxIfEmpty(byte defaultValue) {
        return this.element1;
    }

    public byte minIfEmpty(byte defaultValue) {
        return this.element1;
    }

    public double average() {
        return this.element1;
    }

    public double median() {
        return this.element1;
    }

    public byte[] toSortedArray() {
        return new byte[]{this.element1};
    }

    public MutableByteList toSortedList() {
        return ByteArrayList.newListWith(this.element1);
    }

    public boolean noneSatisfy(BytePredicate predicate) {
        return !predicate.accept(this.element1);
    }

    public boolean allSatisfy(BytePredicate predicate) {
        return predicate.accept(this.element1);
    }

    public <T> T injectInto(T injectedValue, ObjectByteToObjectFunction<? super T, ? extends T> function) {
        return (T)function.valueOf(injectedValue, this.element1);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ByteBag)) {
            return false;
        }
        ByteBag bag = (ByteBag)obj;
        if (bag.size() != 1) {
            return false;
        }
        return this.occurrencesOf(this.element1) == bag.occurrencesOf(this.element1);
    }

    public int hashCode() {
        return this.element1 ^ 1;
    }

    public MutableByteSet toSet() {
        return ByteHashSet.newSetWith(this.element1);
    }

    public MutableByteBag toBag() {
        return ByteHashBag.newBagWith(this.element1);
    }

    public ImmutableByteBag toImmutable() {
        return this;
    }

    public LazyByteIterable asLazy() {
        return new LazyByteIterableAdapter((ByteIterable)this);
    }

    public byte[] toArray() {
        return new byte[]{this.element1};
    }

    public String toString() {
        return '[' + this.makeString() + ']';
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(String.valueOf(this.element1));
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ByteIterator byteIterator() {
        return new UnmodifiableByteIterator((ByteIterator)ByteHashBag.newBagWith(this.element1).byteIterator());
    }
}

