/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.bag.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import java.util.NoSuchElementException;
import net.jcip.annotations.Immutable;
import org.eclipse.collections.api.DoubleIterable;
import org.eclipse.collections.api.LazyDoubleIterable;
import org.eclipse.collections.api.bag.ImmutableBag;
import org.eclipse.collections.api.bag.primitive.DoubleBag;
import org.eclipse.collections.api.bag.primitive.ImmutableDoubleBag;
import org.eclipse.collections.api.bag.primitive.MutableDoubleBag;
import org.eclipse.collections.api.block.function.primitive.DoubleToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectDoubleToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.DoublePredicate;
import org.eclipse.collections.api.block.procedure.primitive.DoubleIntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.DoubleProcedure;
import org.eclipse.collections.api.iterator.DoubleIterator;
import org.eclipse.collections.api.list.primitive.MutableDoubleList;
import org.eclipse.collections.api.set.primitive.MutableDoubleSet;
import org.eclipse.collections.impl.bag.immutable.primitive.ImmutableDoubleSingletonBag;
import org.eclipse.collections.impl.bag.mutable.primitive.DoubleHashBag;
import org.eclipse.collections.impl.factory.Bags;
import org.eclipse.collections.impl.factory.primitive.DoubleBags;
import org.eclipse.collections.impl.iterator.ImmutableEmptyDoubleIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyDoubleIterableAdapter;
import org.eclipse.collections.impl.list.mutable.primitive.DoubleArrayList;
import org.eclipse.collections.impl.set.mutable.primitive.DoubleHashSet;

@Immutable
final class ImmutableDoubleEmptyBag
implements ImmutableDoubleBag,
Serializable {
    static final ImmutableDoubleBag INSTANCE = new ImmutableDoubleEmptyBag();
    private static final long serialVersionUID = 1L;

    ImmutableDoubleEmptyBag() {
    }

    private Object readResolve() {
        return INSTANCE;
    }

    public ImmutableDoubleBag newWith(double element) {
        return new ImmutableDoubleSingletonBag(element);
    }

    public ImmutableDoubleBag newWithout(double element) {
        return this;
    }

    public ImmutableDoubleBag newWithAll(DoubleIterable elements) {
        return DoubleBags.immutable.withAll(elements);
    }

    public ImmutableDoubleBag newWithoutAll(DoubleIterable elements) {
        return this;
    }

    public int size() {
        return 0;
    }

    public boolean isEmpty() {
        return true;
    }

    public boolean notEmpty() {
        return false;
    }

    public boolean contains(double value) {
        return false;
    }

    public boolean containsAll(DoubleIterable source) {
        return source.isEmpty();
    }

    public boolean containsAll(double ... elements) {
        return elements.length == 0;
    }

    public void forEach(DoubleProcedure procedure) {
    }

    public void each(DoubleProcedure procedure) {
    }

    public ImmutableDoubleBag select(DoublePredicate predicate) {
        return this;
    }

    public ImmutableDoubleBag reject(DoublePredicate predicate) {
        return this;
    }

    public <V> ImmutableBag<V> collect(DoubleToObjectFunction<? extends V> function) {
        return Bags.immutable.of();
    }

    public MutableDoubleList toList() {
        return new DoubleArrayList();
    }

    public int sizeDistinct() {
        return 0;
    }

    public int occurrencesOf(double item) {
        return 0;
    }

    public void forEachWithOccurrences(DoubleIntProcedure doubleIntProcedure) {
    }

    public double detectIfNone(DoublePredicate predicate, double ifNone) {
        return ifNone;
    }

    public int count(DoublePredicate predicate) {
        return 0;
    }

    public boolean anySatisfy(DoublePredicate predicate) {
        return false;
    }

    public double sum() {
        return 0.0;
    }

    public double min() {
        throw new NoSuchElementException();
    }

    public double max() {
        throw new NoSuchElementException();
    }

    public double maxIfEmpty(double defaultValue) {
        return defaultValue;
    }

    public double minIfEmpty(double defaultValue) {
        return defaultValue;
    }

    public double average() {
        throw new ArithmeticException();
    }

    public double median() {
        throw new ArithmeticException();
    }

    public double[] toSortedArray() {
        return new double[0];
    }

    public MutableDoubleList toSortedList() {
        return new DoubleArrayList();
    }

    public boolean noneSatisfy(DoublePredicate predicate) {
        return true;
    }

    public boolean allSatisfy(DoublePredicate predicate) {
        return true;
    }

    public <T> T injectInto(T injectedValue, ObjectDoubleToObjectFunction<? super T, ? extends T> function) {
        return injectedValue;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DoubleBag)) {
            return false;
        }
        DoubleBag bag = (DoubleBag)obj;
        return bag.isEmpty();
    }

    public int hashCode() {
        return 0;
    }

    public MutableDoubleSet toSet() {
        return new DoubleHashSet();
    }

    public MutableDoubleBag toBag() {
        return new DoubleHashBag();
    }

    public ImmutableDoubleBag toImmutable() {
        return this;
    }

    public LazyDoubleIterable asLazy() {
        return new LazyDoubleIterableAdapter((DoubleIterable)this);
    }

    public double[] toArray() {
        return new double[0];
    }

    public String toString() {
        return "[]";
    }

    public String makeString() {
        return "";
    }

    public String makeString(String separator) {
        return "";
    }

    public String makeString(String start, String separator, String end) {
        return start + end;
    }

    public void appendString(Appendable appendable) {
    }

    public void appendString(Appendable appendable, String separator) {
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public DoubleIterator doubleIterator() {
        return ImmutableEmptyDoubleIterator.INSTANCE;
    }
}

