/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.list.immutable;

import java.io.Serializable;
import java.util.RandomAccess;
import net.jcip.annotations.Immutable;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.impl.block.factory.Comparators;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.list.immutable.AbstractImmutableList;

@Immutable
final class ImmutableSingletonList<T>
extends AbstractImmutableList<T>
implements Serializable,
RandomAccess {
    private static final long serialVersionUID = 1L;
    private final T element1;

    ImmutableSingletonList(T obj1) {
        this.element1 = obj1;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean contains(Object obj) {
        return Comparators.nullSafeEquals(obj, this.element1);
    }

    public void each(Procedure<? super T> procedure) {
        procedure.value(this.element1);
    }

    @Override
    public T get(int index) {
        if (index == 0) {
            return this.element1;
        }
        throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size());
    }

    @Override
    public T getFirst() {
        return this.element1;
    }

    @Override
    public T getLast() {
        return this.element1;
    }

    @Override
    public T getOnly() {
        return this.element1;
    }

    @Override
    public ImmutableList<T> toReversed() {
        return this;
    }

    public ImmutableList<T> newWith(T newItem) {
        return Lists.immutable.with(this.element1, newItem);
    }
}

