/*
 * Copyright (c) 2016 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.impl.bag.mutable.primitive;

import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.factory.bag.primitive.MutableLongBagFactory;
import org.eclipse.collections.api.bag.primitive.MutableLongBag;

/**
 * MutableLongBagFactoryImpl is a factory implementation which creates instances of type {@link MutableLongBag}.
 * This file was automatically generated from template file mutablePrimitiveBagFactoryImpl.stg.
 *
 * @since 6.0.
 */
public class MutableLongBagFactoryImpl implements MutableLongBagFactory
{
    public MutableLongBag empty()
    {
        return new LongHashBag();
    }

    public MutableLongBag of()
    {
        return this.empty();
    }

    public MutableLongBag with()
    {
        return this.empty();
    }

    public MutableLongBag of(long... items)
    {
        return this.with(items);
    }

    public MutableLongBag with(long... items)
    {
        if (items == null || items.length == 0)
        {
            return this.with();
        }
        return LongHashBag.newBagWith(items);
    }

    public MutableLongBag ofAll(LongIterable items)
    {
        return this.withAll(items);
    }

    public MutableLongBag withAll(LongIterable items)
    {
        return LongHashBag.newBag(items);
    }
}
