/*
 * Copyright (c) 2016 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.impl.factory.primitive;

import org.eclipse.collections.api.factory.set.primitive.ImmutableShortSetFactory;
import org.eclipse.collections.api.factory.set.primitive.MutableShortSetFactory;
import org.eclipse.collections.impl.set.immutable.primitive.ImmutableShortSetFactoryImpl;
import org.eclipse.collections.impl.set.mutable.primitive.MutableShortSetFactoryImpl;

/**
 * ShortSets is a static utility for creating {@link ImmutableShortSetFactory}.
 * This file was automatically generated from template file primitiveSets.stg.
 *
 * @since 3.2.
 */
@SuppressWarnings("ConstantNamingConvention")
public final class ShortSets
{
    public static final ImmutableShortSetFactory immutable = new ImmutableShortSetFactoryImpl();
    public static final MutableShortSetFactory mutable = new MutableShortSetFactoryImpl();

    private ShortSets()
    {
        throw new AssertionError("Suppress default constructor for noninstantiability");
    }
}
