/*
 * Copyright (c) 2016 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.impl.list.mutable.primitive;

import org.eclipse.collections.api.ShortIterable;
import org.eclipse.collections.api.factory.list.primitive.MutableShortListFactory;
import org.eclipse.collections.api.list.primitive.MutableShortList;

/**
 * MutableShortListFactoryImpl is a factory implementation which creates instances of type {@link MutableShortList}.
 * This file was automatically generated from template file mutablePrimitiveListFactoryImpl.stg.
 *
 * @since 6.0.
 */
public class MutableShortListFactoryImpl implements MutableShortListFactory
{
    public MutableShortList empty()
    {
        return new ShortArrayList();
    }

    public MutableShortList of()
    {
        return this.empty();
    }

    public MutableShortList with()
    {
        return this.empty();
    }

    public MutableShortList of(short... items)
    {
        return this.with(items);
    }

    public MutableShortList with(short... items)
    {
        if (items == null || items.length == 0)
        {
            return this.with();
        }
        return ShortArrayList.newListWith(items);
    }

    public MutableShortList ofAll(ShortIterable items)
    {
        return this.withAll(items);
    }

    public MutableShortList withAll(ShortIterable items)
    {
        return ShortArrayList.newList(items);
    }
}
