/*
 * Copyright (c) 2016 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.impl.map.mutable.primitive;

import org.eclipse.collections.api.factory.map.primitive.MutableFloatIntMapFactory;
import org.eclipse.collections.api.map.primitive.MutableFloatIntMap;
import org.eclipse.collections.api.map.primitive.FloatIntMap;

/**
 * MutableFloatIntMapFactoryImpl is a factory implementation which creates instances of type {@link MutableFloatIntMap}.
 * This file was automatically generated from template file mutablePrimitivePrimitiveMapFactoryImpl.stg.
 *
 * @since 6.0.
 */
public class MutableFloatIntMapFactoryImpl implements MutableFloatIntMapFactory
{
    public MutableFloatIntMap empty()
    {
        return new FloatIntHashMap(0);
    }

    public MutableFloatIntMap of()
    {
        return this.empty();
    }

    public MutableFloatIntMap with()
    {
        return this.empty();
    }

    public MutableFloatIntMap ofAll(FloatIntMap map)
    {
        return this.withAll(map);
    }

    public MutableFloatIntMap withAll(FloatIntMap map)
    {
        if (map.isEmpty())
        {
            return this.empty();
        }
        return new FloatIntHashMap(map);
    }
}
