/*
 * Copyright (c) 2016 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.impl.set.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import java.util.NoSuchElementException;

import org.eclipse.collections.api.ByteIterable;
import org.eclipse.collections.api.LazyByteIterable;
import org.eclipse.collections.api.bag.primitive.MutableByteBag;
import org.eclipse.collections.api.set.ImmutableSet;
import org.eclipse.collections.api.set.primitive.ImmutableByteSet;
import org.eclipse.collections.api.set.primitive.ByteSet;
import org.eclipse.collections.api.set.primitive.MutableByteSet;
import org.eclipse.collections.api.block.function.primitive.ByteToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectByteToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.BytePredicate;
import org.eclipse.collections.api.block.procedure.primitive.ByteProcedure;
import org.eclipse.collections.api.iterator.ByteIterator;
import org.eclipse.collections.api.list.primitive.MutableByteList;
import org.eclipse.collections.impl.bag.mutable.primitive.ByteHashBag;
import org.eclipse.collections.impl.set.mutable.primitive.ByteHashSet;
import org.eclipse.collections.impl.factory.Sets;
import org.eclipse.collections.impl.factory.primitive.ByteSets;
import org.eclipse.collections.impl.iterator.ImmutableEmptyByteIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyByteIterableAdapter;
import org.eclipse.collections.impl.list.mutable.primitive.ByteArrayList;
import net.jcip.annotations.Immutable;

/**
 * ImmutableByteEmptySet is an optimization for {@link ImmutableByteSet} of size 0.
 * This file was automatically generated from template file immutablePrimitiveEmptySet.stg.
 *
 * @since 4.0.
 */
@Immutable
final class ImmutableByteEmptySet implements ImmutableByteSet, Serializable
{
    static final ImmutableByteSet INSTANCE = new ImmutableByteEmptySet();

    private static final long serialVersionUID = 1L;

    private Object readResolve()
    {
        return INSTANCE;
    }

    public ImmutableByteSet newWith(byte element)
    {
        return new ImmutableByteSingletonSet(element);
    }

    public ImmutableByteSet newWithout(byte element)
    {
        return this;
    }

    public ImmutableByteSet newWithAll(ByteIterable elements)
    {
        return ByteSets.immutable.withAll(elements);
    }

    public ImmutableByteSet newWithoutAll(ByteIterable elements)
    {
        return this;
    }

    public int size()
    {
        return 0;
    }

    public boolean isEmpty()
    {
        return true;
    }

    public boolean notEmpty()
    {
        return false;
    }

    public boolean contains(byte value)
    {
        return false;
    }

    public boolean containsAll(ByteIterable source)
    {
        return source.isEmpty();
    }

    public boolean containsAll(byte... elements)
    {
        return elements.length == 0;
    }

    public void forEach(ByteProcedure procedure)
    {
    }

    /**
     * @since 7.0.
     */
    public void each(ByteProcedure procedure)
    {
    }

    public ImmutableByteSet select(BytePredicate predicate)
    {
        return this;
    }

    public ImmutableByteSet reject(BytePredicate predicate)
    {
        return this;
    }

    public <V> ImmutableSet<V> collect(ByteToObjectFunction<? extends V> function)
    {
        return Sets.immutable.of();
    }

    public MutableByteList toList()
    {
        return new ByteArrayList();
    }

    public byte detectIfNone(BytePredicate predicate, byte ifNone)
    {
        return ifNone;
    }

    public int count(BytePredicate predicate)
    {
        return 0;
    }

    public boolean anySatisfy(BytePredicate predicate)
    {
        return false;
    }

    public long sum()
    {
        return 0L;
    }

    public byte min()
    {
        throw new NoSuchElementException();
    }

    public byte max()
    {
        throw new NoSuchElementException();
    }

    public byte maxIfEmpty(byte defaultValue)
    {
        return defaultValue;
    }

    public byte minIfEmpty(byte defaultValue)
    {
        return defaultValue;
    }

    public double average()
    {
        throw new ArithmeticException();
    }

    public double median()
    {
        throw new ArithmeticException();
    }

    public byte[] toSortedArray()
    {
        return new byte[0];
    }

    public MutableByteList toSortedList()
    {
        return new ByteArrayList();
    }

    public boolean noneSatisfy(BytePredicate predicate)
    {
        return true;
    }

    public boolean allSatisfy(BytePredicate predicate)
    {
        return true;
    }

    public <T> T injectInto(T injectedValue, ObjectByteToObjectFunction<? super T, ? extends T> function)
    {
        return injectedValue;
    }

    @Override
    public boolean equals(Object obj)
    {
        if (obj == this)
        {
            return true;
        }
        if (!(obj instanceof ByteSet))
        {
            return false;
        }
        ByteSet set = (ByteSet) obj;
        return set.isEmpty();
    }

    @Override
    public int hashCode()
    {
        return 0;
    }

    public MutableByteSet toSet()
    {
        return new ByteHashSet();
    }

    public MutableByteBag toBag()
    {
        return new ByteHashBag();
    }

    public ByteSet freeze()
    {
        return this;
    }

    public ImmutableByteSet toImmutable()
    {
        return this;
    }

    public LazyByteIterable asLazy()
    {
        return new LazyByteIterableAdapter(this);
    }

    public byte[] toArray()
    {
        return new byte[0];
    }

    @Override
    public String toString()
    {
        return "[]";
    }

    public String makeString()
    {
        return "";
    }

    public String makeString(String separator)
    {
        return "";
    }

    public String makeString(String start, String separator, String end)
    {
        return start + end;
    }

    public void appendString(Appendable appendable)
    {
    }

    public void appendString(Appendable appendable, String separator)
    {
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        try
        {
            appendable.append(start);
            appendable.append(end);
        }
        catch (IOException e)
        {
            throw new RuntimeException(e);
        }
    }

    public ByteIterator byteIterator()
    {
        return ImmutableEmptyByteIterator.INSTANCE;
    }
}
