/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.bag.immutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import org.eclipse.collections.api.ByteIterable;
import org.eclipse.collections.api.LazyByteIterable;
import org.eclipse.collections.api.bag.ImmutableBag;
import org.eclipse.collections.api.bag.primitive.ByteBag;
import org.eclipse.collections.api.bag.primitive.ImmutableByteBag;
import org.eclipse.collections.api.bag.primitive.MutableByteBag;
import org.eclipse.collections.api.block.function.primitive.ByteToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectByteToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.BytePredicate;
import org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import org.eclipse.collections.api.block.procedure.primitive.ByteIntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ByteProcedure;
import org.eclipse.collections.api.iterator.ByteIterator;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.list.primitive.MutableByteList;
import org.eclipse.collections.api.set.primitive.MutableByteSet;
import org.eclipse.collections.api.tuple.primitive.ByteIntPair;
import org.eclipse.collections.impl.bag.mutable.primitive.ByteHashBag;
import org.eclipse.collections.impl.block.procedure.checked.primitive.CheckedByteIntProcedure;
import org.eclipse.collections.impl.iterator.UnmodifiableByteIterator;

final class ImmutableByteHashBag
implements ImmutableByteBag,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableByteBag delegate;

    private ImmutableByteHashBag(byte[] newElements) {
        this.checkOptimizedSize(newElements.length);
        this.delegate = ByteHashBag.newBagWith(newElements);
    }

    private void checkOptimizedSize(int length) {
        if (length <= 1) {
            throw new IllegalArgumentException("Use ByteBags.immutable.with() to instantiate an optimized collection");
        }
    }

    public static ImmutableByteHashBag newBagWith(byte ... elements) {
        return new ImmutableByteHashBag(elements);
    }

    public ImmutableByteBag newWith(byte element) {
        return ByteHashBag.newBag((ByteBag)this.delegate).with(element).toImmutable();
    }

    public ImmutableByteBag newWithout(byte element) {
        ByteHashBag hashBag = ByteHashBag.newBag((ByteBag)this.delegate);
        hashBag.remove(element);
        return hashBag.toImmutable();
    }

    public ImmutableByteBag newWithAll(ByteIterable elements) {
        ByteHashBag bag = ByteHashBag.newBag((ByteBag)this.delegate);
        bag.addAll(elements);
        return bag.toImmutable();
    }

    public ImmutableByteBag newWithoutAll(ByteIterable elements) {
        ByteHashBag bag = ByteHashBag.newBag((ByteBag)this.delegate);
        bag.removeAll(elements);
        return bag.toImmutable();
    }

    public int size() {
        return this.delegate.size();
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public boolean notEmpty() {
        return this.delegate.notEmpty();
    }

    public boolean contains(byte value) {
        return this.delegate.contains(value);
    }

    public boolean containsAll(ByteIterable source) {
        return this.delegate.containsAll(source);
    }

    public boolean containsAll(byte ... elements) {
        return this.delegate.containsAll(elements);
    }

    public void forEach(ByteProcedure procedure) {
        this.each(procedure);
    }

    public void each(ByteProcedure procedure) {
        this.delegate.forEach(procedure);
    }

    public ImmutableByteBag select(BytePredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableByteBag selectByOccurrences(IntPredicate predicate) {
        return this.delegate.selectByOccurrences(predicate).toImmutable();
    }

    public ImmutableList<ByteIntPair> topOccurrences(int count) {
        return this.delegate.topOccurrences(count).toImmutable();
    }

    public ImmutableList<ByteIntPair> bottomOccurrences(int count) {
        return this.delegate.bottomOccurrences(count).toImmutable();
    }

    public ImmutableByteBag reject(BytePredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    public <V> ImmutableBag<V> collect(ByteToObjectFunction<? extends V> function) {
        return this.delegate.collect(function).toImmutable();
    }

    public MutableByteList toList() {
        return this.delegate.toList();
    }

    public int sizeDistinct() {
        return this.delegate.sizeDistinct();
    }

    public int occurrencesOf(byte item) {
        return this.delegate.occurrencesOf(item);
    }

    public void forEachWithOccurrences(ByteIntProcedure byteIntProcedure) {
        this.delegate.forEachWithOccurrences(byteIntProcedure);
    }

    public byte detectIfNone(BytePredicate predicate, byte ifNone) {
        return this.delegate.detectIfNone(predicate, ifNone);
    }

    public int count(BytePredicate predicate) {
        return this.delegate.count(predicate);
    }

    public boolean anySatisfy(BytePredicate predicate) {
        return this.delegate.anySatisfy(predicate);
    }

    public long sum() {
        return this.delegate.sum();
    }

    public byte min() {
        return this.delegate.min();
    }

    public byte max() {
        return this.delegate.max();
    }

    public byte maxIfEmpty(byte defaultValue) {
        return this.delegate.maxIfEmpty(defaultValue);
    }

    public byte minIfEmpty(byte defaultValue) {
        return this.delegate.minIfEmpty(defaultValue);
    }

    public double average() {
        return this.delegate.average();
    }

    public double median() {
        return this.delegate.median();
    }

    public byte[] toSortedArray() {
        return this.delegate.toSortedArray();
    }

    public MutableByteList toSortedList() {
        return this.delegate.toSortedList();
    }

    public boolean noneSatisfy(BytePredicate predicate) {
        return this.delegate.noneSatisfy(predicate);
    }

    public boolean allSatisfy(BytePredicate predicate) {
        return this.delegate.allSatisfy(predicate);
    }

    public <T> T injectInto(T injectedValue, ObjectByteToObjectFunction<? super T, ? extends T> function) {
        return (T)this.delegate.injectInto(injectedValue, function);
    }

    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public MutableByteSet toSet() {
        return this.delegate.toSet();
    }

    public MutableByteBag toBag() {
        return this.delegate.toBag();
    }

    public ImmutableByteBag toImmutable() {
        return this;
    }

    public LazyByteIterable asLazy() {
        return this.delegate.asLazy();
    }

    public byte[] toArray() {
        return this.delegate.toArray();
    }

    public String toString() {
        return this.delegate.toString();
    }

    public String makeString() {
        return this.delegate.makeString();
    }

    public String makeString(String separator) {
        return this.delegate.makeString(separator);
    }

    public String makeString(String start, String separator, String end) {
        return this.delegate.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable) {
        this.delegate.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator) {
        this.delegate.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.delegate.appendString(appendable, start, separator, end);
    }

    public ByteIterator byteIterator() {
        return new UnmodifiableByteIterator((ByteIterator)this.delegate.byteIterator());
    }

    private Object writeReplace() {
        return new ImmutableByteBagSerializationProxy((ByteBag)this);
    }

    protected static class ImmutableByteBagSerializationProxy
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private ByteBag bag;

        public ImmutableByteBagSerializationProxy() {
        }

        protected ImmutableByteBagSerializationProxy(ByteBag bag) {
            this.bag = bag;
        }

        @Override
        public void writeExternal(final ObjectOutput out) throws IOException {
            out.writeInt(this.bag.sizeDistinct());
            try {
                this.bag.forEachWithOccurrences((ByteIntProcedure)new CheckedByteIntProcedure(){

                    @Override
                    public void safeValue(byte item, int count) throws IOException {
                        out.writeByte(item);
                        out.writeInt(count);
                    }
                });
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw e;
            }
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int size = in.readInt();
            ByteHashBag deserializedBag = new ByteHashBag();
            for (int i = 0; i < size; ++i) {
                deserializedBag.addOccurrences(in.readByte(), in.readInt());
            }
            this.bag = deserializedBag;
        }

        protected Object readResolve() {
            return this.bag.toImmutable();
        }
    }
}

