/*
 * Copyright (c) 2016 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.impl.bag.immutable.primitive;

import org.eclipse.collections.api.ShortIterable;
import org.eclipse.collections.api.bag.primitive.ImmutableShortBag;
import org.eclipse.collections.api.factory.bag.primitive.ImmutableShortBagFactory;

/**
 * ImmutableShortBagFactoryImpl is a factory implementation which creates instances of type {@link ImmutableShortBag}.
 * This file was automatically generated from template file immutablePrimitiveBagFactoryImpl.stg.
 *
 * @since 4.0.
 */
public class ImmutableShortBagFactoryImpl implements ImmutableShortBagFactory
{
    public ImmutableShortBag empty()
    {
        return ImmutableShortEmptyBag.INSTANCE;
    }

    public ImmutableShortBag of()
    {
        return this.empty();
    }

    public ImmutableShortBag with()
    {
        return this.empty();
    }

    public ImmutableShortBag of(short one)
    {
        return this.with(one);
    }

    public ImmutableShortBag with(short one)
    {
        return new ImmutableShortSingletonBag(one);
    }

    public ImmutableShortBag of(short... items)
    {
        return this.with(items);
    }

    public ImmutableShortBag with(short... items)
    {
        if (items == null || items.length == 0)
        {
            return this.with();
        }
        if (items.length == 1)
        {
            return this.with(items[0]);
        }
        return ImmutableShortHashBag.newBagWith(items);
    }

    public ImmutableShortBag ofAll(ShortIterable items)
    {
        return this.withAll(items);
    }

    public ImmutableShortBag withAll(ShortIterable items)
    {
        if (items instanceof ImmutableShortBag)
        {
            return (ImmutableShortBag) items;
        }
        return this.with(items.toArray());
    }
}
