/*
 * Copyright (c) 2016 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.impl.list.mutable.primitive;

import java.util.Collection;
import java.util.Collections;

import org.eclipse.collections.api.CharIterable;
import org.eclipse.collections.api.LazyCharIterable;
import org.eclipse.collections.api.block.function.primitive.CharToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectCharIntToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.CharPredicate;
import org.eclipse.collections.api.block.procedure.primitive.CharIntProcedure;
import org.eclipse.collections.api.iterator.CharIterator;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.list.primitive.CharList;
import org.eclipse.collections.api.list.primitive.ImmutableCharList;
import org.eclipse.collections.api.list.primitive.MutableCharList;
import org.eclipse.collections.impl.collection.mutable.primitive.AbstractSynchronizedCharCollection;
import org.eclipse.collections.impl.factory.primitive.CharLists;
import org.eclipse.collections.impl.lazy.primitive.LazyCharIterableAdapter;
import org.eclipse.collections.impl.lazy.primitive.ReverseCharIterable;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;

/**
 * A synchronized view of a {@link MutableCharList}. It is imperative that the user manually synchronize on the collection when iterating over it using the
 * {@link CharIterator}, as per {@link Collections#synchronizedCollection(Collection)}.
 * <p>
 * This file was automatically generated from template file synchronizedPrimitiveList.stg.
 *
 * @see MutableCharList#asSynchronized()
 * @see MutableList#asSynchronized()
 * @since 3.1.
 */
@ThreadSafe
public final class SynchronizedCharList
        extends AbstractSynchronizedCharCollection
        implements MutableCharList
{
    private static final long serialVersionUID = 1L;

    SynchronizedCharList(MutableCharList list)
    {
        super(list);
    }

    SynchronizedCharList(MutableCharList list, Object newLock)
    {
        super(list, newLock);
    }

    @GuardedBy("getLock()")
    private MutableCharList getMutableCharList()
    {
        return (MutableCharList) this.getCharCollection();
    }

    public char get(int index)
    {
        synchronized (this.getLock())
        {
            return this.getMutableCharList().get(index);
        }
    }

    public char getFirst()
    {
        synchronized (this.getLock())
        {
            return this.getMutableCharList().getFirst();
        }
    }

    public char getLast()
    {
        synchronized (this.getLock())
        {
            return this.getMutableCharList().getLast();
        }
    }

    public int indexOf(char value)
    {
        synchronized (this.getLock())
        {
            return this.getMutableCharList().indexOf(value);
        }
    }

    public int lastIndexOf(char value)
    {
        synchronized (this.getLock())
        {
            return this.getMutableCharList().lastIndexOf(value);
        }
    }

    public void addAtIndex(int index, char element)
    {
        synchronized (this.getLock())
        {
            this.getMutableCharList().addAtIndex(index, element);
        }
    }

    public boolean addAllAtIndex(int index, char... source)
    {
        synchronized (this.getLock())
        {
            return this.getMutableCharList().addAllAtIndex(index, source);
        }
    }

    public boolean addAllAtIndex(int index, CharIterable source)
    {
        synchronized (this.getLock())
        {
            return this.getMutableCharList().addAllAtIndex(index, source);
        }
    }

    public char removeAtIndex(int index)
    {
        synchronized (this.getLock())
        {
            return this.getMutableCharList().removeAtIndex(index);
        }
    }

    public char set(int index, char element)
    {
        synchronized (this.getLock())
        {
            return this.getMutableCharList().set(index, element);
        }
    }

    @Override
    public SynchronizedCharList with(char element)
    {
        synchronized (this.getLock())
        {
            this.getMutableCharList().add(element);
        }
        return this;
    }

    @Override
    public SynchronizedCharList without(char element)
    {
        synchronized (this.getLock())
        {
            this.getMutableCharList().remove(element);
        }
        return this;
    }

    @Override
    public SynchronizedCharList withAll(CharIterable elements)
    {
        synchronized (this.getLock())
        {
            this.getMutableCharList().addAll(elements.toArray());
        }
        return this;
    }

    @Override
    public SynchronizedCharList withoutAll(CharIterable elements)
    {
        synchronized (this.getLock())
        {
            this.getMutableCharList().removeAll(elements);
        }
        return this;
    }

    @Override
    public MutableCharList select(CharPredicate predicate)
    {
        synchronized (this.getLock())
        {
            return this.getMutableCharList().select(predicate);
        }
    }

    @Override
    public MutableCharList reject(CharPredicate predicate)
    {
        synchronized (this.getLock())
        {
            return this.getMutableCharList().reject(predicate);
        }
    }

    @Override
    public <V> MutableList<V> collect(CharToObjectFunction<? extends V> function)
    {
        synchronized (this.getLock())
        {
            return this.getMutableCharList().collect(function);
        }
    }

    public MutableCharList sortThis()
    {
        synchronized (this.getLock())
        {
            this.getMutableCharList().sortThis();
        }
        return this;
    }

    public int binarySearch(char value)
    {
        synchronized (this.getLock())
        {
            return this.getMutableCharList().binarySearch(value);
        }
    }

    public long dotProduct(CharList list)
    {
        synchronized (this.getLock())
        {
            return this.getMutableCharList().dotProduct(list);
        }
    }

    @Override
    public boolean equals(Object otherList)
    {
        synchronized (this.getLock())
        {
            return this.getMutableCharList().equals(otherList);
        }
    }

    @Override
    public int hashCode()
    {
        synchronized (this.getLock())
        {
            return this.getMutableCharList().hashCode();
        }
    }

    @Override
    public LazyCharIterable asLazy()
    {
        synchronized (this.getLock())
        {
            return new LazyCharIterableAdapter(this);
        }
    }

    @Override
    public MutableCharList asUnmodifiable()
    {
        return new UnmodifiableCharList(this);
    }

    @Override
    public MutableCharList asSynchronized()
    {
        return this;
    }

    @Override
    public ImmutableCharList toImmutable()
    {
        synchronized (this.getLock())
        {
            int size = this.size();
            if (size == 0)
            {
                return CharLists.immutable.with();
            }
            if (size == 1)
            {
                return CharLists.immutable.with(this.getFirst());
            }
            return CharLists.immutable.with(this.toArray());
        }
    }

    public MutableCharList reverseThis()
    {
        synchronized (this.getLock())
        {
            this.getMutableCharList().reverseThis();
        }
        return this;
    }

    public MutableCharList toReversed()
    {
        synchronized (this.getLock())
        {
            return this.getMutableCharList().toReversed();
        }
    }

    public LazyCharIterable asReversed()
    {
        return ReverseCharIterable.adapt(this);
    }

    public void forEachWithIndex(CharIntProcedure procedure)
    {
        synchronized (this.getLock())
        {
            this.getMutableCharList().forEachWithIndex(procedure);
        }
    }

    public <T> T injectIntoWithIndex(T injectedValue, ObjectCharIntToObjectFunction<? super T, ? extends T> function)
    {
        synchronized (this.getLock())
        {
            return this.getMutableCharList().injectIntoWithIndex(injectedValue, function);
        }
    }

    /**
     * @since 6.0.
     */
    public MutableCharList distinct()
    {
        synchronized (this.getLock())
        {
            return this.getMutableCharList().distinct();
        }
    }

    public MutableCharList subList(int fromIndex, int toIndex)
    {
        throw new UnsupportedOperationException("subList not yet implemented!");
    }
}
