/*
 * Copyright (c) 2016 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.impl.map.immutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;

import org.eclipse.collections.api.DoubleIterable;
import org.eclipse.collections.api.ByteIterable;
import org.eclipse.collections.api.LazyDoubleIterable;
import org.eclipse.collections.api.LazyByteIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.ImmutableBag;
import org.eclipse.collections.api.bag.primitive.MutableByteBag;
import org.eclipse.collections.api.bag.primitive.ImmutableByteBag;
import org.eclipse.collections.api.block.function.primitive.ByteToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectByteToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.DoubleBytePredicate;
import org.eclipse.collections.api.block.predicate.primitive.BytePredicate;
import org.eclipse.collections.api.block.procedure.primitive.DoubleByteProcedure;
import org.eclipse.collections.api.block.procedure.primitive.DoubleProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ByteProcedure;
import org.eclipse.collections.api.collection.ImmutableCollection;
import org.eclipse.collections.api.collection.primitive.ImmutableByteCollection;
import org.eclipse.collections.api.collection.primitive.MutableByteCollection;
import org.eclipse.collections.api.iterator.DoubleIterator;
import org.eclipse.collections.api.iterator.ByteIterator;
import org.eclipse.collections.api.list.primitive.MutableByteList;
import org.eclipse.collections.api.map.primitive.DoubleByteMap;
import org.eclipse.collections.api.map.primitive.ImmutableDoubleByteMap;
import org.eclipse.collections.api.map.primitive.MutableDoubleByteMap;
import org.eclipse.collections.api.set.primitive.MutableDoubleSet;
import org.eclipse.collections.api.set.primitive.MutableByteSet;
import org.eclipse.collections.api.tuple.primitive.DoubleBytePair;
import org.eclipse.collections.impl.block.procedure.checked.primitive.CheckedDoubleByteProcedure;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableByteCollection;
import org.eclipse.collections.impl.iterator.UnmodifiableByteIterator;
import org.eclipse.collections.impl.map.mutable.primitive.DoubleByteHashMap;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableDoubleSet;

/**
 * ImmutableDoubleByteHashMap is the non-modifiable equivalent of {@link DoubleByteHashMap}.
 * This file was automatically generated from template file immutablePrimitivePrimitiveHashMap.stg.
 *
 * @since 4.0.
 */
final class ImmutableDoubleByteHashMap implements ImmutableDoubleByteMap, Serializable
{
    private static final long serialVersionUID = 1L;
    private final MutableDoubleByteMap delegate;

    ImmutableDoubleByteHashMap(DoubleByteMap delegate)
    {
        this.delegate = new DoubleByteHashMap(delegate);
    }

    public byte get(double key)
    {
        return this.delegate.get(key);
    }

    public byte getIfAbsent(double key, byte ifAbsent)
    {
        return this.delegate.getIfAbsent(key, ifAbsent);
    }

    public byte getOrThrow(double key)
    {
        return this.delegate.getOrThrow(key);
    }

    public boolean containsKey(double key)
    {
        return this.delegate.containsKey(key);
    }

    public boolean containsValue(byte value)
    {
        return this.delegate.containsValue(value);
    }

    public void forEachValue(ByteProcedure procedure)
    {
        this.delegate.forEachValue(procedure);
    }

    public void forEachKey(DoubleProcedure procedure)
    {
        this.delegate.forEachKey(procedure);
    }

    public void forEachKeyValue(DoubleByteProcedure procedure)
    {
        this.delegate.forEachKeyValue(procedure);
    }

    public LazyDoubleIterable keysView()
    {
        return this.delegate.keysView();
    }

    public RichIterable<DoubleBytePair> keyValuesView()
    {
        return this.delegate.keyValuesView();
    }

    public ImmutableDoubleByteMap select(DoubleBytePredicate predicate)
    {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableDoubleByteMap reject(DoubleBytePredicate predicate)
    {
        return this.delegate.reject(predicate).toImmutable();
    }

    public <T> T injectInto(T injectedValue, ObjectByteToObjectFunction<? super T, ? extends T> function)
    {
        return this.delegate.injectInto(injectedValue, function);
    }

    public ImmutableDoubleByteMap toImmutable()
    {
        return this;
    }

    public ByteIterator byteIterator()
    {
        return new UnmodifiableByteIterator(this.delegate.byteIterator());
    }

    public void forEach(ByteProcedure procedure)
    {
        this.each(procedure);
    }

    /**
     * @since 7.0.
     */
    public void each(ByteProcedure procedure)
    {
        this.delegate.forEach(procedure);
    }

    public int count(BytePredicate predicate)
    {
        return this.delegate.count(predicate);
    }

    public boolean anySatisfy(BytePredicate predicate)
    {
        return this.delegate.anySatisfy(predicate);
    }

    public boolean allSatisfy(BytePredicate predicate)
    {
        return this.delegate.allSatisfy(predicate);
    }

    public boolean noneSatisfy(BytePredicate predicate)
    {
        return this.delegate.noneSatisfy(predicate);
    }

    public ImmutableByteBag select(BytePredicate predicate)
    {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableByteBag reject(BytePredicate predicate)
    {
        return this.delegate.reject(predicate).toImmutable();
    }

    public <V> ImmutableBag<V> collect(ByteToObjectFunction<? extends V> function)
    {
        return this.delegate.collect(function).toImmutable();
    }

    public byte detectIfNone(BytePredicate predicate, byte ifNone)
    {
        return this.delegate.detectIfNone(predicate, ifNone);
    }

    public long sum()
    {
        return this.delegate.sum();
    }

    public byte max()
    {
        return this.delegate.max();
    }

    public byte maxIfEmpty(byte defaultValue)
    {
        return this.delegate.maxIfEmpty(defaultValue);
    }

    public byte min()
    {
        return this.delegate.min();
    }

    public byte minIfEmpty(byte defaultValue)
    {
        return this.delegate.minIfEmpty(defaultValue);
    }

    public double average()
    {
        return this.delegate.average();
    }

    public double median()
    {
        return this.delegate.median();
    }

    public byte[] toSortedArray()
    {
        return this.delegate.toSortedArray();
    }

    public MutableByteList toSortedList()
    {
        return this.delegate.toSortedList();
    }

    public byte[] toArray()
    {
        return this.delegate.toArray();
    }

    public boolean contains(byte value)
    {
        return this.delegate.contains(value);
    }

    public boolean containsAll(byte... source)
    {
        return this.delegate.containsAll(source);
    }

    public boolean containsAll(ByteIterable source)
    {
        return this.delegate.containsAll(source);
    }

    public MutableByteList toList()
    {
        return this.delegate.toList();
    }

    public MutableByteSet toSet()
    {
        return this.delegate.toSet();
    }

    public MutableByteBag toBag()
    {
        return this.delegate.toBag();
    }

    public LazyByteIterable asLazy()
    {
        return this.delegate.asLazy();
    }

    public ImmutableDoubleByteMap newWithKeyValue(double key, byte value)
    {
        MutableDoubleByteMap map = new DoubleByteHashMap(this.size() + 1);
        map.putAll(this);
        map.put(key, value);
        return map.toImmutable();
    }

    public ImmutableDoubleByteMap newWithoutKey(double key)
    {
        MutableDoubleByteMap map = new DoubleByteHashMap(this.size());
        map.putAll(this);
        map.removeKey(key);
        return map.toImmutable();
    }

    public ImmutableDoubleByteMap newWithoutAllKeys(DoubleIterable keys)
    {
        MutableDoubleByteMap map = new DoubleByteHashMap(this.size());
        map.putAll(this);
        DoubleIterator iterator = keys.doubleIterator();
        while (iterator.hasNext())
        {
            map.removeKey(iterator.next());
        }
        return map.toImmutable();
    }

    public int size()
    {
        return this.delegate.size();
    }

    public boolean isEmpty()
    {
        return this.delegate.isEmpty();
    }

    public boolean notEmpty()
    {
        return this.delegate.notEmpty();
    }

    public String makeString()
    {
        return this.delegate.makeString();
    }

    public String makeString(String separator)
    {
        return this.delegate.makeString(separator);
    }

    public String makeString(String start, String separator, String end)
    {
        return this.delegate.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable)
    {
        this.delegate.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator)
    {
        this.delegate.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        this.delegate.appendString(appendable, start, separator, end);
    }

    public MutableDoubleSet keySet()
    {
        return UnmodifiableDoubleSet.of(this.delegate.keySet());
    }

    public MutableByteCollection values()
    {
        return UnmodifiableByteCollection.of(this.delegate.values());
    }

    @Override
    public boolean equals(Object obj)
    {
        return this.delegate.equals(obj);
    }

    @Override
    public int hashCode()
    {
        return this.delegate.hashCode();
    }

    @Override
    public String toString()
    {
        return this.delegate.toString();
    }

    private Object writeReplace()
    {
        return new ImmutableDoubleByteMapSerializationProxy(this);
    }

    protected static class ImmutableDoubleByteMapSerializationProxy implements Externalizable
    {
        private static final long serialVersionUID = 1L;

        private DoubleByteMap map;

        @SuppressWarnings("UnusedDeclaration")
        public ImmutableDoubleByteMapSerializationProxy()
        {
            // Empty constructor for Externalizable class
        }

        protected ImmutableDoubleByteMapSerializationProxy(DoubleByteMap map)
        {
            this.map = map;
        }

        public void writeExternal(final ObjectOutput out) throws IOException
        {
            out.writeInt(this.map.size());
            try
            {
                this.map.forEachKeyValue(new CheckedDoubleByteProcedure()
                {
                    @Override
                    public void safeValue(double key, byte value) throws IOException
                    {
                        out.writeDouble(key);
                        out.writeByte(value);
                    }
                });
            }
            catch (RuntimeException e)
            {
                if (e.getCause() instanceof IOException)
                {
                    throw (IOException) e.getCause();
                }
                throw e;
            }
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException
        {
            int size = in.readInt();
            MutableDoubleByteMap deserializedMap = new DoubleByteHashMap();

            for (int i = 0; i < size; i++)
            {
                deserializedMap.put(in.readDouble(), in.readByte());
            }

            this.map = deserializedMap;
        }

        protected Object readResolve()
        {
            return this.map.toImmutable();
        }
    }
}
