/*
 * Copyright (c) 2016 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.impl.map.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import java.util.NoSuchElementException;

import org.eclipse.collections.api.DoubleIterable;
import org.eclipse.collections.api.FloatIterable;
import org.eclipse.collections.api.LazyDoubleIterable;
import org.eclipse.collections.api.LazyFloatIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.ImmutableBag;
import org.eclipse.collections.api.bag.primitive.ImmutableFloatBag;
import org.eclipse.collections.api.bag.primitive.MutableFloatBag;
import org.eclipse.collections.api.block.function.primitive.FloatToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectFloatToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.DoubleFloatPredicate;
import org.eclipse.collections.api.block.predicate.primitive.FloatPredicate;
import org.eclipse.collections.api.block.procedure.primitive.DoubleProcedure;
import org.eclipse.collections.api.block.procedure.primitive.DoubleFloatProcedure;
import org.eclipse.collections.api.block.procedure.primitive.FloatProcedure;
import org.eclipse.collections.api.collection.primitive.ImmutableFloatCollection;
import org.eclipse.collections.api.collection.primitive.MutableFloatCollection;
import org.eclipse.collections.api.iterator.FloatIterator;
import org.eclipse.collections.api.list.primitive.MutableFloatList;
import org.eclipse.collections.api.map.primitive.DoubleFloatMap;
import org.eclipse.collections.api.map.primitive.ImmutableDoubleFloatMap;
import org.eclipse.collections.api.set.primitive.MutableDoubleSet;
import org.eclipse.collections.api.set.primitive.MutableFloatSet;
import org.eclipse.collections.api.tuple.primitive.DoubleFloatPair;
import org.eclipse.collections.impl.bag.mutable.primitive.FloatHashBag;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableFloatCollection;
import org.eclipse.collections.impl.factory.Bags;
import org.eclipse.collections.impl.factory.primitive.FloatBags;
import org.eclipse.collections.impl.iterator.ImmutableEmptyFloatIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyFloatIterableAdapter;
import org.eclipse.collections.impl.list.mutable.primitive.FloatArrayList;
import org.eclipse.collections.impl.set.mutable.primitive.FloatHashSet;
import org.eclipse.collections.impl.set.mutable.primitive.DoubleHashSet;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableDoubleSet;
import org.eclipse.collections.impl.utility.LazyIterate;
import org.eclipse.collections.impl.utility.primitive.LazyDoubleIterate;

/**
 * ImmutableDoubleFloatEmptyMap is an optimization for {@link ImmutableDoubleFloatMap} of size 0.
 * This file was automatically generated from template file immutablePrimitivePrimitiveEmptyMap.stg.
 *
 * @since 4.0.
 */
final class ImmutableDoubleFloatEmptyMap implements ImmutableDoubleFloatMap, Serializable
{
    static final ImmutableDoubleFloatMap INSTANCE = new ImmutableDoubleFloatEmptyMap();

    private static final long serialVersionUID = 1L;
    private static final float EMPTY_VALUE = 0.0f;

    private Object readResolve()
    {
        return INSTANCE;
    }

    public float get(double key)
    {
        return EMPTY_VALUE;
    }

    public float getIfAbsent(double key, float ifAbsent)
    {
        return ifAbsent;
    }

    public float getOrThrow(double key)
    {
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public boolean containsKey(double key)
    {
        return false;
    }

    public boolean containsValue(float value)
    {
        return false;
    }

    public void forEachValue(FloatProcedure procedure)
    {
    }

    public void forEachKey(DoubleProcedure procedure)
    {
    }

    public void forEachKeyValue(DoubleFloatProcedure procedure)
    {
    }

    public LazyDoubleIterable keysView()
    {
        return LazyDoubleIterate.empty();
    }

    public RichIterable<DoubleFloatPair> keyValuesView()
    {
        return LazyIterate.empty();
    }

    public ImmutableDoubleFloatMap select(DoubleFloatPredicate predicate)
    {
        return this;
    }

    public ImmutableDoubleFloatMap reject(DoubleFloatPredicate predicate)
    {
        return this;
    }

    public ImmutableDoubleFloatMap toImmutable()
    {
        return this;
    }

    public FloatIterator floatIterator()
    {
        return ImmutableEmptyFloatIterator.INSTANCE;
    }

    public void forEach(FloatProcedure procedure)
    {
    }

    /**
     * @since 7.0.
     */
    public void each(FloatProcedure procedure)
    {
    }

    public int count(FloatPredicate predicate)
    {
        return 0;
    }

    public double sum()
    {
        return 0.0;
    }

    public float min()
    {
        throw new NoSuchElementException();
    }

    public float max()
    {
        throw new NoSuchElementException();
    }

    public float maxIfEmpty(float defaultValue)
    {
        return defaultValue;
    }

    public float minIfEmpty(float defaultValue)
    {
        return defaultValue;
    }

    public double average()
    {
        throw new ArithmeticException();
    }

    public double median()
    {
        throw new ArithmeticException();
    }

    public float[] toSortedArray()
    {
        return new float[0];
    }

    public MutableFloatList toSortedList()
    {
        return new FloatArrayList();
    }

    public boolean anySatisfy(FloatPredicate predicate)
    {
        return false;
    }

    public boolean allSatisfy(FloatPredicate predicate)
    {
        return true;
    }

    public boolean noneSatisfy(FloatPredicate predicate)
    {
        return true;
    }

    public ImmutableFloatBag select(FloatPredicate predicate)
    {
        return FloatBags.immutable.empty();
    }

    public ImmutableFloatBag reject(FloatPredicate predicate)
    {
        return FloatBags.immutable.empty();
    }

    public <V> ImmutableBag<V> collect(FloatToObjectFunction<? extends V> function)
    {
        return Bags.immutable.empty();
    }

    public float detectIfNone(FloatPredicate predicate, float ifNone)
    {
        return ifNone;
    }

    public <T> T injectInto(T injectedValue, ObjectFloatToObjectFunction<? super T, ? extends T> function)
    {
        return injectedValue;
    }

    public float[] toArray()
    {
        return new float[0];
    }

    public boolean contains(float value)
    {
        return false;
    }

    public boolean containsAll(float... source)
    {
        return source.length == 0;
    }

    public boolean containsAll(FloatIterable source)
    {
        return source.isEmpty();
    }

    public MutableFloatList toList()
    {
        return new FloatArrayList();
    }

    public MutableFloatSet toSet()
    {
        return new FloatHashSet();
    }

    public MutableFloatBag toBag()
    {
        return new FloatHashBag();
    }

    public LazyFloatIterable asLazy()
    {
        return new LazyFloatIterableAdapter(this);
    }

    public ImmutableDoubleFloatMap newWithKeyValue(double key, float value)
    {
        return new ImmutableDoubleFloatSingletonMap(key, value);
    }

    public ImmutableDoubleFloatMap newWithoutKey(double key)
    {
        return this;
    }

    public ImmutableDoubleFloatMap newWithoutAllKeys(DoubleIterable keys)
    {
        return this;
    }

    public int size()
    {
        return 0;
    }

    public boolean isEmpty()
    {
        return true;
    }

    public boolean notEmpty()
    {
        return false;
    }

    public MutableDoubleSet keySet()
    {
        return UnmodifiableDoubleSet.of(new DoubleHashSet());
    }

    public MutableFloatCollection values()
    {
        return UnmodifiableFloatCollection.of(new FloatArrayList());
    }

    @Override
    public boolean equals(Object obj)
    {
        if (obj == this)
        {
            return true;
        }
        if (!(obj instanceof DoubleFloatMap))
        {
            return false;
        }
        DoubleFloatMap map = (DoubleFloatMap) obj;
        return map.isEmpty();
    }

    @Override
    public int hashCode()
    {
        return 0;
    }

    @Override
    public String toString()
    {
        return "{}";
    }

    public String makeString()
    {
        return "";
    }

    public String makeString(String separator)
    {
        return "";
    }

    public String makeString(String start, String separator, String end)
    {
        return start + end;
    }

    public void appendString(Appendable appendable)
    {
    }

    public void appendString(Appendable appendable, String separator)
    {
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        try
        {
            appendable.append(start);
            appendable.append(end);
        }
        catch (IOException e)
        {
            throw new RuntimeException(e);
        }
    }
}
