/*
 * Copyright (c) 2016 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.impl.map.immutable.primitive;

import org.eclipse.collections.api.factory.map.primitive.ImmutableLongIntMapFactory;
import org.eclipse.collections.api.map.primitive.ImmutableLongIntMap;
import org.eclipse.collections.api.map.primitive.LongIntMap;

/**
 * ImmutableLongIntMapFactoryImpl is a factory implementation which creates instances of type {@link ImmutableLongIntMap}.
 * This file was automatically generated from template file immutablePrimitivePrimitiveMapFactoryImpl.stg.
 *
 * @since 4.0.
 */
public class ImmutableLongIntMapFactoryImpl implements ImmutableLongIntMapFactory
{
    public ImmutableLongIntMap empty()
    {
        return ImmutableLongIntEmptyMap.INSTANCE;
    }

    public ImmutableLongIntMap of()
    {
        return this.empty();
    }

    public ImmutableLongIntMap with()
    {
        return this.empty();
    }

    public ImmutableLongIntMap of(long key, int value)
    {
        return this.with(key, value);
    }

    public ImmutableLongIntMap with(long key, int value)
    {
        return new ImmutableLongIntSingletonMap(key, value);
    }

    public ImmutableLongIntMap ofAll(LongIntMap map)
    {
        return this.withAll(map);
    }

    public ImmutableLongIntMap withAll(LongIntMap map)
    {
        if (map instanceof ImmutableLongIntMap)
        {
            return (ImmutableLongIntMap) map;
        }
        if (map.isEmpty())
        {
            return this.with();
        }
        if (map.size() == 1)
        {
            long key = map.keysView().longIterator().next();
            return new ImmutableLongIntSingletonMap(key, map.get(key));
        }
        return new ImmutableLongIntHashMap(map);
    }
}
