/*
 * Copyright (c) 2016 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.impl.map.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import java.util.NoSuchElementException;

import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.LazyLongIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.ImmutableBag;
import org.eclipse.collections.api.bag.primitive.ImmutableLongBag;
import org.eclipse.collections.api.bag.primitive.MutableLongBag;
import org.eclipse.collections.api.block.function.primitive.LongToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectLongToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.LongLongPredicate;
import org.eclipse.collections.api.block.predicate.primitive.LongPredicate;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.block.procedure.primitive.LongLongProcedure;
import org.eclipse.collections.api.collection.primitive.ImmutableLongCollection;
import org.eclipse.collections.api.collection.primitive.MutableLongCollection;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.api.map.primitive.LongLongMap;
import org.eclipse.collections.api.map.primitive.ImmutableLongLongMap;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.api.tuple.primitive.LongLongPair;
import org.eclipse.collections.impl.bag.mutable.primitive.LongHashBag;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableLongCollection;
import org.eclipse.collections.impl.factory.Bags;
import org.eclipse.collections.impl.factory.primitive.LongBags;
import org.eclipse.collections.impl.iterator.ImmutableEmptyLongIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyLongIterableAdapter;
import org.eclipse.collections.impl.list.mutable.primitive.LongArrayList;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableLongSet;
import org.eclipse.collections.impl.utility.LazyIterate;
import org.eclipse.collections.impl.utility.primitive.LazyLongIterate;

/**
 * ImmutableLongLongEmptyMap is an optimization for {@link ImmutableLongLongMap} of size 0.
 * This file was automatically generated from template file immutablePrimitivePrimitiveEmptyMap.stg.
 *
 * @since 4.0.
 */
final class ImmutableLongLongEmptyMap implements ImmutableLongLongMap, Serializable
{
    static final ImmutableLongLongMap INSTANCE = new ImmutableLongLongEmptyMap();

    private static final long serialVersionUID = 1L;
    private static final long EMPTY_VALUE = 0L;

    private Object readResolve()
    {
        return INSTANCE;
    }

    public long get(long key)
    {
        return EMPTY_VALUE;
    }

    public long getIfAbsent(long key, long ifAbsent)
    {
        return ifAbsent;
    }

    public long getOrThrow(long key)
    {
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public boolean containsKey(long key)
    {
        return false;
    }

    public boolean containsValue(long value)
    {
        return false;
    }

    public void forEachValue(LongProcedure procedure)
    {
    }

    public void forEachKey(LongProcedure procedure)
    {
    }

    public void forEachKeyValue(LongLongProcedure procedure)
    {
    }

    public LazyLongIterable keysView()
    {
        return LazyLongIterate.empty();
    }

    public RichIterable<LongLongPair> keyValuesView()
    {
        return LazyIterate.empty();
    }

    public ImmutableLongLongMap select(LongLongPredicate predicate)
    {
        return this;
    }

    public ImmutableLongLongMap reject(LongLongPredicate predicate)
    {
        return this;
    }

    public ImmutableLongLongMap toImmutable()
    {
        return this;
    }

    public LongIterator longIterator()
    {
        return ImmutableEmptyLongIterator.INSTANCE;
    }

    public void forEach(LongProcedure procedure)
    {
    }

    /**
     * @since 7.0.
     */
    public void each(LongProcedure procedure)
    {
    }

    public int count(LongPredicate predicate)
    {
        return 0;
    }

    public long sum()
    {
        return 0L;
    }

    public long min()
    {
        throw new NoSuchElementException();
    }

    public long max()
    {
        throw new NoSuchElementException();
    }

    public long maxIfEmpty(long defaultValue)
    {
        return defaultValue;
    }

    public long minIfEmpty(long defaultValue)
    {
        return defaultValue;
    }

    public double average()
    {
        throw new ArithmeticException();
    }

    public double median()
    {
        throw new ArithmeticException();
    }

    public long[] toSortedArray()
    {
        return new long[0];
    }

    public MutableLongList toSortedList()
    {
        return new LongArrayList();
    }

    public boolean anySatisfy(LongPredicate predicate)
    {
        return false;
    }

    public boolean allSatisfy(LongPredicate predicate)
    {
        return true;
    }

    public boolean noneSatisfy(LongPredicate predicate)
    {
        return true;
    }

    public ImmutableLongBag select(LongPredicate predicate)
    {
        return LongBags.immutable.empty();
    }

    public ImmutableLongBag reject(LongPredicate predicate)
    {
        return LongBags.immutable.empty();
    }

    public <V> ImmutableBag<V> collect(LongToObjectFunction<? extends V> function)
    {
        return Bags.immutable.empty();
    }

    public long detectIfNone(LongPredicate predicate, long ifNone)
    {
        return ifNone;
    }

    public <T> T injectInto(T injectedValue, ObjectLongToObjectFunction<? super T, ? extends T> function)
    {
        return injectedValue;
    }

    public long[] toArray()
    {
        return new long[0];
    }

    public boolean contains(long value)
    {
        return false;
    }

    public boolean containsAll(long... source)
    {
        return source.length == 0;
    }

    public boolean containsAll(LongIterable source)
    {
        return source.isEmpty();
    }

    public MutableLongList toList()
    {
        return new LongArrayList();
    }

    public MutableLongSet toSet()
    {
        return new LongHashSet();
    }

    public MutableLongBag toBag()
    {
        return new LongHashBag();
    }

    public LazyLongIterable asLazy()
    {
        return new LazyLongIterableAdapter(this);
    }

    public ImmutableLongLongMap newWithKeyValue(long key, long value)
    {
        return new ImmutableLongLongSingletonMap(key, value);
    }

    public ImmutableLongLongMap newWithoutKey(long key)
    {
        return this;
    }

    public ImmutableLongLongMap newWithoutAllKeys(LongIterable keys)
    {
        return this;
    }

    public int size()
    {
        return 0;
    }

    public boolean isEmpty()
    {
        return true;
    }

    public boolean notEmpty()
    {
        return false;
    }

    public MutableLongSet keySet()
    {
        return UnmodifiableLongSet.of(new LongHashSet());
    }

    public MutableLongCollection values()
    {
        return UnmodifiableLongCollection.of(new LongArrayList());
    }

    @Override
    public boolean equals(Object obj)
    {
        if (obj == this)
        {
            return true;
        }
        if (!(obj instanceof LongLongMap))
        {
            return false;
        }
        LongLongMap map = (LongLongMap) obj;
        return map.isEmpty();
    }

    @Override
    public int hashCode()
    {
        return 0;
    }

    @Override
    public String toString()
    {
        return "{}";
    }

    public String makeString()
    {
        return "";
    }

    public String makeString(String separator)
    {
        return "";
    }

    public String makeString(String start, String separator, String end)
    {
        return start + end;
    }

    public void appendString(Appendable appendable)
    {
    }

    public void appendString(Appendable appendable, String separator)
    {
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        try
        {
            appendable.append(start);
            appendable.append(end);
        }
        catch (IOException e)
        {
            throw new RuntimeException(e);
        }
    }
}
