/*
 * Copyright (c) 2016 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.impl.map.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import java.util.NoSuchElementException;

import org.eclipse.collections.api.ShortIterable;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.LazyShortIterable;
import org.eclipse.collections.api.LazyIntIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.ImmutableBag;
import org.eclipse.collections.api.bag.primitive.ImmutableIntBag;
import org.eclipse.collections.api.bag.primitive.MutableIntBag;
import org.eclipse.collections.api.block.function.primitive.IntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.ShortIntPredicate;
import org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import org.eclipse.collections.api.block.procedure.primitive.ShortProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ShortIntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.IntProcedure;
import org.eclipse.collections.api.collection.primitive.ImmutableIntCollection;
import org.eclipse.collections.api.collection.primitive.MutableIntCollection;
import org.eclipse.collections.api.iterator.IntIterator;
import org.eclipse.collections.api.list.primitive.MutableIntList;
import org.eclipse.collections.api.map.primitive.ShortIntMap;
import org.eclipse.collections.api.map.primitive.ImmutableShortIntMap;
import org.eclipse.collections.api.set.primitive.MutableShortSet;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.api.tuple.primitive.ShortIntPair;
import org.eclipse.collections.impl.bag.mutable.primitive.IntHashBag;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableIntCollection;
import org.eclipse.collections.impl.factory.Bags;
import org.eclipse.collections.impl.factory.primitive.IntBags;
import org.eclipse.collections.impl.iterator.ImmutableEmptyIntIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyIntIterableAdapter;
import org.eclipse.collections.impl.list.mutable.primitive.IntArrayList;
import org.eclipse.collections.impl.set.mutable.primitive.IntHashSet;
import org.eclipse.collections.impl.set.mutable.primitive.ShortHashSet;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableShortSet;
import org.eclipse.collections.impl.utility.LazyIterate;
import org.eclipse.collections.impl.utility.primitive.LazyShortIterate;

/**
 * ImmutableShortIntEmptyMap is an optimization for {@link ImmutableShortIntMap} of size 0.
 * This file was automatically generated from template file immutablePrimitivePrimitiveEmptyMap.stg.
 *
 * @since 4.0.
 */
final class ImmutableShortIntEmptyMap implements ImmutableShortIntMap, Serializable
{
    static final ImmutableShortIntMap INSTANCE = new ImmutableShortIntEmptyMap();

    private static final long serialVersionUID = 1L;
    private static final int EMPTY_VALUE = 0;

    private Object readResolve()
    {
        return INSTANCE;
    }

    public int get(short key)
    {
        return EMPTY_VALUE;
    }

    public int getIfAbsent(short key, int ifAbsent)
    {
        return ifAbsent;
    }

    public int getOrThrow(short key)
    {
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public boolean containsKey(short key)
    {
        return false;
    }

    public boolean containsValue(int value)
    {
        return false;
    }

    public void forEachValue(IntProcedure procedure)
    {
    }

    public void forEachKey(ShortProcedure procedure)
    {
    }

    public void forEachKeyValue(ShortIntProcedure procedure)
    {
    }

    public LazyShortIterable keysView()
    {
        return LazyShortIterate.empty();
    }

    public RichIterable<ShortIntPair> keyValuesView()
    {
        return LazyIterate.empty();
    }

    public ImmutableShortIntMap select(ShortIntPredicate predicate)
    {
        return this;
    }

    public ImmutableShortIntMap reject(ShortIntPredicate predicate)
    {
        return this;
    }

    public ImmutableShortIntMap toImmutable()
    {
        return this;
    }

    public IntIterator intIterator()
    {
        return ImmutableEmptyIntIterator.INSTANCE;
    }

    public void forEach(IntProcedure procedure)
    {
    }

    /**
     * @since 7.0.
     */
    public void each(IntProcedure procedure)
    {
    }

    public int count(IntPredicate predicate)
    {
        return 0;
    }

    public long sum()
    {
        return 0L;
    }

    public int min()
    {
        throw new NoSuchElementException();
    }

    public int max()
    {
        throw new NoSuchElementException();
    }

    public int maxIfEmpty(int defaultValue)
    {
        return defaultValue;
    }

    public int minIfEmpty(int defaultValue)
    {
        return defaultValue;
    }

    public double average()
    {
        throw new ArithmeticException();
    }

    public double median()
    {
        throw new ArithmeticException();
    }

    public int[] toSortedArray()
    {
        return new int[0];
    }

    public MutableIntList toSortedList()
    {
        return new IntArrayList();
    }

    public boolean anySatisfy(IntPredicate predicate)
    {
        return false;
    }

    public boolean allSatisfy(IntPredicate predicate)
    {
        return true;
    }

    public boolean noneSatisfy(IntPredicate predicate)
    {
        return true;
    }

    public ImmutableIntBag select(IntPredicate predicate)
    {
        return IntBags.immutable.empty();
    }

    public ImmutableIntBag reject(IntPredicate predicate)
    {
        return IntBags.immutable.empty();
    }

    public <V> ImmutableBag<V> collect(IntToObjectFunction<? extends V> function)
    {
        return Bags.immutable.empty();
    }

    public int detectIfNone(IntPredicate predicate, int ifNone)
    {
        return ifNone;
    }

    public <T> T injectInto(T injectedValue, ObjectIntToObjectFunction<? super T, ? extends T> function)
    {
        return injectedValue;
    }

    public int[] toArray()
    {
        return new int[0];
    }

    public boolean contains(int value)
    {
        return false;
    }

    public boolean containsAll(int... source)
    {
        return source.length == 0;
    }

    public boolean containsAll(IntIterable source)
    {
        return source.isEmpty();
    }

    public MutableIntList toList()
    {
        return new IntArrayList();
    }

    public MutableIntSet toSet()
    {
        return new IntHashSet();
    }

    public MutableIntBag toBag()
    {
        return new IntHashBag();
    }

    public LazyIntIterable asLazy()
    {
        return new LazyIntIterableAdapter(this);
    }

    public ImmutableShortIntMap newWithKeyValue(short key, int value)
    {
        return new ImmutableShortIntSingletonMap(key, value);
    }

    public ImmutableShortIntMap newWithoutKey(short key)
    {
        return this;
    }

    public ImmutableShortIntMap newWithoutAllKeys(ShortIterable keys)
    {
        return this;
    }

    public int size()
    {
        return 0;
    }

    public boolean isEmpty()
    {
        return true;
    }

    public boolean notEmpty()
    {
        return false;
    }

    public MutableShortSet keySet()
    {
        return UnmodifiableShortSet.of(new ShortHashSet());
    }

    public MutableIntCollection values()
    {
        return UnmodifiableIntCollection.of(new IntArrayList());
    }

    @Override
    public boolean equals(Object obj)
    {
        if (obj == this)
        {
            return true;
        }
        if (!(obj instanceof ShortIntMap))
        {
            return false;
        }
        ShortIntMap map = (ShortIntMap) obj;
        return map.isEmpty();
    }

    @Override
    public int hashCode()
    {
        return 0;
    }

    @Override
    public String toString()
    {
        return "{}";
    }

    public String makeString()
    {
        return "";
    }

    public String makeString(String separator)
    {
        return "";
    }

    public String makeString(String start, String separator, String end)
    {
        return start + end;
    }

    public void appendString(Appendable appendable)
    {
    }

    public void appendString(Appendable appendable, String separator)
    {
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        try
        {
            appendable.append(start);
            appendable.append(end);
        }
        catch (IOException e)
        {
            throw new RuntimeException(e);
        }
    }
}
