/*
 * Copyright (c) 2016 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.impl.set.immutable.primitive;

import org.eclipse.collections.api.FloatIterable;
import org.eclipse.collections.api.set.primitive.ImmutableFloatSet;
import org.eclipse.collections.api.set.primitive.FloatSet;
import org.eclipse.collections.impl.set.mutable.primitive.FloatHashSet;
import org.eclipse.collections.impl.set.primitive.AbstractFloatSet;

/**
 * This file was automatically generated from template file abstractImmutablePrimitiveSet.stg.
 *
 * @since 6.0.
 */
public abstract class AbstractImmutableFloatSet extends AbstractFloatSet implements ImmutableFloatSet
{
    public ImmutableFloatSet newWith(float element)
    {
        return FloatHashSet.newSet(this).with(element).toImmutable();
    }

    public ImmutableFloatSet newWithout(float element)
    {
        return FloatHashSet.newSet(this).without(element).toImmutable();
    }

    public ImmutableFloatSet newWithAll(FloatIterable elements)
    {
        return FloatHashSet.newSet(this).withAll(elements).toImmutable();
    }

    public ImmutableFloatSet newWithoutAll(FloatIterable elements)
    {
        return FloatHashSet.newSet(this).withoutAll(elements).toImmutable();
    }

    public FloatSet freeze()
    {
        return this;
    }

    public ImmutableFloatSet toImmutable()
    {
        return this;
    }
}
