/*
 * Copyright (c) 2016 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.impl.set.immutable.primitive;

import org.eclipse.collections.api.ShortIterable;
import org.eclipse.collections.api.factory.set.primitive.ImmutableShortSetFactory;
import org.eclipse.collections.api.set.primitive.ImmutableShortSet;
import org.eclipse.collections.impl.set.mutable.primitive.ShortHashSet;

/**
 * ImmutableShortSetFactoryImpl is a factory implementation which creates instances of type {@link ImmutableShortSet}.
 * This file was automatically generated from template file immutablePrimitiveSetFactoryImpl.stg.
 *
 * @since 4.0.
 */
public class ImmutableShortSetFactoryImpl implements ImmutableShortSetFactory
{
    public ImmutableShortSet empty()
    {
        return ImmutableShortEmptySet.INSTANCE;
    }

    public ImmutableShortSet of()
    {
        return this.empty();
    }

    public ImmutableShortSet with()
    {
        return this.empty();
    }

    public ImmutableShortSet of(short one)
    {
        return this.with(one);
    }

    public ImmutableShortSet with(short one)
    {
        return new ImmutableShortSingletonSet(one);
    }

    public ImmutableShortSet of(short... items)
    {
        return this.with(items);
    }

    public ImmutableShortSet with(short... items)
    {
        if (items == null || items.length == 0)
        {
            return this.with();
        }
        if (items.length == 1)
        {
            return this.with(items[0]);
        }
        return ShortHashSet.newSetWith(items).toImmutable();
    }

    public ImmutableShortSet ofAll(ShortIterable items)
    {
        return this.withAll(items);
    }

    public ImmutableShortSet withAll(ShortIterable items)
    {
        if (items instanceof ImmutableShortSet)
        {
            return (ImmutableShortSet) items;
        }
        return this.with(items.toArray());
    }
}
