/*
 * Copyright (c) 2016 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.impl.set.mutable.primitive;

import org.eclipse.collections.api.ShortIterable;
import org.eclipse.collections.api.factory.set.primitive.MutableShortSetFactory;
import org.eclipse.collections.api.set.primitive.MutableShortSet;

/**
 * MutableShortSetFactoryImpl is a factory implementation which creates instances of type {@link MutableShortSet}.
 * This file was automatically generated from template file mutablePrimitiveSetFactoryImpl.stg.
 *
 * @since 6.0.
 */
public class MutableShortSetFactoryImpl implements MutableShortSetFactory
{
    public MutableShortSet empty()
    {
        return new ShortHashSet();
    }

    public MutableShortSet of()
    {
        return this.empty();
    }

    public MutableShortSet with()
    {
        return this.empty();
    }

    public MutableShortSet of(short... items)
    {
        return this.with(items);
    }

    public MutableShortSet with(short... items)
    {
        if (items == null || items.length == 0)
        {
            return this.empty();
        }
        return ShortHashSet.newSetWith(items);
    }

    public MutableShortSet ofAll(ShortIterable items)
    {
        return this.withAll(items);
    }

    public MutableShortSet withAll(ShortIterable items)
    {
        return ShortHashSet.newSet(items);
    }
}
