/*
 * Copyright (c) 2016 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.impl.stack.immutable.primitive;

import org.eclipse.collections.api.CharIterable;
import org.eclipse.collections.api.factory.stack.primitive.ImmutableCharStackFactory;
import org.eclipse.collections.api.stack.primitive.ImmutableCharStack;

/**
 * ImmutableCharStackFactoryImpl is a factory implementation which creates instances of type {@link ImmutableCharStack}.
 * This file was automatically generated from template file immutablePrimitiveStackFactoryImpl.stg.
 *
 * @since 4.0.
 */
public class ImmutableCharStackFactoryImpl implements ImmutableCharStackFactory
{
    public ImmutableCharStack empty()
    {
        return ImmutableCharEmptyStack.INSTANCE;
    }

    public ImmutableCharStack of()
    {
        return this.empty();
    }

    public ImmutableCharStack with()
    {
        return this.empty();
    }

    public ImmutableCharStack of(char one)
    {
        return this.with(one);
    }

    public ImmutableCharStack with(char one)
    {
        return new ImmutableCharSingletonStack(one);
    }

    public ImmutableCharStack of(char... items)
    {
        return this.with(items);
    }

    public ImmutableCharStack with(char... items)
    {
        if (items == null || items.length == 0)
        {
            return this.with();
        }
        if (items.length == 1)
        {
            return this.with(items[0]);
        }
        return ImmutableCharArrayStack.newStackWith(items);
    }

    public ImmutableCharStack ofAll(CharIterable items)
    {
        return this.withAll(items);
    }

    public ImmutableCharStack withAll(CharIterable items)
    {
        if (items instanceof ImmutableCharStack)
        {
            return (ImmutableCharStack) items;
        }
        return this.with(items.toArray());
    }

    public ImmutableCharStack ofAllReversed(CharIterable items)
    {
        return this.withAllReversed(items);
    }

    public ImmutableCharStack withAllReversed(CharIterable items)
    {
        if (items == null || items.isEmpty())
        {
            return this.with();
        }
        if (items.size() == 1)
        {
            return this.with(items.toArray());
        }
        return ImmutableCharArrayStack.newStackFromTopToBottom(items);
    }
}
