/*
 * Copyright (c) 2016 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.impl.stack.immutable.primitive;

import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.factory.stack.primitive.ImmutableIntStackFactory;
import org.eclipse.collections.api.stack.primitive.ImmutableIntStack;

/**
 * ImmutableIntStackFactoryImpl is a factory implementation which creates instances of type {@link ImmutableIntStack}.
 * This file was automatically generated from template file immutablePrimitiveStackFactoryImpl.stg.
 *
 * @since 4.0.
 */
public class ImmutableIntStackFactoryImpl implements ImmutableIntStackFactory
{
    public ImmutableIntStack empty()
    {
        return ImmutableIntEmptyStack.INSTANCE;
    }

    public ImmutableIntStack of()
    {
        return this.empty();
    }

    public ImmutableIntStack with()
    {
        return this.empty();
    }

    public ImmutableIntStack of(int one)
    {
        return this.with(one);
    }

    public ImmutableIntStack with(int one)
    {
        return new ImmutableIntSingletonStack(one);
    }

    public ImmutableIntStack of(int... items)
    {
        return this.with(items);
    }

    public ImmutableIntStack with(int... items)
    {
        if (items == null || items.length == 0)
        {
            return this.with();
        }
        if (items.length == 1)
        {
            return this.with(items[0]);
        }
        return ImmutableIntArrayStack.newStackWith(items);
    }

    public ImmutableIntStack ofAll(IntIterable items)
    {
        return this.withAll(items);
    }

    public ImmutableIntStack withAll(IntIterable items)
    {
        if (items instanceof ImmutableIntStack)
        {
            return (ImmutableIntStack) items;
        }
        return this.with(items.toArray());
    }

    public ImmutableIntStack ofAllReversed(IntIterable items)
    {
        return this.withAllReversed(items);
    }

    public ImmutableIntStack withAllReversed(IntIterable items)
    {
        if (items == null || items.isEmpty())
        {
            return this.with();
        }
        if (items.size() == 1)
        {
            return this.with(items.toArray());
        }
        return ImmutableIntArrayStack.newStackFromTopToBottom(items);
    }
}
