/*
 * Copyright (c) 2016 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.impl.collection.mutable.primitive;

import java.io.Serializable;

import org.eclipse.collections.api.CharIterable;
import org.eclipse.collections.api.LazyCharIterable;
import org.eclipse.collections.api.bag.primitive.MutableCharBag;
import org.eclipse.collections.api.block.function.primitive.CharToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectCharToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.CharPredicate;
import org.eclipse.collections.api.block.procedure.primitive.CharProcedure;
import org.eclipse.collections.api.collection.MutableCollection;
import org.eclipse.collections.api.collection.primitive.ImmutableCharCollection;
import org.eclipse.collections.api.collection.primitive.MutableCharCollection;
import org.eclipse.collections.api.iterator.MutableCharIterator;
import org.eclipse.collections.api.list.primitive.MutableCharList;
import org.eclipse.collections.api.set.primitive.MutableCharSet;
import org.eclipse.collections.impl.iterator.UnmodifiableCharIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyCharIterableAdapter;
import net.jcip.annotations.ThreadSafe;

/**
 * This file was automatically generated from template file abstractUnmodifiablePrimitiveCollection.stg.
 *
 * @since 3.1.
 */
@ThreadSafe
public abstract class AbstractUnmodifiableCharCollection
        implements MutableCharCollection, Serializable
{
    private static final long serialVersionUID = 1L;

    private final MutableCharCollection collection;

    protected AbstractUnmodifiableCharCollection(MutableCharCollection collection)
    {
        this.collection = collection;
    }

    protected MutableCharCollection getCharCollection()
    {
        return this.collection;
    }

    public int size()
    {
        return this.collection.size();
    }

    public boolean isEmpty()
    {
        return this.collection.isEmpty();
    }

    public boolean notEmpty()
    {
        return this.collection.notEmpty();
    }

    public void clear()
    {
        throw new UnsupportedOperationException("Cannot call clear() on " + this.getClass().getSimpleName());
    }

    public boolean contains(char value)
    {
        return this.collection.contains(value);
    }

    public boolean containsAll(char... source)
    {
        return this.collection.containsAll(source);
    }

    public boolean containsAll(CharIterable source)
    {
        return this.collection.containsAll(source);
    }

    public boolean add(char newItem)
    {
        throw new UnsupportedOperationException("Cannot call add() on " + this.getClass().getSimpleName());
    }

    public boolean addAll(char... source)
    {
        throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
    }

    public boolean addAll(CharIterable source)
    {
        throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
    }

    public boolean remove(char value)
    {
        throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
    }

    public boolean removeAll(CharIterable source)
    {
        throw new UnsupportedOperationException("Cannot call removeAll() on " + this.getClass().getSimpleName());
    }

    public boolean removeAll(char... source)
    {
        throw new UnsupportedOperationException("Cannot call removeAll() on " + this.getClass().getSimpleName());
    }

    public boolean retainAll(CharIterable source)
    {
        throw new UnsupportedOperationException("Cannot call retainAll() on " + this.getClass().getSimpleName());
    }

    public boolean retainAll(char... source)
    {
        throw new UnsupportedOperationException("Cannot call retainAll() on " + this.getClass().getSimpleName());
    }

    public MutableCharIterator charIterator()
    {
        return new UnmodifiableCharIterator(this.collection.charIterator());
    }

    public void forEach(CharProcedure procedure)
    {
        this.each(procedure);
    }

    /**
     * @since 7.0.
     */
    public void each(CharProcedure procedure)
    {
        this.collection.forEach(procedure);
    }

    public int count(CharPredicate predicate)
    {
        return this.collection.count(predicate);
    }

    public boolean anySatisfy(CharPredicate predicate)
    {
        return this.collection.anySatisfy(predicate);
    }

    public boolean allSatisfy(CharPredicate predicate)
    {
        return this.collection.allSatisfy(predicate);
    }

    public boolean noneSatisfy(CharPredicate predicate)
    {
        return this.collection.noneSatisfy(predicate);
    }

    public MutableCharCollection select(CharPredicate predicate)
    {
        return this.collection.select(predicate);
    }

    public MutableCharCollection reject(CharPredicate predicate)
    {
        return this.collection.reject(predicate);
    }

    public <V> MutableCollection<V> collect(CharToObjectFunction<? extends V> function)
    {
        return this.collection.collect(function);
    }

    public MutableCharCollection with(char element)
    {
        throw new UnsupportedOperationException("Cannot call with() on " + this.getClass().getSimpleName());
    }

    public MutableCharCollection without(char element)
    {
        throw new UnsupportedOperationException("Cannot call without() on " + this.getClass().getSimpleName());
    }

    public MutableCharCollection withAll(CharIterable elements)
    {
        throw new UnsupportedOperationException("Cannot call withAll() on " + this.getClass().getSimpleName());
    }

    public MutableCharCollection withoutAll(CharIterable elements)
    {
        throw new UnsupportedOperationException("Cannot call withoutAll() on " + this.getClass().getSimpleName());
    }

    public MutableCharCollection asUnmodifiable()
    {
        return this;
    }

    public MutableCharCollection asSynchronized()
    {
        return new SynchronizedCharCollection(this);
    }

    public ImmutableCharCollection toImmutable()
    {
        return this.collection.toImmutable();
    }

    public LazyCharIterable asLazy()
    {
        return new LazyCharIterableAdapter(this);
    }

    public char detectIfNone(CharPredicate predicate, char ifNone)
    {
        return this.collection.detectIfNone(predicate, ifNone);
    }

    public long sum()
    {
        return this.collection.sum();
    }

    public char max()
    {
        return this.collection.max();
    }

    public char min()
    {
        return this.collection.min();
    }

    public char minIfEmpty(char defaultValue)
    {
        return this.collection.minIfEmpty(defaultValue);
    }

    public char maxIfEmpty(char defaultValue)
    {
        return this.collection.maxIfEmpty(defaultValue);
    }

    public double average()
    {
        return this.collection.average();
    }

    public double median()
    {
        return this.collection.median();
    }

    public MutableCharList toSortedList()
    {
        return this.collection.toSortedList();
    }

    public char[] toSortedArray()
    {
        return this.collection.toSortedArray();
    }

    public char[] toArray()
    {
        return this.collection.toArray();
    }

    @Override
    public String toString()
    {
        return this.collection.toString();
    }

    public String makeString()
    {
        return this.collection.makeString();
    }

    public String makeString(String separator)
    {
        return this.collection.makeString(separator);
    }

    public String makeString(String start, String separator, String end)
    {
        return this.collection.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable)
    {
        this.collection.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator)
    {
        this.collection.appendString(appendable, separator);
    }

    public void appendString(
            Appendable appendable,
            String start,
            String separator,
            String end)
    {
        this.collection.appendString(appendable, start, separator, end);
    }

    public MutableCharList toList()
    {
        return this.collection.toList();
    }

    public MutableCharSet toSet()
    {
        return this.collection.toSet();
    }

    public MutableCharBag toBag()
    {
        return this.collection.toBag();
    }

    public <T> T injectInto(T injectedValue, ObjectCharToObjectFunction<? super T, ? extends T> function)
    {
        return this.collection.injectInto(injectedValue, function);
    }
}
