/*
 * Copyright (c) 2016 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.impl.lazy.primitive;

import java.util.Iterator;

import org.eclipse.collections.api.FloatIterable;
import org.eclipse.collections.api.block.function.primitive.FloatToIntFunction;
import org.eclipse.collections.api.block.procedure.primitive.FloatProcedure;
import org.eclipse.collections.api.block.procedure.primitive.IntProcedure;
import org.eclipse.collections.api.iterator.FloatIterator;
import org.eclipse.collections.api.iterator.IntIterator;

/**
 * This file was automatically generated from template file collectPrimitiveToPrimitiveIterable.stg.
 */
public class CollectFloatToIntIterable
        extends AbstractLazyIntIterable
{
    private final FloatIterable iterable;
    private final FloatToIntFunction function;

    public CollectFloatToIntIterable(FloatIterable iterable, FloatToIntFunction function)
    {
        this.iterable = iterable;
        this.function = function;
    }

    public void each(final IntProcedure procedure)
    {
        this.iterable.forEach(new FloatProcedure()
        {
            public void value(float each)
            {
                procedure.value(CollectFloatToIntIterable.this.function.valueOf(each));
            }
        });
    }

    public IntIterator intIterator()
    {
        return new IntIterator()
        {
            private final FloatIterator iterator = CollectFloatToIntIterable.this.iterable.floatIterator();

            public boolean hasNext()
            {
                return this.iterator.hasNext();
            }

            public int next()
            {
                return CollectFloatToIntIterable.this.function.valueOf(this.iterator.next());
            }
        };
    }

    @Override
    public int size()
    {
        return this.iterable.size();
    }

    @Override
    public boolean isEmpty()
    {
        return this.iterable.isEmpty();
    }

    @Override
    public boolean notEmpty()
    {
        return this.iterable.notEmpty();
    }
}
