/*
 * Copyright (c) 2016 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.impl.map.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import java.util.NoSuchElementException;

import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.LazyIntIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.ImmutableBag;
import org.eclipse.collections.api.bag.primitive.ImmutableIntBag;
import org.eclipse.collections.api.bag.primitive.MutableIntBag;
import org.eclipse.collections.api.block.function.primitive.IntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.IntIntPredicate;
import org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import org.eclipse.collections.api.block.procedure.primitive.IntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.IntIntProcedure;
import org.eclipse.collections.api.collection.primitive.ImmutableIntCollection;
import org.eclipse.collections.api.collection.primitive.MutableIntCollection;
import org.eclipse.collections.api.iterator.IntIterator;
import org.eclipse.collections.api.list.primitive.MutableIntList;
import org.eclipse.collections.api.map.primitive.IntIntMap;
import org.eclipse.collections.api.map.primitive.ImmutableIntIntMap;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.api.tuple.primitive.IntIntPair;
import org.eclipse.collections.impl.bag.mutable.primitive.IntHashBag;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableIntCollection;
import org.eclipse.collections.impl.factory.Bags;
import org.eclipse.collections.impl.factory.primitive.IntBags;
import org.eclipse.collections.impl.iterator.ImmutableEmptyIntIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyIntIterableAdapter;
import org.eclipse.collections.impl.list.mutable.primitive.IntArrayList;
import org.eclipse.collections.impl.set.mutable.primitive.IntHashSet;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableIntSet;
import org.eclipse.collections.impl.utility.LazyIterate;
import org.eclipse.collections.impl.utility.primitive.LazyIntIterate;

/**
 * ImmutableIntIntEmptyMap is an optimization for {@link ImmutableIntIntMap} of size 0.
 * This file was automatically generated from template file immutablePrimitivePrimitiveEmptyMap.stg.
 *
 * @since 4.0.
 */
final class ImmutableIntIntEmptyMap implements ImmutableIntIntMap, Serializable
{
    static final ImmutableIntIntMap INSTANCE = new ImmutableIntIntEmptyMap();

    private static final long serialVersionUID = 1L;
    private static final int EMPTY_VALUE = 0;

    private Object readResolve()
    {
        return INSTANCE;
    }

    public int get(int key)
    {
        return EMPTY_VALUE;
    }

    public int getIfAbsent(int key, int ifAbsent)
    {
        return ifAbsent;
    }

    public int getOrThrow(int key)
    {
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public boolean containsKey(int key)
    {
        return false;
    }

    public boolean containsValue(int value)
    {
        return false;
    }

    public void forEachValue(IntProcedure procedure)
    {
    }

    public void forEachKey(IntProcedure procedure)
    {
    }

    public void forEachKeyValue(IntIntProcedure procedure)
    {
    }

    public LazyIntIterable keysView()
    {
        return LazyIntIterate.empty();
    }

    public RichIterable<IntIntPair> keyValuesView()
    {
        return LazyIterate.empty();
    }

    public ImmutableIntIntMap select(IntIntPredicate predicate)
    {
        return this;
    }

    public ImmutableIntIntMap reject(IntIntPredicate predicate)
    {
        return this;
    }

    public ImmutableIntIntMap toImmutable()
    {
        return this;
    }

    public IntIterator intIterator()
    {
        return ImmutableEmptyIntIterator.INSTANCE;
    }

    public void forEach(IntProcedure procedure)
    {
    }

    /**
     * @since 7.0.
     */
    public void each(IntProcedure procedure)
    {
    }

    public int count(IntPredicate predicate)
    {
        return 0;
    }

    public long sum()
    {
        return 0L;
    }

    public int min()
    {
        throw new NoSuchElementException();
    }

    public int max()
    {
        throw new NoSuchElementException();
    }

    public int maxIfEmpty(int defaultValue)
    {
        return defaultValue;
    }

    public int minIfEmpty(int defaultValue)
    {
        return defaultValue;
    }

    public double average()
    {
        throw new ArithmeticException();
    }

    public double median()
    {
        throw new ArithmeticException();
    }

    public int[] toSortedArray()
    {
        return new int[0];
    }

    public MutableIntList toSortedList()
    {
        return new IntArrayList();
    }

    public boolean anySatisfy(IntPredicate predicate)
    {
        return false;
    }

    public boolean allSatisfy(IntPredicate predicate)
    {
        return true;
    }

    public boolean noneSatisfy(IntPredicate predicate)
    {
        return true;
    }

    public ImmutableIntBag select(IntPredicate predicate)
    {
        return IntBags.immutable.empty();
    }

    public ImmutableIntBag reject(IntPredicate predicate)
    {
        return IntBags.immutable.empty();
    }

    public <V> ImmutableBag<V> collect(IntToObjectFunction<? extends V> function)
    {
        return Bags.immutable.empty();
    }

    public int detectIfNone(IntPredicate predicate, int ifNone)
    {
        return ifNone;
    }

    public <T> T injectInto(T injectedValue, ObjectIntToObjectFunction<? super T, ? extends T> function)
    {
        return injectedValue;
    }

    public int[] toArray()
    {
        return new int[0];
    }

    public boolean contains(int value)
    {
        return false;
    }

    public boolean containsAll(int... source)
    {
        return source.length == 0;
    }

    public boolean containsAll(IntIterable source)
    {
        return source.isEmpty();
    }

    public MutableIntList toList()
    {
        return new IntArrayList();
    }

    public MutableIntSet toSet()
    {
        return new IntHashSet();
    }

    public MutableIntBag toBag()
    {
        return new IntHashBag();
    }

    public LazyIntIterable asLazy()
    {
        return new LazyIntIterableAdapter(this);
    }

    public ImmutableIntIntMap newWithKeyValue(int key, int value)
    {
        return new ImmutableIntIntSingletonMap(key, value);
    }

    public ImmutableIntIntMap newWithoutKey(int key)
    {
        return this;
    }

    public ImmutableIntIntMap newWithoutAllKeys(IntIterable keys)
    {
        return this;
    }

    public int size()
    {
        return 0;
    }

    public boolean isEmpty()
    {
        return true;
    }

    public boolean notEmpty()
    {
        return false;
    }

    public MutableIntSet keySet()
    {
        return UnmodifiableIntSet.of(new IntHashSet());
    }

    public MutableIntCollection values()
    {
        return UnmodifiableIntCollection.of(new IntArrayList());
    }

    @Override
    public boolean equals(Object obj)
    {
        if (obj == this)
        {
            return true;
        }
        if (!(obj instanceof IntIntMap))
        {
            return false;
        }
        IntIntMap map = (IntIntMap) obj;
        return map.isEmpty();
    }

    @Override
    public int hashCode()
    {
        return 0;
    }

    @Override
    public String toString()
    {
        return "{}";
    }

    public String makeString()
    {
        return "";
    }

    public String makeString(String separator)
    {
        return "";
    }

    public String makeString(String start, String separator, String end)
    {
        return start + end;
    }

    public void appendString(Appendable appendable)
    {
    }

    public void appendString(Appendable appendable, String separator)
    {
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        try
        {
            appendable.append(start);
            appendable.append(end);
        }
        catch (IOException e)
        {
            throw new RuntimeException(e);
        }
    }
}
