/*
 * Copyright (c) 2016 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.impl.map.mutable.primitive;

import java.io.Serializable;

import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.FloatIterable;
import org.eclipse.collections.api.LazyLongIterable;
import org.eclipse.collections.api.LazyFloatIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.bag.primitive.MutableLongBag;
import org.eclipse.collections.api.block.function.primitive.LongFunction;
import org.eclipse.collections.api.block.function.primitive.LongFunction0;
import org.eclipse.collections.api.block.function.primitive.LongToLongFunction;
import org.eclipse.collections.api.block.function.primitive.LongToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectLongToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.FloatToLongFunction;
import org.eclipse.collections.api.block.predicate.primitive.LongPredicate;
import org.eclipse.collections.api.block.predicate.primitive.FloatLongPredicate;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.block.procedure.primitive.FloatLongProcedure;
import org.eclipse.collections.api.block.procedure.primitive.FloatProcedure;
import org.eclipse.collections.api.collection.primitive.MutableLongCollection;
import org.eclipse.collections.api.iterator.MutableLongIterator;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.api.map.primitive.ImmutableFloatLongMap;
import org.eclipse.collections.api.map.primitive.FloatLongMap;
import org.eclipse.collections.api.map.primitive.MutableFloatLongMap;
import org.eclipse.collections.api.set.primitive.MutableFloatSet;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.api.tuple.primitive.FloatLongPair;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableLongCollection;
import org.eclipse.collections.impl.factory.primitive.FloatLongMaps;
import org.eclipse.collections.impl.iterator.UnmodifiableLongIterator;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableFloatSet;

/**
 * This file was automatically generated from template file unmodifiablePrimitivePrimitiveMap.stg.
 *
 * @since 3.1.
 */
public final class UnmodifiableFloatLongMap
        implements MutableFloatLongMap, Serializable
{
    private static final long serialVersionUID = 1L;
    private final MutableFloatLongMap map;

    UnmodifiableFloatLongMap(MutableFloatLongMap map)
    {
        this.map = map;
    }

    public void clear()
    {
        throw new UnsupportedOperationException("Cannot call clear() on " + this.getClass().getSimpleName());
    }

    public void put(float key, long value)
    {
        throw new UnsupportedOperationException("Cannot call put() on " + this.getClass().getSimpleName());
    }

    public void putAll(FloatLongMap map)
    {
        throw new UnsupportedOperationException("Cannot call putAll() on " + this.getClass().getSimpleName());
    }

    public void removeKey(float key)
    {
        throw new UnsupportedOperationException("Cannot call removeKey() on " + this.getClass().getSimpleName());
    }

    public void remove(float key)
    {
        throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
    }

    public long removeKeyIfAbsent(float key, long value)
    {
        if (this.map.containsKey(key))
        {
            throw new UnsupportedOperationException("Cannot call removeKey() on " + this.getClass().getSimpleName());
        }
        return value;
    }

    public long getIfAbsentPut(float key, long value)
    {
        return this.map.getIfAbsentPut(key, new LongFunction0()
        {
            public long value()
            {
                throw new UnsupportedOperationException();
            }
        });
    }

    public long getIfAbsentPut(float key, LongFunction0 function)
    {
        return this.map.getIfAbsentPut(key, new LongFunction0()
        {
            public long value()
            {
                throw new UnsupportedOperationException();
            }
        });
    }

    public long getIfAbsentPutWithKey(float key, FloatToLongFunction function)
    {
        return this.map.getIfAbsentPut(key, new LongFunction0()
        {
            public long value()
            {
                throw new UnsupportedOperationException();
            }
        });
    }

    public <P> long getIfAbsentPutWith(float key, LongFunction<? super P> function, P parameter)
    {
        return this.map.getIfAbsentPut(key, new LongFunction0()
        {
            public long value()
            {
                throw new UnsupportedOperationException();
            }
        });
    }

    public long updateValue(float key, long initialValueIfAbsent, LongToLongFunction function)
    {
        throw new UnsupportedOperationException("Cannot call updateValue() on " + this.getClass().getSimpleName());
    }

    public long get(float key)
    {
        return this.map.get(key);
    }

    public long getIfAbsent(float key, long ifAbsent)
    {
        return this.map.getIfAbsent(key, ifAbsent);
    }

    public long getOrThrow(float key)
    {
        return this.map.getOrThrow(key);
    }

    public boolean containsKey(float key)
    {
        return this.map.containsKey(key);
    }

    public boolean containsValue(long value)
    {
        return this.map.containsValue(value);
    }

    public void forEachValue(LongProcedure procedure)
    {
        this.map.forEachValue(procedure);
    }

    public void forEachKey(FloatProcedure procedure)
    {
        this.map.forEachKey(procedure);
    }

    public void forEachKeyValue(FloatLongProcedure procedure)
    {
        this.map.forEachKeyValue(procedure);
    }

    public LazyFloatIterable keysView()
    {
        return this.map.keysView();
    }

    public RichIterable<FloatLongPair> keyValuesView()
    {
        return this.map.keyValuesView();
    }

    public MutableFloatLongMap select(FloatLongPredicate predicate)
    {
        return this.map.select(predicate);
    }

    public MutableFloatLongMap reject(FloatLongPredicate predicate)
    {
        return this.map.reject(predicate);
    }

    public MutableLongIterator longIterator()
    {
        return new UnmodifiableLongIterator(this.map.longIterator());
    }

    public void forEach(LongProcedure procedure)
    {
        this.each(procedure);
    }

    /**
     * @since 7.0.
     */
    public void each(LongProcedure procedure)
    {
        this.map.forEach(procedure);
    }

    public int count(LongPredicate predicate)
    {
        return this.map.count(predicate);
    }

    public boolean anySatisfy(LongPredicate predicate)
    {
        return this.map.anySatisfy(predicate);
    }

    public boolean allSatisfy(LongPredicate predicate)
    {
        return this.map.allSatisfy(predicate);
    }

    public boolean noneSatisfy(LongPredicate predicate)
    {
        return this.map.noneSatisfy(predicate);
    }

    public MutableLongBag select(LongPredicate predicate)
    {
        return this.map.select(predicate);
    }

    public MutableLongBag reject(LongPredicate predicate)
    {
        return this.map.reject(predicate);
    }

    public <V> MutableBag<V> collect(LongToObjectFunction<? extends V> function)
    {
        return this.map.collect(function);
    }

    public long detectIfNone(LongPredicate predicate, long ifNone)
    {
        return this.map.detectIfNone(predicate, ifNone);
    }

    public long sum()
    {
        return this.map.sum();
    }

    public long max()
    {
        return this.map.max();
    }

    public long maxIfEmpty(long defaultValue)
    {
        return this.map.maxIfEmpty(defaultValue);
    }

    public long min()
    {
        return this.map.min();
    }

    public long minIfEmpty(long defaultValue)
    {
        return this.map.minIfEmpty(defaultValue);
    }

    public double average()
    {
        return this.map.average();
    }

    public double median()
    {
        return this.map.median();
    }

    public long addToValue(float key, long toBeAdded)
    {
        throw new UnsupportedOperationException("Cannot call addToValue() on " + this.getClass().getSimpleName());
    }

    public long[] toSortedArray()
    {
        return this.map.toSortedArray();
    }

    public MutableLongList toSortedList()
    {
        return this.map.toSortedList();
    }

    public long[] toArray()
    {
        return this.map.toArray();
    }

    public boolean contains(long value)
    {
        return this.map.contains(value);
    }

    public boolean containsAll(long... source)
    {
        return this.map.containsAll(source);
    }

    public boolean containsAll(LongIterable source)
    {
        return this.map.containsAll(source);
    }

    public MutableLongList toList()
    {
        return this.map.toList();
    }

    public MutableLongSet toSet()
    {
        return this.map.toSet();
    }

    public MutableLongBag toBag()
    {
        return this.map.toBag();
    }

    public LazyLongIterable asLazy()
    {
        return this.map.asLazy();
    }

    public MutableFloatLongMap withKeyValue(float key, long value)
    {
        throw new UnsupportedOperationException("Cannot call withKeyValue() on " + this.getClass().getSimpleName());
    }

    public MutableFloatLongMap withoutKey(float key)
    {
        throw new UnsupportedOperationException("Cannot call withoutKey() on " + this.getClass().getSimpleName());
    }

    public MutableFloatLongMap withoutAllKeys(FloatIterable keys)
    {
        throw new UnsupportedOperationException("Cannot call withoutAllKeys() on " + this.getClass().getSimpleName());
    }

    public MutableFloatLongMap asUnmodifiable()
    {
        return this;
    }

    public MutableFloatLongMap asSynchronized()
    {
        return new SynchronizedFloatLongMap(this);
    }

    public ImmutableFloatLongMap toImmutable()
    {
        return FloatLongMaps.immutable.withAll(this);
    }

    public int size()
    {
        return this.map.size();
    }

    public boolean isEmpty()
    {
        return this.map.isEmpty();
    }

    public boolean notEmpty()
    {
        return this.map.notEmpty();
    }

    public MutableFloatSet keySet()
    {
        return UnmodifiableFloatSet.of(this.map.keySet());
    }

    public MutableLongCollection values()
    {
        return UnmodifiableLongCollection.of(this.map.values());
    }

    @Override
    public boolean equals(Object otherMap)
    {
        return this.map.equals(otherMap);
    }

    @Override
    public int hashCode()
    {
        return this.map.hashCode();
    }

    @Override
    public String toString()
    {
        return this.map.toString();
    }

    public String makeString()
    {
        return this.map.makeString();
    }

    public String makeString(String separator)
    {
        return this.map.makeString(separator);
    }

    public String makeString(String start, String separator, String end)
    {
        return this.map.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable)
    {
        this.map.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator)
    {
        this.map.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        this.map.appendString(appendable, start, separator, end);
    }

    public <T> T injectInto(T injectedValue, ObjectLongToObjectFunction<? super T, ? extends T> function)
    {
        return this.map.injectInto(injectedValue, function);
    }
}
