/*
 * Copyright (c) 2016 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.impl.set.mutable.primitive;

import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.factory.set.primitive.MutableIntSetFactory;
import org.eclipse.collections.api.set.primitive.MutableIntSet;

/**
 * MutableIntSetFactoryImpl is a factory implementation which creates instances of type {@link MutableIntSet}.
 * This file was automatically generated from template file mutablePrimitiveSetFactoryImpl.stg.
 *
 * @since 6.0.
 */
public class MutableIntSetFactoryImpl implements MutableIntSetFactory
{
    public MutableIntSet empty()
    {
        return new IntHashSet();
    }

    public MutableIntSet of()
    {
        return this.empty();
    }

    public MutableIntSet with()
    {
        return this.empty();
    }

    public MutableIntSet of(int... items)
    {
        return this.with(items);
    }

    public MutableIntSet with(int... items)
    {
        if (items == null || items.length == 0)
        {
            return this.empty();
        }
        return IntHashSet.newSetWith(items);
    }

    public MutableIntSet ofAll(IntIterable items)
    {
        return this.withAll(items);
    }

    public MutableIntSet withAll(IntIterable items)
    {
        return IntHashSet.newSet(items);
    }
}
