/*
 * Copyright (c) 2016 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.impl.stack.mutable.primitive;

import java.io.Serializable;

import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.LazyLongIterable;
import org.eclipse.collections.api.bag.primitive.MutableLongBag;
import org.eclipse.collections.api.block.function.primitive.LongToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectLongToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectLongIntToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.LongPredicate;
import org.eclipse.collections.api.block.procedure.primitive.LongIntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.list.primitive.LongList;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.api.stack.MutableStack;
import org.eclipse.collections.api.stack.primitive.ImmutableLongStack;
import org.eclipse.collections.api.stack.primitive.MutableLongStack;
import org.eclipse.collections.impl.factory.primitive.LongStacks;
import org.eclipse.collections.impl.iterator.UnmodifiableLongIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyLongIterableAdapter;
import net.jcip.annotations.NotThreadSafe;

/**
 * This file was automatically generated from template file unmodifiablePrimitiveStack.stg.
 *
 * @since 3.1.
 */
@NotThreadSafe
public final class UnmodifiableLongStack
        implements MutableLongStack, Serializable
{
    private static final long serialVersionUID = 1L;

    private final MutableLongStack stack;

    UnmodifiableLongStack(MutableLongStack stack)
    {
        this.stack = stack;
    }

    public void push(long item)
    {
        throw new UnsupportedOperationException("Cannot call push() on " + this.getClass().getSimpleName());
    }

    public long pop()
    {
        throw new UnsupportedOperationException("Cannot call pop() on " + this.getClass().getSimpleName());
    }

    public LongList pop(int count)
    {
        throw new UnsupportedOperationException("Cannot call pop() on " + this.getClass().getSimpleName());
    }

    public long peek()
    {
        return this.stack.peek();
    }

    public LongList peek(int count)
    {
        return this.stack.peek(count);
    }

    public long peekAt(int index)
    {
        return this.stack.peekAt(index);
    }

    public int size()
    {
        return this.stack.size();
    }

    public boolean isEmpty()
    {
        return this.stack.isEmpty();
    }

    public boolean notEmpty()
    {
        return this.stack.notEmpty();
    }

    public void clear()
    {
        throw new UnsupportedOperationException("Cannot call clear() on " + this.getClass().getSimpleName());
    }

    public boolean contains(long value)
    {
        return this.stack.contains(value);
    }

    public boolean containsAll(long... source)
    {
        return this.stack.containsAll(source);
    }

    public boolean containsAll(LongIterable source)
    {
        return this.stack.containsAll(source);
    }

    public LongIterator longIterator()
    {
        return new UnmodifiableLongIterator(this.stack.longIterator());
    }

    public void forEach(LongProcedure procedure)
    {
        this.each(procedure);
    }

    /**
     * @since 7.0.
     */
    public void each(LongProcedure procedure)
    {
        this.stack.forEach(procedure);
    }

    public int count(LongPredicate predicate)
    {
        return this.stack.count(predicate);
    }

    public boolean anySatisfy(LongPredicate predicate)
    {
        return this.stack.anySatisfy(predicate);
    }

    public boolean allSatisfy(LongPredicate predicate)
    {
        return this.stack.allSatisfy(predicate);
    }

    public boolean noneSatisfy(LongPredicate predicate)
    {
        return this.stack.noneSatisfy(predicate);
    }

    public long detectIfNone(LongPredicate predicate, long ifNone)
    {
        return this.stack.detectIfNone(predicate, ifNone);
    }

    public MutableLongStack select(LongPredicate predicate)
    {
        return this.stack.select(predicate);
    }

    public MutableLongStack reject(LongPredicate predicate)
    {
        return this.stack.reject(predicate);
    }

    public <V> MutableStack<V> collect(LongToObjectFunction<? extends V> function)
    {
        return this.stack.collect(function);
    }

    public long sum()
    {
        return this.stack.sum();
    }

    public long max()
    {
        return this.stack.max();
    }

    public long min()
    {
        return this.stack.min();
    }

    public long minIfEmpty(long defaultValue)
    {
        return this.stack.minIfEmpty(defaultValue);
    }

    public long maxIfEmpty(long defaultValue)
    {
        return this.stack.maxIfEmpty(defaultValue);
    }

    public double average()
    {
        return this.stack.average();
    }

    public double median()
    {
        return this.stack.median();
    }

    public MutableLongList toSortedList()
    {
        return this.stack.toSortedList();
    }

    public long[] toSortedArray()
    {
        return this.stack.toSortedArray();
    }

    public long[] toArray()
    {
        return this.stack.toArray();
    }

    @Override
    public String toString()
    {
        return this.stack.toString();
    }

    public String makeString()
    {
        return this.stack.makeString();
    }

    public String makeString(String separator)
    {
        return this.stack.makeString(separator);
    }

    public String makeString(String start, String separator, String end)
    {
        return this.stack.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable)
    {
        this.stack.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator)
    {
        this.stack.appendString(appendable, separator);
    }

    public void appendString(
            Appendable appendable,
            String start,
            String separator,
            String end)
    {
        this.stack.appendString(appendable, start, separator, end);
    }

    public MutableLongList toList()
    {
        return this.stack.toList();
    }

    public MutableLongSet toSet()
    {
        return this.stack.toSet();
    }

    public MutableLongBag toBag()
    {
        return this.stack.toBag();
    }

    @Override
    public boolean equals(Object otherStack)
    {
        return this.stack.equals(otherStack);
    }

    @Override
    public int hashCode()
    {
        return this.stack.hashCode();
    }

    public LazyLongIterable asLazy()
    {
        return new LazyLongIterableAdapter(this);
    }

    public MutableLongStack asUnmodifiable()
    {
        return this;
    }

    public MutableLongStack asSynchronized()
    {
        return new SynchronizedLongStack(this);
    }

    public ImmutableLongStack toImmutable()
    {
        return LongStacks.immutable.withAllReversed(this);
    }

    public <T> T injectInto(T injectedValue, ObjectLongToObjectFunction<? super T, ? extends T> function)
    {
        return this.stack.injectInto(injectedValue, function);
    }

    public long getFirst()
    {
        return this.stack.getFirst();
    }

    public int indexOf(long value)
    {
        return this.stack.indexOf(value);
    }

    public <T> T injectIntoWithIndex(T injectedValue, ObjectLongIntToObjectFunction<? super T, ? extends T> function)
    {
        return this.stack.injectIntoWithIndex(injectedValue, function);
    }

    public void forEachWithIndex(LongIntProcedure procedure)
    {
        this.stack.forEachWithIndex(procedure);
    }
}
