/*
 * Copyright (c) 2017 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.impl.bag.immutable.primitive;

import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.bag.primitive.ImmutableIntBag;
import org.eclipse.collections.api.factory.bag.primitive.ImmutableIntBagFactory;

/**
 * ImmutableIntBagFactoryImpl is a factory implementation which creates instances of type {@link ImmutableIntBag}.
 * This file was automatically generated from template file immutablePrimitiveBagFactoryImpl.stg.
 *
 * @since 4.0.
 */
public class ImmutableIntBagFactoryImpl implements ImmutableIntBagFactory
{
    public ImmutableIntBag empty()
    {
        return ImmutableIntEmptyBag.INSTANCE;
    }

    public ImmutableIntBag of()
    {
        return this.empty();
    }

    public ImmutableIntBag with()
    {
        return this.empty();
    }

    public ImmutableIntBag of(int one)
    {
        return this.with(one);
    }

    public ImmutableIntBag with(int one)
    {
        return new ImmutableIntSingletonBag(one);
    }

    public ImmutableIntBag of(int... items)
    {
        return this.with(items);
    }

    public ImmutableIntBag with(int... items)
    {
        if (items == null || items.length == 0)
        {
            return this.with();
        }
        if (items.length == 1)
        {
            return this.with(items[0]);
        }
        return ImmutableIntHashBag.newBagWith(items);
    }

    public ImmutableIntBag ofAll(IntIterable items)
    {
        return this.withAll(items);
    }

    public ImmutableIntBag withAll(IntIterable items)
    {
        if (items instanceof ImmutableIntBag)
        {
            return (ImmutableIntBag) items;
        }
        return this.with(items.toArray());
    }
}
