/*
 * Copyright (c) 2017 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.impl.bag.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import java.util.NoSuchElementException;

import org.eclipse.collections.api.ShortIterable;
import org.eclipse.collections.api.LazyShortIterable;
import org.eclipse.collections.api.bag.ImmutableBag;
import org.eclipse.collections.api.bag.primitive.ImmutableShortBag;
import org.eclipse.collections.api.bag.primitive.ShortBag;
import org.eclipse.collections.api.bag.primitive.MutableShortBag;
import org.eclipse.collections.api.block.function.primitive.ShortToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectShortToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import org.eclipse.collections.api.block.predicate.primitive.ShortPredicate;
import org.eclipse.collections.api.block.procedure.primitive.ShortIntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ShortProcedure;
import org.eclipse.collections.api.iterator.ShortIterator;
import org.eclipse.collections.api.list.primitive.MutableShortList;
import org.eclipse.collections.api.set.primitive.MutableShortSet;
import org.eclipse.collections.impl.bag.mutable.primitive.ShortHashBag;
import org.eclipse.collections.impl.factory.Bags;
import org.eclipse.collections.impl.factory.primitive.ShortBags;
import org.eclipse.collections.impl.iterator.ImmutableEmptyShortIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyShortIterableAdapter;
import org.eclipse.collections.impl.list.mutable.primitive.ShortArrayList;
import org.eclipse.collections.impl.set.mutable.primitive.ShortHashSet;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.tuple.primitive.ShortIntPair;
import org.eclipse.collections.impl.factory.Lists;
import net.jcip.annotations.Immutable;

/**
 * ImmutableShortEmptyBag is an optimization for {@link ImmutableShortBag} of size 0.
 * This file was automatically generated from template file immutablePrimitiveEmptyBag.stg.
 *
 * @since 4.0.
 */
@Immutable
final class ImmutableShortEmptyBag implements ImmutableShortBag, Serializable
{
    static final ImmutableShortBag INSTANCE = new ImmutableShortEmptyBag();

    private static final long serialVersionUID = 1L;

    private Object readResolve()
    {
        return INSTANCE;
    }

    public ImmutableShortBag newWith(short element)
    {
        return new ImmutableShortSingletonBag(element);
    }

    public ImmutableShortBag newWithout(short element)
    {
        return this;
    }

    public ImmutableShortBag newWithAll(ShortIterable elements)
    {
        return ShortBags.immutable.withAll(elements);
    }

    public ImmutableShortBag newWithoutAll(ShortIterable elements)
    {
        return this;
    }

    public int size()
    {
        return 0;
    }

    public boolean isEmpty()
    {
        return true;
    }

    public boolean notEmpty()
    {
        return false;
    }

    public boolean contains(short value)
    {
        return false;
    }

    public boolean containsAll(ShortIterable source)
    {
        return source.isEmpty();
    }

    public boolean containsAll(short... elements)
    {
        return elements.length == 0;
    }

    public void forEach(ShortProcedure procedure)
    {
    }

    /**
     * @since 7.0.
     */
    public void each(ShortProcedure procedure)
    {
    }

    public ImmutableShortBag select(ShortPredicate predicate)
    {
        return this;
    }

    public ImmutableShortBag reject(ShortPredicate predicate)
    {
        return this;
    }

    public <V> ImmutableBag<V> collect(ShortToObjectFunction<? extends V> function)
    {
        return Bags.immutable.of();
    }

    public MutableShortList toList()
    {
        return new ShortArrayList();
    }

    public int sizeDistinct()
    {
        return 0;
    }

    public int occurrencesOf(short item)
    {
        return 0;
    }

    public void forEachWithOccurrences(ShortIntProcedure shortIntProcedure)
    {
    }

    public ImmutableShortBag selectByOccurrences(IntPredicate predicate)
    {
        return this;
    }

    public ImmutableList<ShortIntPair> topOccurrences(int count)
    {
        if (count < 0)
        {
            throw new IllegalArgumentException("Cannot use a value of count < 0");
        }
        return Lists.immutable.empty();
    }

    public ImmutableList<ShortIntPair> bottomOccurrences(int count)
    {
        if (count < 0)
        {
            throw new IllegalArgumentException("Cannot use a value of count < 0");
        }
        return Lists.immutable.empty();
    }

    public short detectIfNone(ShortPredicate predicate, short ifNone)
    {
        return ifNone;
    }

    public int count(ShortPredicate predicate)
    {
        return 0;
    }

    public boolean anySatisfy(ShortPredicate predicate)
    {
        return false;
    }

    public long sum()
    {
        return 0L;
    }

    public short min()
    {
        throw new NoSuchElementException();
    }

    public short max()
    {
        throw new NoSuchElementException();
    }

    public short maxIfEmpty(short defaultValue)
    {
        return defaultValue;
    }

    public short minIfEmpty(short defaultValue)
    {
        return defaultValue;
    }

    public double average()
    {
        throw new ArithmeticException();
    }

    public double median()
    {
        throw new ArithmeticException();
    }

    public short[] toSortedArray()
    {
        return new short[0];
    }

    public MutableShortList toSortedList()
    {
        return new ShortArrayList();
    }

    public boolean noneSatisfy(ShortPredicate predicate)
    {
        return true;
    }

    public boolean allSatisfy(ShortPredicate predicate)
    {
        return true;
    }

    public <T> T injectInto(T injectedValue, ObjectShortToObjectFunction<? super T, ? extends T> function)
    {
        return injectedValue;
    }

    @Override
    public boolean equals(Object obj)
    {
        if (obj == this)
        {
            return true;
        }
        if (!(obj instanceof ShortBag))
        {
            return false;
        }
        ShortBag bag = (ShortBag) obj;
        return bag.isEmpty();
    }

    @Override
    public int hashCode()
    {
        return 0;
    }

    public MutableShortSet toSet()
    {
        return new ShortHashSet();
    }

    public MutableShortBag toBag()
    {
        return new ShortHashBag();
    }

    public ImmutableShortBag toImmutable()
    {
        return this;
    }

    public LazyShortIterable asLazy()
    {
        return new LazyShortIterableAdapter(this);
    }

    public short[] toArray()
    {
        return new short[0];
    }

    @Override
    public String toString()
    {
        return "[]";
    }

    public String makeString()
    {
        return "";
    }

    public String makeString(String separator)
    {
        return "";
    }

    public String makeString(String start, String separator, String end)
    {
        return start + end;
    }

    public void appendString(Appendable appendable)
    {
    }

    public void appendString(Appendable appendable, String separator)
    {
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        try
        {
            appendable.append(start);
            appendable.append(end);
        }
        catch (IOException e)
        {
            throw new RuntimeException(e);
        }
    }

    public ShortIterator shortIterator()
    {
        return ImmutableEmptyShortIterator.INSTANCE;
    }
}
