/*
 * Copyright (c) 2017 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.impl.map.immutable.primitive;

import org.eclipse.collections.api.factory.map.primitive.ImmutableShortLongMapFactory;
import org.eclipse.collections.api.map.primitive.ImmutableShortLongMap;
import org.eclipse.collections.api.map.primitive.ShortLongMap;

/**
 * ImmutableShortLongMapFactoryImpl is a factory implementation which creates instances of type {@link ImmutableShortLongMap}.
 * This file was automatically generated from template file immutablePrimitivePrimitiveMapFactoryImpl.stg.
 *
 * @since 4.0.
 */
public class ImmutableShortLongMapFactoryImpl implements ImmutableShortLongMapFactory
{
    public ImmutableShortLongMap empty()
    {
        return ImmutableShortLongEmptyMap.INSTANCE;
    }

    public ImmutableShortLongMap of()
    {
        return this.empty();
    }

    public ImmutableShortLongMap with()
    {
        return this.empty();
    }

    public ImmutableShortLongMap of(short key, long value)
    {
        return this.with(key, value);
    }

    public ImmutableShortLongMap with(short key, long value)
    {
        return new ImmutableShortLongSingletonMap(key, value);
    }

    public ImmutableShortLongMap ofAll(ShortLongMap map)
    {
        return this.withAll(map);
    }

    public ImmutableShortLongMap withAll(ShortLongMap map)
    {
        if (map instanceof ImmutableShortLongMap)
        {
            return (ImmutableShortLongMap) map;
        }
        if (map.isEmpty())
        {
            return this.with();
        }
        if (map.size() == 1)
        {
            short key = map.keysView().shortIterator().next();
            return new ImmutableShortLongSingletonMap(key, map.get(key));
        }
        return new ImmutableShortLongHashMap(map);
    }
}
