/*
 * Copyright (c) 2017 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.impl.set.immutable.primitive;

import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.set.primitive.ImmutableLongSet;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.eclipse.collections.impl.set.primitive.AbstractLongSet;

/**
 * This file was automatically generated from template file abstractImmutablePrimitiveSet.stg.
 *
 * @since 6.0.
 */
public abstract class AbstractImmutableLongSet extends AbstractLongSet implements ImmutableLongSet
{
    public ImmutableLongSet newWith(long element)
    {
        return LongHashSet.newSet(this).with(element).toImmutable();
    }

    public ImmutableLongSet newWithout(long element)
    {
        return LongHashSet.newSet(this).without(element).toImmutable();
    }

    public ImmutableLongSet newWithAll(LongIterable elements)
    {
        return LongHashSet.newSet(this).withAll(elements).toImmutable();
    }

    public ImmutableLongSet newWithoutAll(LongIterable elements)
    {
        return LongHashSet.newSet(this).withoutAll(elements).toImmutable();
    }

    public LongSet freeze()
    {
        return this;
    }

    public ImmutableLongSet toImmutable()
    {
        return this;
    }
}
