/*
 * Copyright (c) 2017 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.impl.bag.immutable.primitive;

import org.eclipse.collections.api.DoubleIterable;
import org.eclipse.collections.api.bag.primitive.ImmutableDoubleBag;
import org.eclipse.collections.api.factory.bag.primitive.ImmutableDoubleBagFactory;

/**
 * ImmutableDoubleBagFactoryImpl is a factory implementation which creates instances of type {@link ImmutableDoubleBag}.
 * This file was automatically generated from template file immutablePrimitiveBagFactoryImpl.stg.
 *
 * @since 4.0.
 */
public class ImmutableDoubleBagFactoryImpl implements ImmutableDoubleBagFactory
{
    public ImmutableDoubleBag empty()
    {
        return ImmutableDoubleEmptyBag.INSTANCE;
    }

    public ImmutableDoubleBag of()
    {
        return this.empty();
    }

    public ImmutableDoubleBag with()
    {
        return this.empty();
    }

    public ImmutableDoubleBag of(double one)
    {
        return this.with(one);
    }

    public ImmutableDoubleBag with(double one)
    {
        return new ImmutableDoubleSingletonBag(one);
    }

    public ImmutableDoubleBag of(double... items)
    {
        return this.with(items);
    }

    public ImmutableDoubleBag with(double... items)
    {
        if (items == null || items.length == 0)
        {
            return this.with();
        }
        if (items.length == 1)
        {
            return this.with(items[0]);
        }
        return ImmutableDoubleHashBag.newBagWith(items);
    }

    public ImmutableDoubleBag ofAll(DoubleIterable items)
    {
        return this.withAll(items);
    }

    public ImmutableDoubleBag withAll(DoubleIterable items)
    {
        if (items instanceof ImmutableDoubleBag)
        {
            return (ImmutableDoubleBag) items;
        }
        return this.with(items.toArray());
    }
}
