/*
 * Copyright (c) 2017 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.impl.bag.mutable.primitive;

import org.eclipse.collections.api.FloatIterable;
import org.eclipse.collections.api.factory.bag.primitive.MutableFloatBagFactory;
import org.eclipse.collections.api.bag.primitive.MutableFloatBag;

/**
 * MutableFloatBagFactoryImpl is a factory implementation which creates instances of type {@link MutableFloatBag}.
 * This file was automatically generated from template file mutablePrimitiveBagFactoryImpl.stg.
 *
 * @since 6.0.
 */
public class MutableFloatBagFactoryImpl implements MutableFloatBagFactory
{
    public MutableFloatBag empty()
    {
        return new FloatHashBag();
    }

    public MutableFloatBag of()
    {
        return this.empty();
    }

    public MutableFloatBag with()
    {
        return this.empty();
    }

    public MutableFloatBag of(float... items)
    {
        return this.with(items);
    }

    public MutableFloatBag with(float... items)
    {
        if (items == null || items.length == 0)
        {
            return this.with();
        }
        return FloatHashBag.newBagWith(items);
    }

    public MutableFloatBag ofAll(FloatIterable items)
    {
        return this.withAll(items);
    }

    public MutableFloatBag withAll(FloatIterable items)
    {
        return FloatHashBag.newBag(items);
    }
}
