/*
 * Copyright (c) 2017 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.impl.lazy.primitive;

import org.eclipse.collections.api.BooleanIterable;
import org.eclipse.collections.api.LazyBooleanIterable;
import org.eclipse.collections.api.LazyByteIterable;
import org.eclipse.collections.api.LazyCharIterable;
import org.eclipse.collections.api.LazyDoubleIterable;
import org.eclipse.collections.api.LazyFloatIterable;
import org.eclipse.collections.api.LazyIntIterable;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.LazyLongIterable;
import org.eclipse.collections.api.LazyShortIterable;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.bag.primitive.MutableBooleanBag;
import org.eclipse.collections.api.block.function.primitive.BooleanToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.BooleanToBooleanFunction;
import org.eclipse.collections.api.block.function.primitive.BooleanToByteFunction;
import org.eclipse.collections.api.block.function.primitive.BooleanToCharFunction;
import org.eclipse.collections.api.block.function.primitive.BooleanToDoubleFunction;
import org.eclipse.collections.api.block.function.primitive.BooleanToFloatFunction;
import org.eclipse.collections.api.block.function.primitive.BooleanToIntFunction;
import org.eclipse.collections.api.block.function.primitive.BooleanToLongFunction;
import org.eclipse.collections.api.block.function.primitive.BooleanToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.BooleanToShortFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectBooleanToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.BooleanPredicate;
import org.eclipse.collections.api.block.procedure.primitive.BooleanProcedure;
import org.eclipse.collections.api.list.primitive.MutableBooleanList;
import org.eclipse.collections.api.set.primitive.MutableBooleanSet;
import org.eclipse.collections.impl.bag.mutable.primitive.BooleanHashBag;
import org.eclipse.collections.impl.block.factory.primitive.BooleanPredicates;
import org.eclipse.collections.impl.factory.primitive.BooleanSets;
import org.eclipse.collections.impl.list.mutable.primitive.BooleanArrayList;
import org.eclipse.collections.impl.set.mutable.primitive.BooleanHashSet;
import org.eclipse.collections.impl.utility.internal.primitive.BooleanIterableIterate;
import org.eclipse.collections.impl.utility.primitive.LazyBooleanIterate;

import java.util.NoSuchElementException;

/**
 * This file was automatically generated from template file abstractLazyPrimitiveIterable.stg.
 *
 * @since 5.0
 */
public abstract class AbstractLazyBooleanIterable implements LazyBooleanIterable
{
    public void forEach(BooleanProcedure procedure)
    {
        this.each(procedure);
    }

    public int size()
    {
        return this.count(BooleanPredicates.alwaysTrue());
    }

    @Override
    public String toString()
    {
        return this.makeString("[", ", ", "]");
    }

    public boolean isEmpty()
    {
        return BooleanIterableIterate.isEmpty(this);
    }

    public boolean notEmpty()
    {
        return BooleanIterableIterate.notEmpty(this);
    }

    public String makeString()
    {
        return this.makeString(", ");
    }

    public String makeString(String separator)
    {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end)
    {
        Appendable stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return stringBuilder.toString();
    }

    public void appendString(Appendable appendable)
    {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator)
    {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        BooleanIterableIterate.appendString(this, appendable, start, separator, end);
    }

    public boolean contains(boolean value)
    {
        return this.anySatisfy(BooleanPredicates.equal(value));
    }

    public boolean containsAll(boolean... source)
    {
        return this.containsAll(BooleanSets.immutable.of(source));
    }

    public boolean containsAll(BooleanIterable source)
    {
        return source.allSatisfy((boolean value) -> AbstractLazyBooleanIterable.this.contains(value));
    }

    public LazyBooleanIterable select(BooleanPredicate predicate)
    {
        return LazyBooleanIterate.select(this, predicate);
    }

    public LazyBooleanIterable reject(BooleanPredicate predicate)
    {
        return LazyBooleanIterate.select(this, BooleanPredicates.not(predicate));
    }

    public <V> LazyIterable<V> collect(BooleanToObjectFunction<? extends V> function)
    {
        return LazyBooleanIterate.collect(this, function);
    }

    /**
     * @since 7.0
     */
    public LazyBooleanIterable collectBoolean(BooleanToBooleanFunction function)
    {
        return new CollectBooleanToBooleanIterable(this, function);
    }

    /**
     * @since 7.0
     */
    public LazyByteIterable collectByte(BooleanToByteFunction function)
    {
        return new CollectBooleanToByteIterable(this, function);
    }

    /**
     * @since 7.0
     */
    public LazyCharIterable collectChar(BooleanToCharFunction function)
    {
        return new CollectBooleanToCharIterable(this, function);
    }

    /**
     * @since 7.0
     */
    public LazyShortIterable collectShort(BooleanToShortFunction function)
    {
        return new CollectBooleanToShortIterable(this, function);
    }

    /**
     * @since 7.0
     */
    public LazyIntIterable collectInt(BooleanToIntFunction function)
    {
        return new CollectBooleanToIntIterable(this, function);
    }

    /**
     * @since 7.0
     */
    public LazyFloatIterable collectFloat(BooleanToFloatFunction function)
    {
        return new CollectBooleanToFloatIterable(this, function);
    }

    /**
     * @since 7.0
     */
    public LazyLongIterable collectLong(BooleanToLongFunction function)
    {
        return new CollectBooleanToLongIterable(this, function);
    }

    /**
     * @since 7.0
     */
    public LazyDoubleIterable collectDouble(BooleanToDoubleFunction function)
    {
        return new CollectBooleanToDoubleIterable(this, function);
    }

    public boolean detectIfNone(BooleanPredicate predicate, boolean ifNone)
    {
        return BooleanIterableIterate.detectIfNone(this, predicate, ifNone);
    }

    public int count(BooleanPredicate predicate)
    {
        return BooleanIterableIterate.count(this, predicate);
    }

    public boolean anySatisfy(BooleanPredicate predicate)
    {
        return BooleanIterableIterate.anySatisfy(this, predicate);
    }

    public boolean allSatisfy(BooleanPredicate predicate)
    {
        return BooleanIterableIterate.allSatisfy(this, predicate);
    }

    public boolean noneSatisfy(BooleanPredicate predicate)
    {
        return BooleanIterableIterate.noneSatisfy(this, predicate);
    }

    public <T> T injectInto(T injectedValue, ObjectBooleanToObjectFunction<? super T, ? extends T> function)
    {
        return BooleanIterableIterate.injectInto(this, injectedValue, function);
    }

    public boolean[] toArray()
    {
        return this.toList().toArray();
    }

    public MutableBooleanList toList()
    {
        final MutableBooleanList list = new BooleanArrayList();
        this.forEach(list::add);
        return list;
    }

    public MutableBooleanSet toSet()
    {
        final MutableBooleanSet set = new BooleanHashSet();
        this.forEach(set::add);
        return set;
    }

    public MutableBooleanBag toBag()
    {
        final MutableBooleanBag bag = new BooleanHashBag();
        this.forEach(bag::add);
        return bag;
    }

    public LazyBooleanIterable asLazy()
    {
        return this;
    }
}
