/*
 * Copyright (c) 2017 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.impl.lazy.primitive;

import org.eclipse.collections.api.ShortIterable;
import org.eclipse.collections.api.LazyBooleanIterable;
import org.eclipse.collections.api.LazyByteIterable;
import org.eclipse.collections.api.LazyCharIterable;
import org.eclipse.collections.api.LazyDoubleIterable;
import org.eclipse.collections.api.LazyFloatIterable;
import org.eclipse.collections.api.LazyIntIterable;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.LazyLongIterable;
import org.eclipse.collections.api.LazyShortIterable;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.bag.primitive.MutableShortBag;
import org.eclipse.collections.api.block.function.primitive.ShortToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ShortToBooleanFunction;
import org.eclipse.collections.api.block.function.primitive.ShortToByteFunction;
import org.eclipse.collections.api.block.function.primitive.ShortToCharFunction;
import org.eclipse.collections.api.block.function.primitive.ShortToDoubleFunction;
import org.eclipse.collections.api.block.function.primitive.ShortToFloatFunction;
import org.eclipse.collections.api.block.function.primitive.ShortToIntFunction;
import org.eclipse.collections.api.block.function.primitive.ShortToLongFunction;
import org.eclipse.collections.api.block.function.primitive.ShortToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ShortToShortFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectShortToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.ShortPredicate;
import org.eclipse.collections.api.block.procedure.primitive.ShortProcedure;
import org.eclipse.collections.api.list.primitive.MutableShortList;
import org.eclipse.collections.api.set.primitive.MutableShortSet;
import org.eclipse.collections.impl.bag.mutable.primitive.ShortHashBag;
import org.eclipse.collections.impl.block.factory.primitive.ShortPredicates;
import org.eclipse.collections.impl.factory.primitive.ShortSets;
import org.eclipse.collections.impl.list.mutable.primitive.ShortArrayList;
import org.eclipse.collections.impl.set.mutable.primitive.ShortHashSet;
import org.eclipse.collections.impl.utility.internal.primitive.ShortIterableIterate;
import org.eclipse.collections.impl.utility.primitive.LazyShortIterate;

import java.util.NoSuchElementException;

/**
 * This file was automatically generated from template file abstractLazyPrimitiveIterable.stg.
 *
 * @since 5.0
 */
public abstract class AbstractLazyShortIterable implements LazyShortIterable
{
    public void forEach(ShortProcedure procedure)
    {
        this.each(procedure);
    }

    public int size()
    {
        return this.count(ShortPredicates.alwaysTrue());
    }

    @Override
    public String toString()
    {
        return this.makeString("[", ", ", "]");
    }

    public boolean isEmpty()
    {
        return ShortIterableIterate.isEmpty(this);
    }

    public boolean notEmpty()
    {
        return ShortIterableIterate.notEmpty(this);
    }

    public String makeString()
    {
        return this.makeString(", ");
    }

    public String makeString(String separator)
    {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end)
    {
        Appendable stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return stringBuilder.toString();
    }

    public void appendString(Appendable appendable)
    {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator)
    {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        ShortIterableIterate.appendString(this, appendable, start, separator, end);
    }

    public boolean contains(short value)
    {
        return this.anySatisfy(ShortPredicates.equal(value));
    }

    public boolean containsAll(short... source)
    {
        return this.containsAll(ShortSets.immutable.of(source));
    }

    public boolean containsAll(ShortIterable source)
    {
        return source.allSatisfy((short value) -> AbstractLazyShortIterable.this.contains(value));
    }

    public LazyShortIterable select(ShortPredicate predicate)
    {
        return LazyShortIterate.select(this, predicate);
    }

    public LazyShortIterable reject(ShortPredicate predicate)
    {
        return LazyShortIterate.select(this, ShortPredicates.not(predicate));
    }

    public <V> LazyIterable<V> collect(ShortToObjectFunction<? extends V> function)
    {
        return LazyShortIterate.collect(this, function);
    }

    /**
     * @since 7.0
     */
    public LazyBooleanIterable collectBoolean(ShortToBooleanFunction function)
    {
        return new CollectShortToBooleanIterable(this, function);
    }

    /**
     * @since 7.0
     */
    public LazyByteIterable collectByte(ShortToByteFunction function)
    {
        return new CollectShortToByteIterable(this, function);
    }

    /**
     * @since 7.0
     */
    public LazyCharIterable collectChar(ShortToCharFunction function)
    {
        return new CollectShortToCharIterable(this, function);
    }

    /**
     * @since 7.0
     */
    public LazyShortIterable collectShort(ShortToShortFunction function)
    {
        return new CollectShortToShortIterable(this, function);
    }

    /**
     * @since 7.0
     */
    public LazyIntIterable collectInt(ShortToIntFunction function)
    {
        return new CollectShortToIntIterable(this, function);
    }

    /**
     * @since 7.0
     */
    public LazyFloatIterable collectFloat(ShortToFloatFunction function)
    {
        return new CollectShortToFloatIterable(this, function);
    }

    /**
     * @since 7.0
     */
    public LazyLongIterable collectLong(ShortToLongFunction function)
    {
        return new CollectShortToLongIterable(this, function);
    }

    /**
     * @since 7.0
     */
    public LazyDoubleIterable collectDouble(ShortToDoubleFunction function)
    {
        return new CollectShortToDoubleIterable(this, function);
    }

    public short detectIfNone(ShortPredicate predicate, short ifNone)
    {
        return ShortIterableIterate.detectIfNone(this, predicate, ifNone);
    }

    public int count(ShortPredicate predicate)
    {
        return ShortIterableIterate.count(this, predicate);
    }

    public boolean anySatisfy(ShortPredicate predicate)
    {
        return ShortIterableIterate.anySatisfy(this, predicate);
    }

    public boolean allSatisfy(ShortPredicate predicate)
    {
        return ShortIterableIterate.allSatisfy(this, predicate);
    }

    public boolean noneSatisfy(ShortPredicate predicate)
    {
        return ShortIterableIterate.noneSatisfy(this, predicate);
    }

    public <T> T injectInto(T injectedValue, ObjectShortToObjectFunction<? super T, ? extends T> function)
    {
        return ShortIterableIterate.injectInto(this, injectedValue, function);
    }

    public short[] toArray()
    {
        return this.toList().toArray();
    }

    public MutableShortList toList()
    {
        final MutableShortList list = new ShortArrayList();
        this.forEach(list::add);
        return list;
    }

    public MutableShortSet toSet()
    {
        final MutableShortSet set = new ShortHashSet();
        this.forEach(set::add);
        return set;
    }

    public MutableShortBag toBag()
    {
        final MutableShortBag bag = new ShortHashBag();
        this.forEach(bag::add);
        return bag;
    }

    public long sum()
    {
        ShortSumProcedure procedure = new ShortSumProcedure();
        this.forEach(procedure);
        return procedure.getValue();
    }

    public short max()
    {
        if (this.isEmpty())
        {
            throw new NoSuchElementException();
        }
        ShortMaxProcedure procedure = new ShortMaxProcedure();
        this.forEach(procedure);
        return procedure.getValue();
    }

    public short maxIfEmpty(short ifEmpty)
    {
        if (this.isEmpty())
        {
            return ifEmpty;
        }
        return this.max();
    }

    public short min()
    {
        if (this.isEmpty())
        {
            throw new NoSuchElementException();
        }
        ShortMinProcedure procedure = new ShortMinProcedure();
        this.forEach(procedure);
        return procedure.getValue();
    }

    public short minIfEmpty(short ifEmpty)
    {
        if (this.isEmpty())
        {
            return ifEmpty;
        }
        return this.min();
    }

    public double average()
    {
        if (this.isEmpty())
        {
            throw new ArithmeticException();
        }
        return (double) this.sum() / (double) this.size();
    }

    public double median()
    {
        if (this.isEmpty())
        {
            throw new ArithmeticException();
        }
        short[] sortedArray = this.toSortedArray();
        int middleIndex = sortedArray.length >> 1;
        if (sortedArray.length > 1 && (sortedArray.length & 1) == 0)
        {
            short first = sortedArray[middleIndex];
            short second = sortedArray[middleIndex - 1];
            return ((double) first + (double) second) / 2.0;
        }
        return (double) sortedArray[middleIndex];
    }

    public short[] toSortedArray()
    {
        return this.toSortedList().toArray();
    }

    public MutableShortList toSortedList()
    {
        return ShortArrayList.newList(this).sortThis();
    }

    private static final class ShortMaxProcedure implements ShortProcedure
    {
        private boolean visitedOnce;
        private short max;

        public void value(short each)
        {
            if (this.visitedOnce)
            {
                if (this.max < each)
                {
                    this.max = each;
                }
            }
            else
            {
                this.max = each;
                this.visitedOnce = true;
            }
        }

        public short getValue()
        {
            return this.max;
        }
    }

    private static final class ShortMinProcedure implements ShortProcedure
    {
        private boolean visitedOnce;
        private short min;

        public void value(short each)
        {
            if (this.visitedOnce)
            {
                if (each < this.min)
                {
                    this.min = each;
                }
            }
            else
            {
                this.min = each;
                this.visitedOnce = true;
            }
        }

        public short getValue()
        {
            return this.min;
        }
    }

    private static final class ShortSumProcedure implements ShortProcedure
    {
        private short sum = 0;

        public void value(short each)
        {
            this.sum += each;
        }

        public short getValue()
        {
            return this.sum;
        }
    }


    public LazyShortIterable asLazy()
    {
        return this;
    }
}
