/*
 * Copyright (c) 2017 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.impl.list.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import java.util.NoSuchElementException;

import org.eclipse.collections.api.ByteIterable;
import org.eclipse.collections.api.LazyByteIterable;
import org.eclipse.collections.api.bag.primitive.MutableByteBag;
import org.eclipse.collections.api.block.function.primitive.ByteToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectByteToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectByteIntToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.BytePredicate;
import org.eclipse.collections.api.block.procedure.primitive.ByteProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ByteIntProcedure;
import org.eclipse.collections.api.iterator.ByteIterator;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.list.primitive.ImmutableByteList;
import org.eclipse.collections.api.list.primitive.ByteList;
import org.eclipse.collections.api.list.primitive.MutableByteList;
import org.eclipse.collections.api.set.primitive.MutableByteSet;
import org.eclipse.collections.impl.bag.mutable.primitive.ByteHashBag;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.primitive.ByteLists;
import org.eclipse.collections.impl.iterator.ImmutableEmptyByteIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyByteIterableAdapter;
import org.eclipse.collections.impl.lazy.primitive.ReverseByteIterable;
import org.eclipse.collections.impl.list.mutable.primitive.ByteArrayList;
import org.eclipse.collections.impl.set.mutable.primitive.ByteHashSet;
import net.jcip.annotations.Immutable;

/**
 * ImmutableByteEmptyList is an optimization for {@link ImmutableByteList} of size 0.
 * This file was automatically generated from template file immutablePrimitiveEmptyList.stg.
 */
@Immutable
final class ImmutableByteEmptyList implements ImmutableByteList, Serializable
{
    static final ImmutableByteList INSTANCE = new ImmutableByteEmptyList();
    private static final long serialVersionUID = 1L;

    private Object readResolve()
    {
        return INSTANCE;
    }

    public byte get(int index)
    {
        throw new IndexOutOfBoundsException("Index: " + index + ", Size: 0");
    }

    public byte getFirst()
    {
        throw new IndexOutOfBoundsException("Index: 0, Size: 0");
    }

    public byte getLast()
    {
        throw new IndexOutOfBoundsException("Index: 0, Size: 0");
    }

    public int indexOf(byte value)
    {
        return -1;
    }

    public int lastIndexOf(byte value)
    {
        return -1;
    }

    public ByteIterator byteIterator()
    {
        return ImmutableEmptyByteIterator.INSTANCE;
    }

    public void forEach(ByteProcedure procedure)
    {
    }

    /**
     * @since 7.0.
     */
    public void each(ByteProcedure procedure)
    {
    }

    public void forEachWithIndex(ByteIntProcedure procedure)
    {
    }

    public int count(BytePredicate predicate)
    {
        return 0;
    }

    public boolean anySatisfy(BytePredicate predicate)
    {
        return false;
    }

    public boolean allSatisfy(BytePredicate predicate)
    {
        return true;
    }

    public boolean noneSatisfy(BytePredicate predicate)
    {
        return true;
    }

    public ImmutableByteList select(BytePredicate predicate)
    {
        return this;
    }

    public ImmutableByteList reject(BytePredicate predicate)
    {
        return this;
    }

    public byte detectIfNone(BytePredicate predicate, byte ifNone)
    {
        return ifNone;
    }

    public <V> ImmutableList<V> collect(ByteToObjectFunction<? extends V> function)
    {
        return Lists.immutable.of();
    }

    public long sum()
    {
        return 0;
    }

    public byte max()
    {
        throw new NoSuchElementException();
    }

    public byte maxIfEmpty(byte defaultValue)
    {
        return defaultValue;
    }

    public byte min()
    {
        throw new NoSuchElementException();
    }

    public byte minIfEmpty(byte defaultValue)
    {
        return defaultValue;
    }

    public double average()
    {
        throw new ArithmeticException();
    }

    public double median()
    {
        throw new ArithmeticException();
    }

    public byte[] toSortedArray()
    {
        return new byte[0];
    }

    public MutableByteList toSortedList()
    {
        return new ByteArrayList();
    }

    public int binarySearch(byte value)
    {
        return -1;
    }

    public long dotProduct(ByteList list)
    {
        if (!list.isEmpty())
        {
            throw new IllegalArgumentException("Lists used in dotProduct must be the same size");
        }
        return 0;
    }

    public byte[] toArray()
    {
        return new byte[0];
    }

    public boolean contains(byte value)
    {
        return false;
    }

    public boolean containsAll(byte... source)
    {
        return source.length == 0;
    }

    public boolean containsAll(ByteIterable source)
    {
        return source.isEmpty();
    }

    public LazyByteIterable asReversed()
    {
        return ReverseByteIterable.adapt(this);
    }

    public MutableByteList toList()
    {
        return new ByteArrayList();
    }

    public MutableByteSet toSet()
    {
        return new ByteHashSet();
    }

    public MutableByteBag toBag()
    {
        return new ByteHashBag();
    }

    public LazyByteIterable asLazy()
    {
        return new LazyByteIterableAdapter(this);
    }

    public ImmutableByteList toImmutable()
    {
        return this;
    }

    public ImmutableByteEmptyList toReversed()
    {
        return this;
    }

    public ImmutableByteList newWith(byte element)
    {
        return ByteLists.immutable.with(element);
    }

    public ImmutableByteList newWithout(byte element)
    {
        return this;
    }

    public ImmutableByteList newWithAll(ByteIterable elements)
    {
        return ByteLists.immutable.withAll(elements);
    }

    public ImmutableByteList newWithoutAll(ByteIterable elements)
    {
        return this;
    }

    public int size()
    {
        return 0;
    }

    public boolean isEmpty()
    {
        return true;
    }

    public boolean notEmpty()
    {
        return false;
    }

    public <T> T injectInto(T injectedValue, ObjectByteToObjectFunction<? super T, ? extends T> function)
    {
        return injectedValue;
    }

    public <T> T injectIntoWithIndex(T injectedValue, ObjectByteIntToObjectFunction<? super T, ? extends T> function)
    {
        return injectedValue;
    }

    @Override
    public boolean equals(Object otherList)
    {
        if (otherList == this)
        {
            return true;
        }
        if (!(otherList instanceof ByteList))
        {
            return false;
        }
        ByteList list = (ByteList) otherList;
        return list.isEmpty();
    }

    @Override
    public int hashCode()
    {
        return 1;
    }

    @Override
    public String toString()
    {
        return "[]";
    }

    public String makeString()
    {
        return "";
    }

    public String makeString(String separator)
    {
        return "";
    }

    public String makeString(String start, String separator, String end)
    {
        return start + end;
    }

    public void appendString(Appendable appendable)
    {
    }

    public void appendString(Appendable appendable, String separator)
    {
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        try
        {
            appendable.append(start);
            appendable.append(end);
        }
        catch (IOException e)
        {
            throw new RuntimeException(e);
        }
    }

    /**
     * @since 6.0.
     */
    public ImmutableByteList distinct()
    {
        return INSTANCE;
    }

    public ImmutableByteList subList(int fromIndex, int toIndex)
    {
        throw new UnsupportedOperationException("subList not yet implemented!");
    }
}
