/*
 * Copyright (c) 2017 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.impl.list.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import java.util.NoSuchElementException;

import org.eclipse.collections.api.FloatIterable;
import org.eclipse.collections.api.LazyFloatIterable;
import org.eclipse.collections.api.bag.primitive.MutableFloatBag;
import org.eclipse.collections.api.block.function.primitive.FloatToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectFloatToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectFloatIntToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.FloatPredicate;
import org.eclipse.collections.api.block.procedure.primitive.FloatProcedure;
import org.eclipse.collections.api.block.procedure.primitive.FloatIntProcedure;
import org.eclipse.collections.api.iterator.FloatIterator;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.list.primitive.ImmutableFloatList;
import org.eclipse.collections.api.list.primitive.FloatList;
import org.eclipse.collections.api.list.primitive.MutableFloatList;
import org.eclipse.collections.api.set.primitive.MutableFloatSet;
import org.eclipse.collections.impl.bag.mutable.primitive.FloatHashBag;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.primitive.FloatLists;
import org.eclipse.collections.impl.iterator.ImmutableEmptyFloatIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyFloatIterableAdapter;
import org.eclipse.collections.impl.lazy.primitive.ReverseFloatIterable;
import org.eclipse.collections.impl.list.mutable.primitive.FloatArrayList;
import org.eclipse.collections.impl.set.mutable.primitive.FloatHashSet;
import net.jcip.annotations.Immutable;

/**
 * ImmutableFloatEmptyList is an optimization for {@link ImmutableFloatList} of size 0.
 * This file was automatically generated from template file immutablePrimitiveEmptyList.stg.
 */
@Immutable
final class ImmutableFloatEmptyList implements ImmutableFloatList, Serializable
{
    static final ImmutableFloatList INSTANCE = new ImmutableFloatEmptyList();
    private static final long serialVersionUID = 1L;

    private Object readResolve()
    {
        return INSTANCE;
    }

    public float get(int index)
    {
        throw new IndexOutOfBoundsException("Index: " + index + ", Size: 0");
    }

    public float getFirst()
    {
        throw new IndexOutOfBoundsException("Index: 0, Size: 0");
    }

    public float getLast()
    {
        throw new IndexOutOfBoundsException("Index: 0, Size: 0");
    }

    public int indexOf(float value)
    {
        return -1;
    }

    public int lastIndexOf(float value)
    {
        return -1;
    }

    public FloatIterator floatIterator()
    {
        return ImmutableEmptyFloatIterator.INSTANCE;
    }

    public void forEach(FloatProcedure procedure)
    {
    }

    /**
     * @since 7.0.
     */
    public void each(FloatProcedure procedure)
    {
    }

    public void forEachWithIndex(FloatIntProcedure procedure)
    {
    }

    public int count(FloatPredicate predicate)
    {
        return 0;
    }

    public boolean anySatisfy(FloatPredicate predicate)
    {
        return false;
    }

    public boolean allSatisfy(FloatPredicate predicate)
    {
        return true;
    }

    public boolean noneSatisfy(FloatPredicate predicate)
    {
        return true;
    }

    public ImmutableFloatList select(FloatPredicate predicate)
    {
        return this;
    }

    public ImmutableFloatList reject(FloatPredicate predicate)
    {
        return this;
    }

    public float detectIfNone(FloatPredicate predicate, float ifNone)
    {
        return ifNone;
    }

    public <V> ImmutableList<V> collect(FloatToObjectFunction<? extends V> function)
    {
        return Lists.immutable.of();
    }

    public double sum()
    {
        return 0;
    }

    public float max()
    {
        throw new NoSuchElementException();
    }

    public float maxIfEmpty(float defaultValue)
    {
        return defaultValue;
    }

    public float min()
    {
        throw new NoSuchElementException();
    }

    public float minIfEmpty(float defaultValue)
    {
        return defaultValue;
    }

    public double average()
    {
        throw new ArithmeticException();
    }

    public double median()
    {
        throw new ArithmeticException();
    }

    public float[] toSortedArray()
    {
        return new float[0];
    }

    public MutableFloatList toSortedList()
    {
        return new FloatArrayList();
    }

    public int binarySearch(float value)
    {
        return -1;
    }

    public double dotProduct(FloatList list)
    {
        if (!list.isEmpty())
        {
            throw new IllegalArgumentException("Lists used in dotProduct must be the same size");
        }
        return 0;
    }

    public float[] toArray()
    {
        return new float[0];
    }

    public boolean contains(float value)
    {
        return false;
    }

    public boolean containsAll(float... source)
    {
        return source.length == 0;
    }

    public boolean containsAll(FloatIterable source)
    {
        return source.isEmpty();
    }

    public LazyFloatIterable asReversed()
    {
        return ReverseFloatIterable.adapt(this);
    }

    public MutableFloatList toList()
    {
        return new FloatArrayList();
    }

    public MutableFloatSet toSet()
    {
        return new FloatHashSet();
    }

    public MutableFloatBag toBag()
    {
        return new FloatHashBag();
    }

    public LazyFloatIterable asLazy()
    {
        return new LazyFloatIterableAdapter(this);
    }

    public ImmutableFloatList toImmutable()
    {
        return this;
    }

    public ImmutableFloatEmptyList toReversed()
    {
        return this;
    }

    public ImmutableFloatList newWith(float element)
    {
        return FloatLists.immutable.with(element);
    }

    public ImmutableFloatList newWithout(float element)
    {
        return this;
    }

    public ImmutableFloatList newWithAll(FloatIterable elements)
    {
        return FloatLists.immutable.withAll(elements);
    }

    public ImmutableFloatList newWithoutAll(FloatIterable elements)
    {
        return this;
    }

    public int size()
    {
        return 0;
    }

    public boolean isEmpty()
    {
        return true;
    }

    public boolean notEmpty()
    {
        return false;
    }

    public <T> T injectInto(T injectedValue, ObjectFloatToObjectFunction<? super T, ? extends T> function)
    {
        return injectedValue;
    }

    public <T> T injectIntoWithIndex(T injectedValue, ObjectFloatIntToObjectFunction<? super T, ? extends T> function)
    {
        return injectedValue;
    }

    @Override
    public boolean equals(Object otherList)
    {
        if (otherList == this)
        {
            return true;
        }
        if (!(otherList instanceof FloatList))
        {
            return false;
        }
        FloatList list = (FloatList) otherList;
        return list.isEmpty();
    }

    @Override
    public int hashCode()
    {
        return 1;
    }

    @Override
    public String toString()
    {
        return "[]";
    }

    public String makeString()
    {
        return "";
    }

    public String makeString(String separator)
    {
        return "";
    }

    public String makeString(String start, String separator, String end)
    {
        return start + end;
    }

    public void appendString(Appendable appendable)
    {
    }

    public void appendString(Appendable appendable, String separator)
    {
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        try
        {
            appendable.append(start);
            appendable.append(end);
        }
        catch (IOException e)
        {
            throw new RuntimeException(e);
        }
    }

    /**
     * @since 6.0.
     */
    public ImmutableFloatList distinct()
    {
        return INSTANCE;
    }

    public ImmutableFloatList subList(int fromIndex, int toIndex)
    {
        throw new UnsupportedOperationException("subList not yet implemented!");
    }
}
