/*
 * Copyright (c) 2017 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.impl.map.immutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;

import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.LazyIntIterable;
import org.eclipse.collections.api.LazyLongIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.ImmutableBag;
import org.eclipse.collections.api.bag.primitive.MutableLongBag;
import org.eclipse.collections.api.bag.primitive.ImmutableLongBag;
import org.eclipse.collections.api.block.function.primitive.LongToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectLongToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.IntLongPredicate;
import org.eclipse.collections.api.block.predicate.primitive.LongPredicate;
import org.eclipse.collections.api.block.procedure.primitive.IntLongProcedure;
import org.eclipse.collections.api.block.procedure.primitive.IntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.collection.ImmutableCollection;
import org.eclipse.collections.api.collection.primitive.ImmutableLongCollection;
import org.eclipse.collections.api.collection.primitive.MutableLongCollection;
import org.eclipse.collections.api.iterator.IntIterator;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.api.map.primitive.IntLongMap;
import org.eclipse.collections.api.map.primitive.ImmutableIntLongMap;
import org.eclipse.collections.api.map.primitive.MutableIntLongMap;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.api.tuple.primitive.IntLongPair;
import org.eclipse.collections.impl.block.procedure.checked.primitive.CheckedIntLongProcedure;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableLongCollection;
import org.eclipse.collections.impl.iterator.UnmodifiableLongIterator;
import org.eclipse.collections.impl.map.mutable.primitive.IntLongHashMap;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableIntSet;

/**
 * ImmutableIntLongHashMap is the non-modifiable equivalent of {@link IntLongHashMap}.
 * This file was automatically generated from template file immutablePrimitivePrimitiveHashMap.stg.
 *
 * @since 4.0.
 */
final class ImmutableIntLongHashMap implements ImmutableIntLongMap, Serializable
{
    private static final long serialVersionUID = 1L;
    private final MutableIntLongMap delegate;

    ImmutableIntLongHashMap(IntLongMap delegate)
    {
        this.delegate = new IntLongHashMap(delegate);
    }

    public long get(int key)
    {
        return this.delegate.get(key);
    }

    public long getIfAbsent(int key, long ifAbsent)
    {
        return this.delegate.getIfAbsent(key, ifAbsent);
    }

    public long getOrThrow(int key)
    {
        return this.delegate.getOrThrow(key);
    }

    public boolean containsKey(int key)
    {
        return this.delegate.containsKey(key);
    }

    public boolean containsValue(long value)
    {
        return this.delegate.containsValue(value);
    }

    public void forEachValue(LongProcedure procedure)
    {
        this.delegate.forEachValue(procedure);
    }

    public void forEachKey(IntProcedure procedure)
    {
        this.delegate.forEachKey(procedure);
    }

    public void forEachKeyValue(IntLongProcedure procedure)
    {
        this.delegate.forEachKeyValue(procedure);
    }

    public LazyIntIterable keysView()
    {
        return this.delegate.keysView();
    }

    public RichIterable<IntLongPair> keyValuesView()
    {
        return this.delegate.keyValuesView();
    }

    public ImmutableIntLongMap select(IntLongPredicate predicate)
    {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableIntLongMap reject(IntLongPredicate predicate)
    {
        return this.delegate.reject(predicate).toImmutable();
    }

    public <T> T injectInto(T injectedValue, ObjectLongToObjectFunction<? super T, ? extends T> function)
    {
        return this.delegate.injectInto(injectedValue, function);
    }

    public ImmutableIntLongMap toImmutable()
    {
        return this;
    }

    public LongIterator longIterator()
    {
        return new UnmodifiableLongIterator(this.delegate.longIterator());
    }

    public void forEach(LongProcedure procedure)
    {
        this.each(procedure);
    }

    /**
     * @since 7.0.
     */
    public void each(LongProcedure procedure)
    {
        this.delegate.forEach(procedure);
    }

    public int count(LongPredicate predicate)
    {
        return this.delegate.count(predicate);
    }

    public boolean anySatisfy(LongPredicate predicate)
    {
        return this.delegate.anySatisfy(predicate);
    }

    public boolean allSatisfy(LongPredicate predicate)
    {
        return this.delegate.allSatisfy(predicate);
    }

    public boolean noneSatisfy(LongPredicate predicate)
    {
        return this.delegate.noneSatisfy(predicate);
    }

    public ImmutableLongBag select(LongPredicate predicate)
    {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableLongBag reject(LongPredicate predicate)
    {
        return this.delegate.reject(predicate).toImmutable();
    }

    public <V> ImmutableBag<V> collect(LongToObjectFunction<? extends V> function)
    {
        return this.delegate.collect(function).toImmutable();
    }

    public long detectIfNone(LongPredicate predicate, long ifNone)
    {
        return this.delegate.detectIfNone(predicate, ifNone);
    }

    public long sum()
    {
        return this.delegate.sum();
    }

    public long max()
    {
        return this.delegate.max();
    }

    public long maxIfEmpty(long defaultValue)
    {
        return this.delegate.maxIfEmpty(defaultValue);
    }

    public long min()
    {
        return this.delegate.min();
    }

    public long minIfEmpty(long defaultValue)
    {
        return this.delegate.minIfEmpty(defaultValue);
    }

    public double average()
    {
        return this.delegate.average();
    }

    public double median()
    {
        return this.delegate.median();
    }

    public long[] toSortedArray()
    {
        return this.delegate.toSortedArray();
    }

    public MutableLongList toSortedList()
    {
        return this.delegate.toSortedList();
    }

    public long[] toArray()
    {
        return this.delegate.toArray();
    }

    public boolean contains(long value)
    {
        return this.delegate.contains(value);
    }

    public boolean containsAll(long... source)
    {
        return this.delegate.containsAll(source);
    }

    public boolean containsAll(LongIterable source)
    {
        return this.delegate.containsAll(source);
    }

    public MutableLongList toList()
    {
        return this.delegate.toList();
    }

    public MutableLongSet toSet()
    {
        return this.delegate.toSet();
    }

    public MutableLongBag toBag()
    {
        return this.delegate.toBag();
    }

    public LazyLongIterable asLazy()
    {
        return this.delegate.asLazy();
    }

    public ImmutableIntLongMap newWithKeyValue(int key, long value)
    {
        MutableIntLongMap map = new IntLongHashMap(this.size() + 1);
        map.putAll(this);
        map.put(key, value);
        return map.toImmutable();
    }

    public ImmutableIntLongMap newWithoutKey(int key)
    {
        MutableIntLongMap map = new IntLongHashMap(this.size());
        map.putAll(this);
        map.removeKey(key);
        return map.toImmutable();
    }

    public ImmutableIntLongMap newWithoutAllKeys(IntIterable keys)
    {
        MutableIntLongMap map = new IntLongHashMap(this.size());
        map.putAll(this);
        IntIterator iterator = keys.intIterator();
        while (iterator.hasNext())
        {
            map.removeKey(iterator.next());
        }
        return map.toImmutable();
    }

    public int size()
    {
        return this.delegate.size();
    }

    public boolean isEmpty()
    {
        return this.delegate.isEmpty();
    }

    public boolean notEmpty()
    {
        return this.delegate.notEmpty();
    }

    public String makeString()
    {
        return this.delegate.makeString();
    }

    public String makeString(String separator)
    {
        return this.delegate.makeString(separator);
    }

    public String makeString(String start, String separator, String end)
    {
        return this.delegate.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable)
    {
        this.delegate.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator)
    {
        this.delegate.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        this.delegate.appendString(appendable, start, separator, end);
    }

    public MutableIntSet keySet()
    {
        return UnmodifiableIntSet.of(this.delegate.keySet());
    }

    public MutableLongCollection values()
    {
        return UnmodifiableLongCollection.of(this.delegate.values());
    }

    @Override
    public boolean equals(Object obj)
    {
        return this.delegate.equals(obj);
    }

    @Override
    public int hashCode()
    {
        return this.delegate.hashCode();
    }

    @Override
    public String toString()
    {
        return this.delegate.toString();
    }

    private Object writeReplace()
    {
        return new ImmutableIntLongMapSerializationProxy(this);
    }

    protected static class ImmutableIntLongMapSerializationProxy implements Externalizable
    {
        private static final long serialVersionUID = 1L;

        private IntLongMap map;

        @SuppressWarnings("UnusedDeclaration")
        public ImmutableIntLongMapSerializationProxy()
        {
            // Empty constructor for Externalizable class
        }

        protected ImmutableIntLongMapSerializationProxy(IntLongMap map)
        {
            this.map = map;
        }

        public void writeExternal(final ObjectOutput out) throws IOException
        {
            out.writeInt(this.map.size());
            try
            {
                this.map.forEachKeyValue(new CheckedIntLongProcedure()
                {
                    @Override
                    public void safeValue(int key, long value) throws IOException
                    {
                        out.writeInt(key);
                        out.writeLong(value);
                    }
                });
            }
            catch (RuntimeException e)
            {
                if (e.getCause() instanceof IOException)
                {
                    throw (IOException) e.getCause();
                }
                throw e;
            }
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException
        {
            int size = in.readInt();
            MutableIntLongMap deserializedMap = new IntLongHashMap();

            for (int i = 0; i < size; i++)
            {
                deserializedMap.put(in.readInt(), in.readLong());
            }

            this.map = deserializedMap;
        }

        protected Object readResolve()
        {
            return this.map.toImmutable();
        }
    }
}
