/*
 * Copyright (c) 2017 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.impl.map.immutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;

import org.eclipse.collections.api.ShortIterable;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.LazyShortIterable;
import org.eclipse.collections.api.LazyLongIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.ImmutableBag;
import org.eclipse.collections.api.bag.primitive.MutableLongBag;
import org.eclipse.collections.api.bag.primitive.ImmutableLongBag;
import org.eclipse.collections.api.block.function.primitive.LongToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectLongToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.ShortLongPredicate;
import org.eclipse.collections.api.block.predicate.primitive.LongPredicate;
import org.eclipse.collections.api.block.procedure.primitive.ShortLongProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ShortProcedure;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.collection.ImmutableCollection;
import org.eclipse.collections.api.collection.primitive.ImmutableLongCollection;
import org.eclipse.collections.api.collection.primitive.MutableLongCollection;
import org.eclipse.collections.api.iterator.ShortIterator;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.api.map.primitive.ShortLongMap;
import org.eclipse.collections.api.map.primitive.ImmutableShortLongMap;
import org.eclipse.collections.api.map.primitive.MutableShortLongMap;
import org.eclipse.collections.api.set.primitive.MutableShortSet;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.api.tuple.primitive.ShortLongPair;
import org.eclipse.collections.impl.block.procedure.checked.primitive.CheckedShortLongProcedure;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableLongCollection;
import org.eclipse.collections.impl.iterator.UnmodifiableLongIterator;
import org.eclipse.collections.impl.map.mutable.primitive.ShortLongHashMap;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableShortSet;

/**
 * ImmutableShortLongHashMap is the non-modifiable equivalent of {@link ShortLongHashMap}.
 * This file was automatically generated from template file immutablePrimitivePrimitiveHashMap.stg.
 *
 * @since 4.0.
 */
final class ImmutableShortLongHashMap implements ImmutableShortLongMap, Serializable
{
    private static final long serialVersionUID = 1L;
    private final MutableShortLongMap delegate;

    ImmutableShortLongHashMap(ShortLongMap delegate)
    {
        this.delegate = new ShortLongHashMap(delegate);
    }

    public long get(short key)
    {
        return this.delegate.get(key);
    }

    public long getIfAbsent(short key, long ifAbsent)
    {
        return this.delegate.getIfAbsent(key, ifAbsent);
    }

    public long getOrThrow(short key)
    {
        return this.delegate.getOrThrow(key);
    }

    public boolean containsKey(short key)
    {
        return this.delegate.containsKey(key);
    }

    public boolean containsValue(long value)
    {
        return this.delegate.containsValue(value);
    }

    public void forEachValue(LongProcedure procedure)
    {
        this.delegate.forEachValue(procedure);
    }

    public void forEachKey(ShortProcedure procedure)
    {
        this.delegate.forEachKey(procedure);
    }

    public void forEachKeyValue(ShortLongProcedure procedure)
    {
        this.delegate.forEachKeyValue(procedure);
    }

    public LazyShortIterable keysView()
    {
        return this.delegate.keysView();
    }

    public RichIterable<ShortLongPair> keyValuesView()
    {
        return this.delegate.keyValuesView();
    }

    public ImmutableShortLongMap select(ShortLongPredicate predicate)
    {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableShortLongMap reject(ShortLongPredicate predicate)
    {
        return this.delegate.reject(predicate).toImmutable();
    }

    public <T> T injectInto(T injectedValue, ObjectLongToObjectFunction<? super T, ? extends T> function)
    {
        return this.delegate.injectInto(injectedValue, function);
    }

    public ImmutableShortLongMap toImmutable()
    {
        return this;
    }

    public LongIterator longIterator()
    {
        return new UnmodifiableLongIterator(this.delegate.longIterator());
    }

    public void forEach(LongProcedure procedure)
    {
        this.each(procedure);
    }

    /**
     * @since 7.0.
     */
    public void each(LongProcedure procedure)
    {
        this.delegate.forEach(procedure);
    }

    public int count(LongPredicate predicate)
    {
        return this.delegate.count(predicate);
    }

    public boolean anySatisfy(LongPredicate predicate)
    {
        return this.delegate.anySatisfy(predicate);
    }

    public boolean allSatisfy(LongPredicate predicate)
    {
        return this.delegate.allSatisfy(predicate);
    }

    public boolean noneSatisfy(LongPredicate predicate)
    {
        return this.delegate.noneSatisfy(predicate);
    }

    public ImmutableLongBag select(LongPredicate predicate)
    {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableLongBag reject(LongPredicate predicate)
    {
        return this.delegate.reject(predicate).toImmutable();
    }

    public <V> ImmutableBag<V> collect(LongToObjectFunction<? extends V> function)
    {
        return this.delegate.collect(function).toImmutable();
    }

    public long detectIfNone(LongPredicate predicate, long ifNone)
    {
        return this.delegate.detectIfNone(predicate, ifNone);
    }

    public long sum()
    {
        return this.delegate.sum();
    }

    public long max()
    {
        return this.delegate.max();
    }

    public long maxIfEmpty(long defaultValue)
    {
        return this.delegate.maxIfEmpty(defaultValue);
    }

    public long min()
    {
        return this.delegate.min();
    }

    public long minIfEmpty(long defaultValue)
    {
        return this.delegate.minIfEmpty(defaultValue);
    }

    public double average()
    {
        return this.delegate.average();
    }

    public double median()
    {
        return this.delegate.median();
    }

    public long[] toSortedArray()
    {
        return this.delegate.toSortedArray();
    }

    public MutableLongList toSortedList()
    {
        return this.delegate.toSortedList();
    }

    public long[] toArray()
    {
        return this.delegate.toArray();
    }

    public boolean contains(long value)
    {
        return this.delegate.contains(value);
    }

    public boolean containsAll(long... source)
    {
        return this.delegate.containsAll(source);
    }

    public boolean containsAll(LongIterable source)
    {
        return this.delegate.containsAll(source);
    }

    public MutableLongList toList()
    {
        return this.delegate.toList();
    }

    public MutableLongSet toSet()
    {
        return this.delegate.toSet();
    }

    public MutableLongBag toBag()
    {
        return this.delegate.toBag();
    }

    public LazyLongIterable asLazy()
    {
        return this.delegate.asLazy();
    }

    public ImmutableShortLongMap newWithKeyValue(short key, long value)
    {
        MutableShortLongMap map = new ShortLongHashMap(this.size() + 1);
        map.putAll(this);
        map.put(key, value);
        return map.toImmutable();
    }

    public ImmutableShortLongMap newWithoutKey(short key)
    {
        MutableShortLongMap map = new ShortLongHashMap(this.size());
        map.putAll(this);
        map.removeKey(key);
        return map.toImmutable();
    }

    public ImmutableShortLongMap newWithoutAllKeys(ShortIterable keys)
    {
        MutableShortLongMap map = new ShortLongHashMap(this.size());
        map.putAll(this);
        ShortIterator iterator = keys.shortIterator();
        while (iterator.hasNext())
        {
            map.removeKey(iterator.next());
        }
        return map.toImmutable();
    }

    public int size()
    {
        return this.delegate.size();
    }

    public boolean isEmpty()
    {
        return this.delegate.isEmpty();
    }

    public boolean notEmpty()
    {
        return this.delegate.notEmpty();
    }

    public String makeString()
    {
        return this.delegate.makeString();
    }

    public String makeString(String separator)
    {
        return this.delegate.makeString(separator);
    }

    public String makeString(String start, String separator, String end)
    {
        return this.delegate.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable)
    {
        this.delegate.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator)
    {
        this.delegate.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        this.delegate.appendString(appendable, start, separator, end);
    }

    public MutableShortSet keySet()
    {
        return UnmodifiableShortSet.of(this.delegate.keySet());
    }

    public MutableLongCollection values()
    {
        return UnmodifiableLongCollection.of(this.delegate.values());
    }

    @Override
    public boolean equals(Object obj)
    {
        return this.delegate.equals(obj);
    }

    @Override
    public int hashCode()
    {
        return this.delegate.hashCode();
    }

    @Override
    public String toString()
    {
        return this.delegate.toString();
    }

    private Object writeReplace()
    {
        return new ImmutableShortLongMapSerializationProxy(this);
    }

    protected static class ImmutableShortLongMapSerializationProxy implements Externalizable
    {
        private static final long serialVersionUID = 1L;

        private ShortLongMap map;

        @SuppressWarnings("UnusedDeclaration")
        public ImmutableShortLongMapSerializationProxy()
        {
            // Empty constructor for Externalizable class
        }

        protected ImmutableShortLongMapSerializationProxy(ShortLongMap map)
        {
            this.map = map;
        }

        public void writeExternal(final ObjectOutput out) throws IOException
        {
            out.writeInt(this.map.size());
            try
            {
                this.map.forEachKeyValue(new CheckedShortLongProcedure()
                {
                    @Override
                    public void safeValue(short key, long value) throws IOException
                    {
                        out.writeShort(key);
                        out.writeLong(value);
                    }
                });
            }
            catch (RuntimeException e)
            {
                if (e.getCause() instanceof IOException)
                {
                    throw (IOException) e.getCause();
                }
                throw e;
            }
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException
        {
            int size = in.readInt();
            MutableShortLongMap deserializedMap = new ShortLongHashMap();

            for (int i = 0; i < size; i++)
            {
                deserializedMap.put(in.readShort(), in.readLong());
            }

            this.map = deserializedMap;
        }

        protected Object readResolve()
        {
            return this.map.toImmutable();
        }
    }
}
