/*
 * Copyright (c) 2017 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.impl.map.mutable.primitive;

import java.io.Serializable;

import org.eclipse.collections.api.ByteIterable;
import org.eclipse.collections.api.LazyByteIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.bag.primitive.MutableByteBag;
import org.eclipse.collections.api.block.function.primitive.ByteFunction;
import org.eclipse.collections.api.block.function.primitive.ByteFunction0;
import org.eclipse.collections.api.block.function.primitive.ByteToByteFunction;
import org.eclipse.collections.api.block.function.primitive.ByteToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectByteToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.BytePredicate;
import org.eclipse.collections.api.block.predicate.primitive.ByteBytePredicate;
import org.eclipse.collections.api.block.procedure.primitive.ByteByteProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ByteProcedure;
import org.eclipse.collections.api.collection.primitive.MutableByteCollection;
import org.eclipse.collections.api.iterator.MutableByteIterator;
import org.eclipse.collections.api.list.primitive.MutableByteList;
import org.eclipse.collections.api.map.primitive.ImmutableByteByteMap;
import org.eclipse.collections.api.map.primitive.ByteByteMap;
import org.eclipse.collections.api.map.primitive.MutableByteByteMap;
import org.eclipse.collections.api.set.primitive.MutableByteSet;
import org.eclipse.collections.api.tuple.primitive.ByteBytePair;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableByteCollection;
import org.eclipse.collections.impl.factory.primitive.ByteByteMaps;
import org.eclipse.collections.impl.iterator.UnmodifiableByteIterator;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableByteSet;

/**
 * This file was automatically generated from template file unmodifiablePrimitivePrimitiveMap.stg.
 *
 * @since 3.1.
 */
public final class UnmodifiableByteByteMap
        implements MutableByteByteMap, Serializable
{
    private static final long serialVersionUID = 1L;
    private final MutableByteByteMap map;

    public UnmodifiableByteByteMap(MutableByteByteMap map)
    {
        if(map == null)
        {
            throw new IllegalArgumentException("Cannot create a UnmodifiableByteByteMap on a null map");
        }

        this.map = map;
    }

    public void clear()
    {
        throw new UnsupportedOperationException("Cannot call clear() on " + this.getClass().getSimpleName());
    }

    public void put(byte key, byte value)
    {
        throw new UnsupportedOperationException("Cannot call put() on " + this.getClass().getSimpleName());
    }

    public void putAll(ByteByteMap map)
    {
        throw new UnsupportedOperationException("Cannot call putAll() on " + this.getClass().getSimpleName());
    }

    public void removeKey(byte key)
    {
        throw new UnsupportedOperationException("Cannot call removeKey() on " + this.getClass().getSimpleName());
    }

    public void remove(byte key)
    {
        throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
    }

    public byte removeKeyIfAbsent(byte key, byte value)
    {
        if (this.map.containsKey(key))
        {
            throw new UnsupportedOperationException("Cannot call removeKey() on " + this.getClass().getSimpleName());
        }
        return value;
    }

    public byte getIfAbsentPut(byte key, byte value)
    {
        return this.map.getIfAbsentPut(key, () -> {throw new UnsupportedOperationException();});
    }

    public byte getIfAbsentPut(byte key, ByteFunction0 function)
    {
        return this.map.getIfAbsentPut(key, () -> {throw new UnsupportedOperationException();});
    }

    public byte getIfAbsentPutWithKey(byte key, ByteToByteFunction function)
    {
        return this.map.getIfAbsentPut(key, () -> {throw new UnsupportedOperationException();});
    }

    public <P> byte getIfAbsentPutWith(byte key, ByteFunction<? super P> function, P parameter)
    {
        return this.map.getIfAbsentPut(key, () -> {throw new UnsupportedOperationException();});
    }

    public byte updateValue(byte key, byte initialValueIfAbsent, ByteToByteFunction function)
    {
        throw new UnsupportedOperationException("Cannot call updateValue() on " + this.getClass().getSimpleName());
    }

    public byte get(byte key)
    {
        return this.map.get(key);
    }

    public byte getIfAbsent(byte key, byte ifAbsent)
    {
        return this.map.getIfAbsent(key, ifAbsent);
    }

    public byte getOrThrow(byte key)
    {
        return this.map.getOrThrow(key);
    }

    public boolean containsKey(byte key)
    {
        return this.map.containsKey(key);
    }

    public boolean containsValue(byte value)
    {
        return this.map.containsValue(value);
    }

    public void forEachValue(ByteProcedure procedure)
    {
        this.map.forEachValue(procedure);
    }

    public void forEachKey(ByteProcedure procedure)
    {
        this.map.forEachKey(procedure);
    }

    public void forEachKeyValue(ByteByteProcedure procedure)
    {
        this.map.forEachKeyValue(procedure);
    }

    public LazyByteIterable keysView()
    {
        return this.map.keysView();
    }

    public RichIterable<ByteBytePair> keyValuesView()
    {
        return this.map.keyValuesView();
    }

    public MutableByteByteMap select(ByteBytePredicate predicate)
    {
        return this.map.select(predicate);
    }

    public MutableByteByteMap reject(ByteBytePredicate predicate)
    {
        return this.map.reject(predicate);
    }

    public MutableByteIterator byteIterator()
    {
        return new UnmodifiableByteIterator(this.map.byteIterator());
    }

    public void forEach(ByteProcedure procedure)
    {
        this.each(procedure);
    }

    /**
     * @since 7.0.
     */
    public void each(ByteProcedure procedure)
    {
        this.map.forEach(procedure);
    }

    public int count(BytePredicate predicate)
    {
        return this.map.count(predicate);
    }

    public boolean anySatisfy(BytePredicate predicate)
    {
        return this.map.anySatisfy(predicate);
    }

    public boolean allSatisfy(BytePredicate predicate)
    {
        return this.map.allSatisfy(predicate);
    }

    public boolean noneSatisfy(BytePredicate predicate)
    {
        return this.map.noneSatisfy(predicate);
    }

    public MutableByteBag select(BytePredicate predicate)
    {
        return this.map.select(predicate);
    }

    public MutableByteBag reject(BytePredicate predicate)
    {
        return this.map.reject(predicate);
    }

    public <V> MutableBag<V> collect(ByteToObjectFunction<? extends V> function)
    {
        return this.map.collect(function);
    }

    public byte detectIfNone(BytePredicate predicate, byte ifNone)
    {
        return this.map.detectIfNone(predicate, ifNone);
    }

    public long sum()
    {
        return this.map.sum();
    }

    public byte max()
    {
        return this.map.max();
    }

    public byte maxIfEmpty(byte defaultValue)
    {
        return this.map.maxIfEmpty(defaultValue);
    }

    public byte min()
    {
        return this.map.min();
    }

    public byte minIfEmpty(byte defaultValue)
    {
        return this.map.minIfEmpty(defaultValue);
    }

    public double average()
    {
        return this.map.average();
    }

    public double median()
    {
        return this.map.median();
    }

    public byte addToValue(byte key, byte toBeAdded)
    {
        throw new UnsupportedOperationException("Cannot call addToValue() on " + this.getClass().getSimpleName());
    }

    public byte[] toSortedArray()
    {
        return this.map.toSortedArray();
    }

    public MutableByteList toSortedList()
    {
        return this.map.toSortedList();
    }

    public byte[] toArray()
    {
        return this.map.toArray();
    }

    public boolean contains(byte value)
    {
        return this.map.contains(value);
    }

    public boolean containsAll(byte... source)
    {
        return this.map.containsAll(source);
    }

    public boolean containsAll(ByteIterable source)
    {
        return this.map.containsAll(source);
    }

    public MutableByteList toList()
    {
        return this.map.toList();
    }

    public MutableByteSet toSet()
    {
        return this.map.toSet();
    }

    public MutableByteBag toBag()
    {
        return this.map.toBag();
    }

    public LazyByteIterable asLazy()
    {
        return this.map.asLazy();
    }

    public MutableByteByteMap withKeyValue(byte key, byte value)
    {
        throw new UnsupportedOperationException("Cannot call withKeyValue() on " + this.getClass().getSimpleName());
    }

    public MutableByteByteMap withoutKey(byte key)
    {
        throw new UnsupportedOperationException("Cannot call withoutKey() on " + this.getClass().getSimpleName());
    }

    public MutableByteByteMap withoutAllKeys(ByteIterable keys)
    {
        throw new UnsupportedOperationException("Cannot call withoutAllKeys() on " + this.getClass().getSimpleName());
    }

    public MutableByteByteMap asUnmodifiable()
    {
        return this;
    }

    public MutableByteByteMap asSynchronized()
    {
        return new SynchronizedByteByteMap(this);
    }

    public ImmutableByteByteMap toImmutable()
    {
        return ByteByteMaps.immutable.withAll(this);
    }

    public int size()
    {
        return this.map.size();
    }

    public boolean isEmpty()
    {
        return this.map.isEmpty();
    }

    public boolean notEmpty()
    {
        return this.map.notEmpty();
    }

    public MutableByteSet keySet()
    {
        return UnmodifiableByteSet.of(this.map.keySet());
    }

    public MutableByteCollection values()
    {
        return UnmodifiableByteCollection.of(this.map.values());
    }

    @Override
    public boolean equals(Object otherMap)
    {
        return this.map.equals(otherMap);
    }

    @Override
    public int hashCode()
    {
        return this.map.hashCode();
    }

    @Override
    public String toString()
    {
        return this.map.toString();
    }

    public String makeString()
    {
        return this.map.makeString();
    }

    public String makeString(String separator)
    {
        return this.map.makeString(separator);
    }

    public String makeString(String start, String separator, String end)
    {
        return this.map.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable)
    {
        this.map.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator)
    {
        this.map.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        this.map.appendString(appendable, start, separator, end);
    }

    public <T> T injectInto(T injectedValue, ObjectByteToObjectFunction<? super T, ? extends T> function)
    {
        return this.map.injectInto(injectedValue, function);
    }
}
