/*
 * Copyright (c) 2017 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.impl.map.mutable.primitive;

import java.io.Serializable;

import org.eclipse.collections.api.BooleanIterable;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.LazyBooleanIterable;
import org.eclipse.collections.api.LazyIntIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.bag.primitive.MutableBooleanBag;
import org.eclipse.collections.api.block.function.primitive.BooleanFunction;
import org.eclipse.collections.api.block.function.primitive.BooleanFunction0;
import org.eclipse.collections.api.block.function.primitive.BooleanToBooleanFunction;
import org.eclipse.collections.api.block.function.primitive.BooleanToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectBooleanToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.IntToBooleanFunction;
import org.eclipse.collections.api.block.predicate.primitive.BooleanPredicate;
import org.eclipse.collections.api.block.predicate.primitive.IntBooleanPredicate;
import org.eclipse.collections.api.block.procedure.primitive.BooleanProcedure;
import org.eclipse.collections.api.block.procedure.primitive.IntBooleanProcedure;
import org.eclipse.collections.api.block.procedure.primitive.IntProcedure;
import org.eclipse.collections.api.collection.primitive.MutableBooleanCollection;
import org.eclipse.collections.api.iterator.MutableBooleanIterator;
import org.eclipse.collections.api.list.primitive.MutableBooleanList;
import org.eclipse.collections.api.map.primitive.ImmutableIntBooleanMap;
import org.eclipse.collections.api.map.primitive.IntBooleanMap;
import org.eclipse.collections.api.map.primitive.MutableIntBooleanMap;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.api.set.primitive.MutableBooleanSet;
import org.eclipse.collections.api.tuple.primitive.IntBooleanPair;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableBooleanCollection;
import org.eclipse.collections.impl.factory.primitive.IntBooleanMaps;
import org.eclipse.collections.impl.iterator.UnmodifiableBooleanIterator;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableIntSet;

/**
 * This file was automatically generated from template file unmodifiablePrimitivePrimitiveMap.stg.
 *
 * @since 3.1.
 */
public final class UnmodifiableIntBooleanMap
        implements MutableIntBooleanMap, Serializable
{
    private static final long serialVersionUID = 1L;
    private final MutableIntBooleanMap map;

    public UnmodifiableIntBooleanMap(MutableIntBooleanMap map)
    {
        if(map == null)
        {
            throw new IllegalArgumentException("Cannot create a UnmodifiableIntBooleanMap on a null map");
        }

        this.map = map;
    }

    public void clear()
    {
        throw new UnsupportedOperationException("Cannot call clear() on " + this.getClass().getSimpleName());
    }

    public void put(int key, boolean value)
    {
        throw new UnsupportedOperationException("Cannot call put() on " + this.getClass().getSimpleName());
    }

    public void putAll(IntBooleanMap map)
    {
        throw new UnsupportedOperationException("Cannot call putAll() on " + this.getClass().getSimpleName());
    }

    public void removeKey(int key)
    {
        throw new UnsupportedOperationException("Cannot call removeKey() on " + this.getClass().getSimpleName());
    }

    public void remove(int key)
    {
        throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
    }

    public boolean removeKeyIfAbsent(int key, boolean value)
    {
        if (this.map.containsKey(key))
        {
            throw new UnsupportedOperationException("Cannot call removeKey() on " + this.getClass().getSimpleName());
        }
        return value;
    }

    public boolean getIfAbsentPut(int key, boolean value)
    {
        return this.map.getIfAbsentPut(key, () -> {throw new UnsupportedOperationException();});
    }

    public boolean getIfAbsentPut(int key, BooleanFunction0 function)
    {
        return this.map.getIfAbsentPut(key, () -> {throw new UnsupportedOperationException();});
    }

    public boolean getIfAbsentPutWithKey(int key, IntToBooleanFunction function)
    {
        return this.map.getIfAbsentPut(key, () -> {throw new UnsupportedOperationException();});
    }

    public <P> boolean getIfAbsentPutWith(int key, BooleanFunction<? super P> function, P parameter)
    {
        return this.map.getIfAbsentPut(key, () -> {throw new UnsupportedOperationException();});
    }

    public boolean updateValue(int key, boolean initialValueIfAbsent, BooleanToBooleanFunction function)
    {
        throw new UnsupportedOperationException("Cannot call updateValue() on " + this.getClass().getSimpleName());
    }

    public boolean get(int key)
    {
        return this.map.get(key);
    }

    public boolean getIfAbsent(int key, boolean ifAbsent)
    {
        return this.map.getIfAbsent(key, ifAbsent);
    }

    public boolean getOrThrow(int key)
    {
        return this.map.getOrThrow(key);
    }

    public boolean containsKey(int key)
    {
        return this.map.containsKey(key);
    }

    public boolean containsValue(boolean value)
    {
        return this.map.containsValue(value);
    }

    public void forEachValue(BooleanProcedure procedure)
    {
        this.map.forEachValue(procedure);
    }

    public void forEachKey(IntProcedure procedure)
    {
        this.map.forEachKey(procedure);
    }

    public void forEachKeyValue(IntBooleanProcedure procedure)
    {
        this.map.forEachKeyValue(procedure);
    }

    public LazyIntIterable keysView()
    {
        return this.map.keysView();
    }

    public RichIterable<IntBooleanPair> keyValuesView()
    {
        return this.map.keyValuesView();
    }

    public MutableIntBooleanMap select(IntBooleanPredicate predicate)
    {
        return this.map.select(predicate);
    }

    public MutableIntBooleanMap reject(IntBooleanPredicate predicate)
    {
        return this.map.reject(predicate);
    }

    public MutableBooleanIterator booleanIterator()
    {
        return new UnmodifiableBooleanIterator(this.map.booleanIterator());
    }

    public void forEach(BooleanProcedure procedure)
    {
        this.each(procedure);
    }

    /**
     * @since 7.0.
     */
    public void each(BooleanProcedure procedure)
    {
        this.map.forEach(procedure);
    }

    public int count(BooleanPredicate predicate)
    {
        return this.map.count(predicate);
    }

    public boolean anySatisfy(BooleanPredicate predicate)
    {
        return this.map.anySatisfy(predicate);
    }

    public boolean allSatisfy(BooleanPredicate predicate)
    {
        return this.map.allSatisfy(predicate);
    }

    public boolean noneSatisfy(BooleanPredicate predicate)
    {
        return this.map.noneSatisfy(predicate);
    }

    public MutableBooleanBag select(BooleanPredicate predicate)
    {
        return this.map.select(predicate);
    }

    public MutableBooleanBag reject(BooleanPredicate predicate)
    {
        return this.map.reject(predicate);
    }

    public <V> MutableBag<V> collect(BooleanToObjectFunction<? extends V> function)
    {
        return this.map.collect(function);
    }

    public boolean detectIfNone(BooleanPredicate predicate, boolean ifNone)
    {
        return this.map.detectIfNone(predicate, ifNone);
    }

    public boolean[] toArray()
    {
        return this.map.toArray();
    }

    public boolean contains(boolean value)
    {
        return this.map.contains(value);
    }

    public boolean containsAll(boolean... source)
    {
        return this.map.containsAll(source);
    }

    public boolean containsAll(BooleanIterable source)
    {
        return this.map.containsAll(source);
    }

    public MutableBooleanList toList()
    {
        return this.map.toList();
    }

    public MutableBooleanSet toSet()
    {
        return this.map.toSet();
    }

    public MutableBooleanBag toBag()
    {
        return this.map.toBag();
    }

    public LazyBooleanIterable asLazy()
    {
        return this.map.asLazy();
    }

    public MutableIntBooleanMap withKeyValue(int key, boolean value)
    {
        throw new UnsupportedOperationException("Cannot call withKeyValue() on " + this.getClass().getSimpleName());
    }

    public MutableIntBooleanMap withoutKey(int key)
    {
        throw new UnsupportedOperationException("Cannot call withoutKey() on " + this.getClass().getSimpleName());
    }

    public MutableIntBooleanMap withoutAllKeys(IntIterable keys)
    {
        throw new UnsupportedOperationException("Cannot call withoutAllKeys() on " + this.getClass().getSimpleName());
    }

    public MutableIntBooleanMap asUnmodifiable()
    {
        return this;
    }

    public MutableIntBooleanMap asSynchronized()
    {
        return new SynchronizedIntBooleanMap(this);
    }

    public ImmutableIntBooleanMap toImmutable()
    {
        return IntBooleanMaps.immutable.withAll(this);
    }

    public int size()
    {
        return this.map.size();
    }

    public boolean isEmpty()
    {
        return this.map.isEmpty();
    }

    public boolean notEmpty()
    {
        return this.map.notEmpty();
    }

    public MutableIntSet keySet()
    {
        return UnmodifiableIntSet.of(this.map.keySet());
    }

    public MutableBooleanCollection values()
    {
        return UnmodifiableBooleanCollection.of(this.map.values());
    }

    @Override
    public boolean equals(Object otherMap)
    {
        return this.map.equals(otherMap);
    }

    @Override
    public int hashCode()
    {
        return this.map.hashCode();
    }

    @Override
    public String toString()
    {
        return this.map.toString();
    }

    public String makeString()
    {
        return this.map.makeString();
    }

    public String makeString(String separator)
    {
        return this.map.makeString(separator);
    }

    public String makeString(String start, String separator, String end)
    {
        return this.map.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable)
    {
        this.map.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator)
    {
        this.map.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        this.map.appendString(appendable, start, separator, end);
    }

    public <T> T injectInto(T injectedValue, ObjectBooleanToObjectFunction<? super T, ? extends T> function)
    {
        return this.map.injectInto(injectedValue, function);
    }
}
