/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.collection.mutable.primitive;

import java.io.Serializable;
import org.eclipse.collections.api.ByteIterable;
import org.eclipse.collections.api.LazyByteIterable;
import org.eclipse.collections.api.bag.primitive.MutableByteBag;
import org.eclipse.collections.api.block.function.primitive.ByteToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectByteToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.BytePredicate;
import org.eclipse.collections.api.block.procedure.primitive.ByteProcedure;
import org.eclipse.collections.api.collection.MutableCollection;
import org.eclipse.collections.api.collection.primitive.ImmutableByteCollection;
import org.eclipse.collections.api.collection.primitive.MutableByteCollection;
import org.eclipse.collections.api.iterator.ByteIterator;
import org.eclipse.collections.api.iterator.MutableByteIterator;
import org.eclipse.collections.api.list.primitive.MutableByteList;
import org.eclipse.collections.api.set.primitive.MutableByteSet;
import org.eclipse.collections.impl.collection.mutable.primitive.SynchronizedByteCollection;
import org.eclipse.collections.impl.iterator.UnmodifiableByteIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyByteIterableAdapter;

public abstract class AbstractUnmodifiableByteCollection
implements MutableByteCollection,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableByteCollection collection;

    protected AbstractUnmodifiableByteCollection(MutableByteCollection collection) {
        if (collection == null) {
            throw new IllegalArgumentException("Cannot create a AbstractUnmodifiableByteCollection on a null collection");
        }
        this.collection = collection;
    }

    protected MutableByteCollection getByteCollection() {
        return this.collection;
    }

    public int size() {
        return this.collection.size();
    }

    public boolean isEmpty() {
        return this.collection.isEmpty();
    }

    public boolean notEmpty() {
        return this.collection.notEmpty();
    }

    public void clear() {
        throw new UnsupportedOperationException("Cannot call clear() on " + this.getClass().getSimpleName());
    }

    public boolean contains(byte value) {
        return this.collection.contains(value);
    }

    public boolean containsAll(byte ... source) {
        return this.collection.containsAll(source);
    }

    public boolean containsAll(ByteIterable source) {
        return this.collection.containsAll(source);
    }

    public boolean add(byte newItem) {
        throw new UnsupportedOperationException("Cannot call add() on " + this.getClass().getSimpleName());
    }

    public boolean addAll(byte ... source) {
        throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
    }

    public boolean addAll(ByteIterable source) {
        throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
    }

    public boolean remove(byte value) {
        throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
    }

    public boolean removeAll(ByteIterable source) {
        throw new UnsupportedOperationException("Cannot call removeAll() on " + this.getClass().getSimpleName());
    }

    public boolean removeAll(byte ... source) {
        throw new UnsupportedOperationException("Cannot call removeAll() on " + this.getClass().getSimpleName());
    }

    public boolean retainAll(ByteIterable source) {
        throw new UnsupportedOperationException("Cannot call retainAll() on " + this.getClass().getSimpleName());
    }

    public boolean retainAll(byte ... source) {
        throw new UnsupportedOperationException("Cannot call retainAll() on " + this.getClass().getSimpleName());
    }

    public MutableByteIterator byteIterator() {
        return new UnmodifiableByteIterator((ByteIterator)this.collection.byteIterator());
    }

    public void forEach(ByteProcedure procedure) {
        this.each(procedure);
    }

    public void each(ByteProcedure procedure) {
        this.collection.forEach(procedure);
    }

    public int count(BytePredicate predicate) {
        return this.collection.count(predicate);
    }

    public boolean anySatisfy(BytePredicate predicate) {
        return this.collection.anySatisfy(predicate);
    }

    public boolean allSatisfy(BytePredicate predicate) {
        return this.collection.allSatisfy(predicate);
    }

    public boolean noneSatisfy(BytePredicate predicate) {
        return this.collection.noneSatisfy(predicate);
    }

    public MutableByteCollection select(BytePredicate predicate) {
        return this.collection.select(predicate);
    }

    public MutableByteCollection reject(BytePredicate predicate) {
        return this.collection.reject(predicate);
    }

    public <V> MutableCollection<V> collect(ByteToObjectFunction<? extends V> function) {
        return this.collection.collect(function);
    }

    public MutableByteCollection with(byte element) {
        throw new UnsupportedOperationException("Cannot call with() on " + this.getClass().getSimpleName());
    }

    public MutableByteCollection without(byte element) {
        throw new UnsupportedOperationException("Cannot call without() on " + this.getClass().getSimpleName());
    }

    public MutableByteCollection withAll(ByteIterable elements) {
        throw new UnsupportedOperationException("Cannot call withAll() on " + this.getClass().getSimpleName());
    }

    public MutableByteCollection withoutAll(ByteIterable elements) {
        throw new UnsupportedOperationException("Cannot call withoutAll() on " + this.getClass().getSimpleName());
    }

    public MutableByteCollection asUnmodifiable() {
        return this;
    }

    public MutableByteCollection asSynchronized() {
        return new SynchronizedByteCollection(this);
    }

    public ImmutableByteCollection toImmutable() {
        return this.collection.toImmutable();
    }

    public LazyByteIterable asLazy() {
        return new LazyByteIterableAdapter((ByteIterable)this);
    }

    public byte detectIfNone(BytePredicate predicate, byte ifNone) {
        return this.collection.detectIfNone(predicate, ifNone);
    }

    public long sum() {
        return this.collection.sum();
    }

    public byte max() {
        return this.collection.max();
    }

    public byte min() {
        return this.collection.min();
    }

    public byte minIfEmpty(byte defaultValue) {
        return this.collection.minIfEmpty(defaultValue);
    }

    public byte maxIfEmpty(byte defaultValue) {
        return this.collection.maxIfEmpty(defaultValue);
    }

    public double average() {
        return this.collection.average();
    }

    public double median() {
        return this.collection.median();
    }

    public MutableByteList toSortedList() {
        return this.collection.toSortedList();
    }

    public byte[] toSortedArray() {
        return this.collection.toSortedArray();
    }

    public byte[] toArray() {
        return this.collection.toArray();
    }

    public String toString() {
        return this.collection.toString();
    }

    public String makeString() {
        return this.collection.makeString();
    }

    public String makeString(String separator) {
        return this.collection.makeString(separator);
    }

    public String makeString(String start, String separator, String end) {
        return this.collection.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable) {
        this.collection.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator) {
        this.collection.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.collection.appendString(appendable, start, separator, end);
    }

    public MutableByteList toList() {
        return this.collection.toList();
    }

    public MutableByteSet toSet() {
        return this.collection.toSet();
    }

    public MutableByteBag toBag() {
        return this.collection.toBag();
    }

    public <T> T injectInto(T injectedValue, ObjectByteToObjectFunction<? super T, ? extends T> function) {
        return (T)this.collection.injectInto(injectedValue, function);
    }
}

