/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.list.immutable.primitive;

import java.util.stream.LongStream;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.factory.list.primitive.ImmutableLongListFactory;
import org.eclipse.collections.api.list.primitive.ImmutableLongList;
import org.eclipse.collections.impl.list.immutable.primitive.ImmutableLongArrayList;
import org.eclipse.collections.impl.list.immutable.primitive.ImmutableLongEmptyList;
import org.eclipse.collections.impl.list.immutable.primitive.ImmutableLongSingletonList;

public class ImmutableLongListFactoryImpl
implements ImmutableLongListFactory {
    public ImmutableLongList empty() {
        return ImmutableLongEmptyList.INSTANCE;
    }

    public ImmutableLongList of() {
        return this.empty();
    }

    public ImmutableLongList with() {
        return this.empty();
    }

    public ImmutableLongList of(long one) {
        return this.with(one);
    }

    public ImmutableLongList with(long one) {
        return new ImmutableLongSingletonList(one);
    }

    public ImmutableLongList of(long ... items) {
        return this.with(items);
    }

    public ImmutableLongList with(long ... items) {
        if (items == null || items.length == 0) {
            return this.with();
        }
        if (items.length == 1) {
            return this.with(items[0]);
        }
        return ImmutableLongArrayList.newListWith(items);
    }

    public ImmutableLongList ofAll(LongIterable items) {
        return this.withAll(items);
    }

    public ImmutableLongList withAll(LongIterable items) {
        if (items instanceof ImmutableLongList) {
            return (ImmutableLongList)items;
        }
        return this.with(items.toArray());
    }

    public ImmutableLongList ofAll(LongStream items) {
        return this.withAll(items);
    }

    public ImmutableLongList withAll(LongStream items) {
        return this.with(items.toArray());
    }
}

