/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.collections.api.ByteIterable;
import org.eclipse.collections.api.LazyByteIterable;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.primitive.MutableByteBag;
import org.eclipse.collections.api.block.function.primitive.ByteToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectByteToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.BytePredicate;
import org.eclipse.collections.api.block.predicate.primitive.ObjectBytePredicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.primitive.ByteProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ObjectByteProcedure;
import org.eclipse.collections.api.collection.ImmutableCollection;
import org.eclipse.collections.api.collection.MutableCollection;
import org.eclipse.collections.api.collection.primitive.ImmutableByteCollection;
import org.eclipse.collections.api.collection.primitive.MutableByteCollection;
import org.eclipse.collections.api.iterator.ByteIterator;
import org.eclipse.collections.api.list.primitive.MutableByteList;
import org.eclipse.collections.api.map.primitive.ImmutableByteObjectMap;
import org.eclipse.collections.api.map.primitive.ImmutableObjectByteMap;
import org.eclipse.collections.api.map.primitive.MutableByteObjectMap;
import org.eclipse.collections.api.map.primitive.MutableObjectByteMap;
import org.eclipse.collections.api.map.primitive.ObjectByteMap;
import org.eclipse.collections.api.set.primitive.MutableByteSet;
import org.eclipse.collections.api.tuple.primitive.ObjectBytePair;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableByteCollection;
import org.eclipse.collections.impl.factory.primitive.ByteObjectMaps;
import org.eclipse.collections.impl.iterator.UnmodifiableByteIterator;
import org.eclipse.collections.impl.map.immutable.primitive.AbstractImmutableObjectByteMap;
import org.eclipse.collections.impl.map.mutable.primitive.ObjectByteHashMap;
import org.eclipse.collections.impl.set.mutable.UnmodifiableMutableSet;

final class ImmutableObjectByteHashMap<K>
extends AbstractImmutableObjectByteMap<K>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableObjectByteMap<K> delegate;

    ImmutableObjectByteHashMap(ObjectByteMap<? extends K> delegate) {
        this.delegate = new ObjectByteHashMap<K>(delegate);
    }

    public ByteIterator byteIterator() {
        return new UnmodifiableByteIterator((ByteIterator)this.delegate.byteIterator());
    }

    public void forEach(ByteProcedure procedure) {
        this.each(procedure);
    }

    public void each(ByteProcedure procedure) {
        this.delegate.forEach(procedure);
    }

    public int count(BytePredicate predicate) {
        return this.delegate.count(predicate);
    }

    public boolean anySatisfy(BytePredicate predicate) {
        return this.delegate.anySatisfy(predicate);
    }

    public boolean allSatisfy(BytePredicate predicate) {
        return this.delegate.allSatisfy(predicate);
    }

    public boolean noneSatisfy(BytePredicate predicate) {
        return this.delegate.noneSatisfy(predicate);
    }

    public ImmutableByteCollection select(BytePredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableByteCollection reject(BytePredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    public byte detectIfNone(BytePredicate predicate, byte ifNone) {
        return this.delegate.detectIfNone(predicate, ifNone);
    }

    public <T> T injectInto(T injectedValue, ObjectByteToObjectFunction<? super T, ? extends T> function) {
        return (T)this.delegate.injectInto(injectedValue, function);
    }

    public <V> ImmutableCollection<V> collect(ByteToObjectFunction<? extends V> function) {
        MutableCollection collection = this.delegate.collect(function);
        return collection.toImmutable();
    }

    public long sum() {
        return this.delegate.sum();
    }

    public byte max() {
        return this.delegate.max();
    }

    public byte maxIfEmpty(byte defaultValue) {
        return this.delegate.maxIfEmpty(defaultValue);
    }

    public byte min() {
        return this.delegate.min();
    }

    public byte minIfEmpty(byte defaultValue) {
        return this.delegate.minIfEmpty(defaultValue);
    }

    public double average() {
        return this.delegate.average();
    }

    public double median() {
        return this.delegate.median();
    }

    public byte[] toSortedArray() {
        return this.delegate.toSortedArray();
    }

    public MutableByteList toSortedList() {
        return this.delegate.toSortedList();
    }

    public byte[] toArray() {
        return this.delegate.toArray();
    }

    public boolean contains(byte value) {
        return this.delegate.contains(value);
    }

    public boolean containsAll(byte ... source) {
        return this.delegate.containsAll(source);
    }

    public boolean containsAll(ByteIterable source) {
        return this.delegate.containsAll(source);
    }

    public MutableByteList toList() {
        return this.delegate.toList();
    }

    public MutableByteSet toSet() {
        return this.delegate.toSet();
    }

    public MutableByteBag toBag() {
        return this.delegate.toBag();
    }

    public LazyByteIterable asLazy() {
        return this.delegate.asLazy();
    }

    public ImmutableObjectByteMap<K> newWithKeyValue(K key, byte value) {
        ObjectByteHashMap<K> map = ObjectByteHashMap.newMap();
        map.putAll((ObjectByteMap<K>)this);
        map.put(key, value);
        return map.toImmutable();
    }

    public ImmutableObjectByteMap<K> newWithoutKey(K key) {
        ObjectByteHashMap<K> map = ObjectByteHashMap.newMap();
        map.putAll((ObjectByteMap<K>)this);
        map.removeKey(key);
        return map.toImmutable();
    }

    public ImmutableObjectByteMap<K> newWithoutAllKeys(Iterable<? extends K> keys) {
        ObjectByteHashMap<K> map = ObjectByteHashMap.newMap();
        map.putAll((ObjectByteMap<K>)this);
        Iterator<K> iterator = keys.iterator();
        while (iterator.hasNext()) {
            map.removeKey(iterator.next());
        }
        return map.toImmutable();
    }

    public byte get(Object key) {
        return this.delegate.get(key);
    }

    public byte getOrThrow(Object key) {
        return this.delegate.getOrThrow(key);
    }

    public byte getIfAbsent(Object key, byte ifAbsent) {
        return this.delegate.getIfAbsent(key, ifAbsent);
    }

    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    public boolean containsValue(byte value) {
        return this.delegate.containsValue(value);
    }

    public void forEachValue(ByteProcedure procedure) {
        this.delegate.forEachValue(procedure);
    }

    public void forEachKey(Procedure<? super K> procedure) {
        this.delegate.forEachKey(procedure);
    }

    public void forEachKeyValue(ObjectByteProcedure<? super K> objectByteProcedure) {
        this.delegate.forEachKeyValue(objectByteProcedure);
    }

    public ImmutableObjectByteMap<K> select(ObjectBytePredicate<? super K> objectBytePredicate) {
        return this.delegate.select(objectBytePredicate).toImmutable();
    }

    public ImmutableObjectByteMap<K> reject(ObjectBytePredicate<? super K> objectBytePredicate) {
        return this.delegate.reject(objectBytePredicate).toImmutable();
    }

    public ImmutableObjectByteMap<K> toImmutable() {
        return this;
    }

    public int size() {
        return this.delegate.size();
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public boolean notEmpty() {
        return this.delegate.notEmpty();
    }

    public Set<K> keySet() {
        return UnmodifiableMutableSet.of(this.delegate.keySet());
    }

    public MutableByteCollection values() {
        return UnmodifiableByteCollection.of(this.delegate.values());
    }

    public LazyIterable<K> keysView() {
        return this.delegate.keysView();
    }

    public RichIterable<ObjectBytePair<K>> keyValuesView() {
        return this.delegate.keyValuesView();
    }

    public ImmutableByteObjectMap<K> flipUniqueValues() {
        MutableByteObjectMap result = ByteObjectMaps.mutable.empty();
        this.forEachKeyValue((ObjectByteProcedure & Serializable)(key, value) -> {
            Object oldKey = result.put(value, key);
            if (oldKey != null) {
                throw new IllegalStateException("Duplicate value: " + value + " found at key: " + oldKey + " and key: " + key);
            }
        });
        return result.toImmutable();
    }

    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public String toString() {
        return this.delegate.toString();
    }

    public String makeString() {
        return this.delegate.makeString();
    }

    public String makeString(String separator) {
        return this.delegate.makeString(separator);
    }

    public String makeString(String start, String separator, String end) {
        return this.delegate.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable) {
        this.delegate.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator) {
        this.delegate.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.delegate.appendString(appendable, start, separator, end);
    }

    private Object writeReplace() {
        return new AbstractImmutableObjectByteMap.ImmutableObjectByteMapSerializationProxy(this);
    }
}

