/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.mutable.primitive;

import java.io.Serializable;
import org.eclipse.collections.api.ByteIterable;
import org.eclipse.collections.api.LazyByteIterable;
import org.eclipse.collections.api.LazyLongIterable;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.bag.primitive.MutableLongBag;
import org.eclipse.collections.api.block.function.primitive.ByteToLongFunction;
import org.eclipse.collections.api.block.function.primitive.LongFunction;
import org.eclipse.collections.api.block.function.primitive.LongFunction0;
import org.eclipse.collections.api.block.function.primitive.LongToLongFunction;
import org.eclipse.collections.api.block.function.primitive.LongToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectLongToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.ByteLongPredicate;
import org.eclipse.collections.api.block.predicate.primitive.LongPredicate;
import org.eclipse.collections.api.block.procedure.primitive.ByteLongProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ByteProcedure;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.collection.primitive.MutableLongCollection;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.iterator.MutableLongIterator;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.api.map.primitive.ByteLongMap;
import org.eclipse.collections.api.map.primitive.ImmutableByteLongMap;
import org.eclipse.collections.api.map.primitive.MutableByteLongMap;
import org.eclipse.collections.api.map.primitive.MutableLongByteMap;
import org.eclipse.collections.api.set.primitive.MutableByteSet;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.api.tuple.primitive.ByteLongPair;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableLongCollection;
import org.eclipse.collections.impl.factory.primitive.ByteLongMaps;
import org.eclipse.collections.impl.iterator.UnmodifiableLongIterator;
import org.eclipse.collections.impl.map.mutable.primitive.SynchronizedByteLongMap;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableByteSet;

public final class UnmodifiableByteLongMap
implements MutableByteLongMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableByteLongMap map;

    public UnmodifiableByteLongMap(MutableByteLongMap map) {
        if (map == null) {
            throw new IllegalArgumentException("Cannot create a UnmodifiableByteLongMap on a null map");
        }
        this.map = map;
    }

    public void clear() {
        throw new UnsupportedOperationException("Cannot call clear() on " + this.getClass().getSimpleName());
    }

    public void put(byte key, long value) {
        throw new UnsupportedOperationException("Cannot call put() on " + this.getClass().getSimpleName());
    }

    public void putAll(ByteLongMap map) {
        throw new UnsupportedOperationException("Cannot call putAll() on " + this.getClass().getSimpleName());
    }

    public void removeKey(byte key) {
        throw new UnsupportedOperationException("Cannot call removeKey() on " + this.getClass().getSimpleName());
    }

    public void remove(byte key) {
        throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
    }

    public long removeKeyIfAbsent(byte key, long value) {
        if (this.map.containsKey(key)) {
            throw new UnsupportedOperationException("Cannot call removeKey() on " + this.getClass().getSimpleName());
        }
        return value;
    }

    public long getIfAbsentPut(byte key, long value) {
        return this.map.getIfAbsentPut(key, (LongFunction0 & Serializable)() -> {
            throw new UnsupportedOperationException();
        });
    }

    public long getIfAbsentPut(byte key, LongFunction0 function) {
        return this.map.getIfAbsentPut(key, (LongFunction0 & Serializable)() -> {
            throw new UnsupportedOperationException();
        });
    }

    public long getIfAbsentPutWithKey(byte key, ByteToLongFunction function) {
        return this.map.getIfAbsentPut(key, (LongFunction0 & Serializable)() -> {
            throw new UnsupportedOperationException();
        });
    }

    public <P> long getIfAbsentPutWith(byte key, LongFunction<? super P> function, P parameter) {
        return this.map.getIfAbsentPut(key, (LongFunction0 & Serializable)() -> {
            throw new UnsupportedOperationException();
        });
    }

    public long updateValue(byte key, long initialValueIfAbsent, LongToLongFunction function) {
        throw new UnsupportedOperationException("Cannot call updateValue() on " + this.getClass().getSimpleName());
    }

    public long get(byte key) {
        return this.map.get(key);
    }

    public long getIfAbsent(byte key, long ifAbsent) {
        return this.map.getIfAbsent(key, ifAbsent);
    }

    public long getOrThrow(byte key) {
        return this.map.getOrThrow(key);
    }

    public boolean containsKey(byte key) {
        return this.map.containsKey(key);
    }

    public boolean containsValue(long value) {
        return this.map.containsValue(value);
    }

    public void forEachValue(LongProcedure procedure) {
        this.map.forEachValue(procedure);
    }

    public void forEachKey(ByteProcedure procedure) {
        this.map.forEachKey(procedure);
    }

    public void forEachKeyValue(ByteLongProcedure procedure) {
        this.map.forEachKeyValue(procedure);
    }

    public LazyByteIterable keysView() {
        return this.map.keysView();
    }

    public RichIterable<ByteLongPair> keyValuesView() {
        return this.map.keyValuesView();
    }

    public MutableLongByteMap flipUniqueValues() {
        return this.map.flipUniqueValues().asUnmodifiable();
    }

    public MutableByteLongMap select(ByteLongPredicate predicate) {
        return this.map.select(predicate);
    }

    public MutableByteLongMap reject(ByteLongPredicate predicate) {
        return this.map.reject(predicate);
    }

    public MutableLongIterator longIterator() {
        return new UnmodifiableLongIterator((LongIterator)this.map.longIterator());
    }

    public void forEach(LongProcedure procedure) {
        this.each(procedure);
    }

    public void each(LongProcedure procedure) {
        this.map.forEach(procedure);
    }

    public int count(LongPredicate predicate) {
        return this.map.count(predicate);
    }

    public boolean anySatisfy(LongPredicate predicate) {
        return this.map.anySatisfy(predicate);
    }

    public boolean allSatisfy(LongPredicate predicate) {
        return this.map.allSatisfy(predicate);
    }

    public boolean noneSatisfy(LongPredicate predicate) {
        return this.map.noneSatisfy(predicate);
    }

    public MutableLongBag select(LongPredicate predicate) {
        return this.map.select(predicate);
    }

    public MutableLongBag reject(LongPredicate predicate) {
        return this.map.reject(predicate);
    }

    public <V> MutableBag<V> collect(LongToObjectFunction<? extends V> function) {
        return this.map.collect(function);
    }

    public long detectIfNone(LongPredicate predicate, long ifNone) {
        return this.map.detectIfNone(predicate, ifNone);
    }

    public long sum() {
        return this.map.sum();
    }

    public long max() {
        return this.map.max();
    }

    public long maxIfEmpty(long defaultValue) {
        return this.map.maxIfEmpty(defaultValue);
    }

    public long min() {
        return this.map.min();
    }

    public long minIfEmpty(long defaultValue) {
        return this.map.minIfEmpty(defaultValue);
    }

    public double average() {
        return this.map.average();
    }

    public double median() {
        return this.map.median();
    }

    public long addToValue(byte key, long toBeAdded) {
        throw new UnsupportedOperationException("Cannot call addToValue() on " + this.getClass().getSimpleName());
    }

    public long[] toSortedArray() {
        return this.map.toSortedArray();
    }

    public MutableLongList toSortedList() {
        return this.map.toSortedList();
    }

    public long[] toArray() {
        return this.map.toArray();
    }

    public boolean contains(long value) {
        return this.map.contains(value);
    }

    public boolean containsAll(long ... source) {
        return this.map.containsAll(source);
    }

    public boolean containsAll(LongIterable source) {
        return this.map.containsAll(source);
    }

    public MutableLongList toList() {
        return this.map.toList();
    }

    public MutableLongSet toSet() {
        return this.map.toSet();
    }

    public MutableLongBag toBag() {
        return this.map.toBag();
    }

    public LazyLongIterable asLazy() {
        return this.map.asLazy();
    }

    public MutableByteLongMap withKeyValue(byte key, long value) {
        throw new UnsupportedOperationException("Cannot call withKeyValue() on " + this.getClass().getSimpleName());
    }

    public MutableByteLongMap withoutKey(byte key) {
        throw new UnsupportedOperationException("Cannot call withoutKey() on " + this.getClass().getSimpleName());
    }

    public MutableByteLongMap withoutAllKeys(ByteIterable keys) {
        throw new UnsupportedOperationException("Cannot call withoutAllKeys() on " + this.getClass().getSimpleName());
    }

    public MutableByteLongMap asUnmodifiable() {
        return this;
    }

    public MutableByteLongMap asSynchronized() {
        return new SynchronizedByteLongMap(this);
    }

    public ImmutableByteLongMap toImmutable() {
        return ByteLongMaps.immutable.withAll((ByteLongMap)this);
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean notEmpty() {
        return this.map.notEmpty();
    }

    public MutableByteSet keySet() {
        return UnmodifiableByteSet.of(this.map.keySet());
    }

    public MutableLongCollection values() {
        return UnmodifiableLongCollection.of(this.map.values());
    }

    public boolean equals(Object otherMap) {
        return this.map.equals(otherMap);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public String toString() {
        return this.map.toString();
    }

    public String makeString() {
        return this.map.makeString();
    }

    public String makeString(String separator) {
        return this.map.makeString(separator);
    }

    public String makeString(String start, String separator, String end) {
        return this.map.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable) {
        this.map.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator) {
        this.map.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.map.appendString(appendable, start, separator, end);
    }

    public <T> T injectInto(T injectedValue, ObjectLongToObjectFunction<? super T, ? extends T> function) {
        return (T)this.map.injectInto(injectedValue, function);
    }
}

