/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.lazy.primitive;

import java.io.Serializable;
import java.util.NoSuchElementException;
import org.eclipse.collections.api.ByteIterable;
import org.eclipse.collections.api.LazyBooleanIterable;
import org.eclipse.collections.api.LazyByteIterable;
import org.eclipse.collections.api.LazyCharIterable;
import org.eclipse.collections.api.LazyDoubleIterable;
import org.eclipse.collections.api.LazyFloatIterable;
import org.eclipse.collections.api.LazyIntIterable;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.LazyLongIterable;
import org.eclipse.collections.api.LazyShortIterable;
import org.eclipse.collections.api.bag.primitive.MutableByteBag;
import org.eclipse.collections.api.block.function.primitive.ByteToBooleanFunction;
import org.eclipse.collections.api.block.function.primitive.ByteToByteFunction;
import org.eclipse.collections.api.block.function.primitive.ByteToCharFunction;
import org.eclipse.collections.api.block.function.primitive.ByteToDoubleFunction;
import org.eclipse.collections.api.block.function.primitive.ByteToFloatFunction;
import org.eclipse.collections.api.block.function.primitive.ByteToIntFunction;
import org.eclipse.collections.api.block.function.primitive.ByteToLongFunction;
import org.eclipse.collections.api.block.function.primitive.ByteToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ByteToShortFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectByteToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.BytePredicate;
import org.eclipse.collections.api.block.procedure.primitive.ByteProcedure;
import org.eclipse.collections.api.list.primitive.MutableByteList;
import org.eclipse.collections.api.set.primitive.MutableByteSet;
import org.eclipse.collections.impl.bag.mutable.primitive.ByteHashBag;
import org.eclipse.collections.impl.block.factory.primitive.BytePredicates;
import org.eclipse.collections.impl.factory.primitive.ByteSets;
import org.eclipse.collections.impl.lazy.primitive.CollectByteToBooleanIterable;
import org.eclipse.collections.impl.lazy.primitive.CollectByteToByteIterable;
import org.eclipse.collections.impl.lazy.primitive.CollectByteToCharIterable;
import org.eclipse.collections.impl.lazy.primitive.CollectByteToDoubleIterable;
import org.eclipse.collections.impl.lazy.primitive.CollectByteToFloatIterable;
import org.eclipse.collections.impl.lazy.primitive.CollectByteToIntIterable;
import org.eclipse.collections.impl.lazy.primitive.CollectByteToLongIterable;
import org.eclipse.collections.impl.lazy.primitive.CollectByteToShortIterable;
import org.eclipse.collections.impl.list.mutable.primitive.ByteArrayList;
import org.eclipse.collections.impl.set.mutable.primitive.ByteHashSet;
import org.eclipse.collections.impl.utility.internal.primitive.ByteIterableIterate;
import org.eclipse.collections.impl.utility.primitive.LazyByteIterate;

public abstract class AbstractLazyByteIterable
implements LazyByteIterable {
    public void forEach(ByteProcedure procedure) {
        this.each(procedure);
    }

    public int size() {
        return this.count(BytePredicates.alwaysTrue());
    }

    public String toString() {
        return this.makeString("[", ", ", "]");
    }

    public boolean isEmpty() {
        return ByteIterableIterate.isEmpty((ByteIterable)this);
    }

    public boolean notEmpty() {
        return ByteIterableIterate.notEmpty((ByteIterable)this);
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        ByteIterableIterate.appendString((ByteIterable)this, appendable, start, separator, end);
    }

    public boolean contains(byte value) {
        return this.anySatisfy(BytePredicates.equal(value));
    }

    public boolean containsAll(byte ... source) {
        return this.containsAll((ByteIterable)ByteSets.immutable.of(source));
    }

    public boolean containsAll(ByteIterable source) {
        return source.allSatisfy((BytePredicate & Serializable)value -> this.contains(value));
    }

    public LazyByteIterable select(BytePredicate predicate) {
        return LazyByteIterate.select((ByteIterable)this, predicate);
    }

    public LazyByteIterable reject(BytePredicate predicate) {
        return LazyByteIterate.select((ByteIterable)this, BytePredicates.not(predicate));
    }

    public LazyByteIterable tap(ByteProcedure procedure) {
        return LazyByteIterate.tap((ByteIterable)this, procedure);
    }

    public <V> LazyIterable<V> collect(ByteToObjectFunction<? extends V> function) {
        return LazyByteIterate.collect((ByteIterable)this, function);
    }

    public <V> LazyIterable<V> flatCollect(ByteToObjectFunction<? extends Iterable<V>> function) {
        return LazyByteIterate.flatCollect((ByteIterable)this, function);
    }

    public LazyBooleanIterable collectBoolean(ByteToBooleanFunction function) {
        return new CollectByteToBooleanIterable((ByteIterable)this, function);
    }

    public LazyByteIterable collectByte(ByteToByteFunction function) {
        return new CollectByteToByteIterable((ByteIterable)this, function);
    }

    public LazyCharIterable collectChar(ByteToCharFunction function) {
        return new CollectByteToCharIterable((ByteIterable)this, function);
    }

    public LazyShortIterable collectShort(ByteToShortFunction function) {
        return new CollectByteToShortIterable((ByteIterable)this, function);
    }

    public LazyIntIterable collectInt(ByteToIntFunction function) {
        return new CollectByteToIntIterable((ByteIterable)this, function);
    }

    public LazyFloatIterable collectFloat(ByteToFloatFunction function) {
        return new CollectByteToFloatIterable((ByteIterable)this, function);
    }

    public LazyLongIterable collectLong(ByteToLongFunction function) {
        return new CollectByteToLongIterable((ByteIterable)this, function);
    }

    public LazyDoubleIterable collectDouble(ByteToDoubleFunction function) {
        return new CollectByteToDoubleIterable((ByteIterable)this, function);
    }

    public byte detectIfNone(BytePredicate predicate, byte ifNone) {
        return ByteIterableIterate.detectIfNone((ByteIterable)this, predicate, ifNone);
    }

    public int count(BytePredicate predicate) {
        return ByteIterableIterate.count((ByteIterable)this, predicate);
    }

    public boolean anySatisfy(BytePredicate predicate) {
        return ByteIterableIterate.anySatisfy((ByteIterable)this, predicate);
    }

    public boolean allSatisfy(BytePredicate predicate) {
        return ByteIterableIterate.allSatisfy((ByteIterable)this, predicate);
    }

    public boolean noneSatisfy(BytePredicate predicate) {
        return ByteIterableIterate.noneSatisfy((ByteIterable)this, predicate);
    }

    public <T> T injectInto(T injectedValue, ObjectByteToObjectFunction<? super T, ? extends T> function) {
        return ByteIterableIterate.injectInto((ByteIterable)this, injectedValue, function);
    }

    public byte[] toArray() {
        return this.toList().toArray();
    }

    public MutableByteList toList() {
        ByteArrayList list = new ByteArrayList();
        this.forEach(arg_0 -> ((MutableByteList)list).add(arg_0));
        return list;
    }

    public MutableByteSet toSet() {
        ByteHashSet set = new ByteHashSet();
        this.forEach(arg_0 -> ((MutableByteSet)set).add(arg_0));
        return set;
    }

    public MutableByteBag toBag() {
        ByteHashBag bag = new ByteHashBag();
        this.forEach(arg_0 -> ((MutableByteBag)bag).add(arg_0));
        return bag;
    }

    public long sum() {
        ByteSumProcedure procedure = new ByteSumProcedure();
        this.forEach(procedure);
        return procedure.getValue();
    }

    public byte max() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        ByteMaxProcedure procedure = new ByteMaxProcedure();
        this.forEach(procedure);
        return procedure.getValue();
    }

    public byte maxIfEmpty(byte ifEmpty) {
        if (this.isEmpty()) {
            return ifEmpty;
        }
        return this.max();
    }

    public byte min() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        ByteMinProcedure procedure = new ByteMinProcedure();
        this.forEach(procedure);
        return procedure.getValue();
    }

    public byte minIfEmpty(byte ifEmpty) {
        if (this.isEmpty()) {
            return ifEmpty;
        }
        return this.min();
    }

    public double average() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        return (double)this.sum() / (double)this.size();
    }

    public double median() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        byte[] sortedArray = this.toSortedArray();
        int middleIndex = sortedArray.length >> 1;
        if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
            byte first = sortedArray[middleIndex];
            byte second = sortedArray[middleIndex - 1];
            return ((double)first + (double)second) / 2.0;
        }
        return sortedArray[middleIndex];
    }

    public byte[] toSortedArray() {
        return this.toSortedList().toArray();
    }

    public MutableByteList toSortedList() {
        return ByteArrayList.newList((ByteIterable)this).sortThis();
    }

    public LazyByteIterable asLazy() {
        return this;
    }

    private static final class ByteSumProcedure
    implements ByteProcedure {
        private byte sum = 0;

        private ByteSumProcedure() {
        }

        public void value(byte each) {
            this.sum = (byte)(this.sum + each);
        }

        public byte getValue() {
            return this.sum;
        }
    }

    private static final class ByteMinProcedure
    implements ByteProcedure {
        private boolean visitedOnce;
        private byte min;

        private ByteMinProcedure() {
        }

        public void value(byte each) {
            if (this.visitedOnce) {
                if (each < this.min) {
                    this.min = each;
                }
            } else {
                this.min = each;
                this.visitedOnce = true;
            }
        }

        public byte getValue() {
            return this.min;
        }
    }

    private static final class ByteMaxProcedure
    implements ByteProcedure {
        private boolean visitedOnce;
        private byte max;

        private ByteMaxProcedure() {
        }

        public void value(byte each) {
            if (this.visitedOnce) {
                if (this.max < each) {
                    this.max = each;
                }
            } else {
                this.max = each;
                this.visitedOnce = true;
            }
        }

        public byte getValue() {
            return this.max;
        }
    }
}

