/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.mutable.primitive;

import java.io.Serializable;
import java.util.Collections;
import java.util.Set;
import org.eclipse.collections.api.CharIterable;
import org.eclipse.collections.api.LazyCharIterable;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.primitive.MutableCharBag;
import org.eclipse.collections.api.block.function.primitive.CharFunction;
import org.eclipse.collections.api.block.function.primitive.CharFunction0;
import org.eclipse.collections.api.block.function.primitive.CharToCharFunction;
import org.eclipse.collections.api.block.function.primitive.CharToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectCharToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.CharPredicate;
import org.eclipse.collections.api.block.predicate.primitive.ObjectCharPredicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.primitive.CharProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ObjectCharProcedure;
import org.eclipse.collections.api.collection.MutableCollection;
import org.eclipse.collections.api.collection.primitive.MutableCharCollection;
import org.eclipse.collections.api.iterator.CharIterator;
import org.eclipse.collections.api.iterator.MutableCharIterator;
import org.eclipse.collections.api.list.primitive.MutableCharList;
import org.eclipse.collections.api.map.primitive.ImmutableObjectCharMap;
import org.eclipse.collections.api.map.primitive.MutableCharObjectMap;
import org.eclipse.collections.api.map.primitive.MutableObjectCharMap;
import org.eclipse.collections.api.map.primitive.ObjectCharMap;
import org.eclipse.collections.api.set.primitive.MutableCharSet;
import org.eclipse.collections.api.tuple.primitive.ObjectCharPair;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableCharCollection;
import org.eclipse.collections.impl.factory.primitive.ObjectCharMaps;
import org.eclipse.collections.impl.iterator.UnmodifiableCharIterator;
import org.eclipse.collections.impl.map.mutable.primitive.SynchronizedObjectCharMap;

public final class UnmodifiableObjectCharMap<K>
implements MutableObjectCharMap<K>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableObjectCharMap<K> map;

    public UnmodifiableObjectCharMap(MutableObjectCharMap<K> map) {
        if (map == null) {
            throw new IllegalArgumentException("Cannot create a UnmodifiableObjectCharMap on a null map");
        }
        this.map = map;
    }

    private boolean isAbsent(char result, K key) {
        return result == '\u0000' && !this.containsKey(key);
    }

    private char getIfAbsentThrow(K key) {
        char result = this.map.get(key);
        if (this.isAbsent(result, key)) {
            throw new UnsupportedOperationException("Cannot add to an " + this.getClass().getSimpleName());
        }
        return result;
    }

    public void clear() {
        throw new UnsupportedOperationException("Cannot call clear() on " + this.getClass().getSimpleName());
    }

    public void put(K key, char value) {
        throw new UnsupportedOperationException("Cannot call put() on " + this.getClass().getSimpleName());
    }

    public void putPair(ObjectCharPair<K> keyValuePair) {
        throw new UnsupportedOperationException("Cannot call putPair() on " + this.getClass().getSimpleName());
    }

    public void putAll(ObjectCharMap<? extends K> map) {
        throw new UnsupportedOperationException("Cannot call putAll() on " + this.getClass().getSimpleName());
    }

    public void removeKey(K key) {
        throw new UnsupportedOperationException("Cannot call removeKey() on " + this.getClass().getSimpleName());
    }

    public void remove(Object key) {
        throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
    }

    public char removeKeyIfAbsent(K key, char value) {
        throw new UnsupportedOperationException("Cannot call removeKeyIfAbsent() on " + this.getClass().getSimpleName());
    }

    public char getIfAbsentPut(K key, char value) {
        return this.getIfAbsentThrow(key);
    }

    public char getIfAbsentPut(K key, CharFunction0 function) {
        return this.getIfAbsentThrow(key);
    }

    public char getIfAbsentPutWithKey(K key, CharFunction<? super K> function) {
        return this.getIfAbsentThrow(key);
    }

    public <P> char getIfAbsentPutWith(K key, CharFunction<? super P> function, P parameter) {
        return this.getIfAbsentThrow(key);
    }

    public char updateValue(K key, char initialValueIfAbsent, CharToCharFunction function) {
        throw new UnsupportedOperationException("Cannot call updateValue() on " + this.getClass().getSimpleName());
    }

    public char addToValue(K key, char toBeAdded) {
        throw new UnsupportedOperationException("Cannot call addToValue() on " + this.getClass().getSimpleName());
    }

    public char get(Object key) {
        return this.map.get(key);
    }

    public char getOrThrow(Object key) {
        return this.map.getOrThrow(key);
    }

    public char getIfAbsent(Object key, char ifAbsent) {
        return this.map.getIfAbsent(key, ifAbsent);
    }

    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    public boolean containsValue(char value) {
        return this.map.containsValue(value);
    }

    public void forEachValue(CharProcedure procedure) {
        this.map.forEachValue(procedure);
    }

    public void forEachKey(Procedure<? super K> procedure) {
        this.map.forEachKey(procedure);
    }

    public void forEachKeyValue(ObjectCharProcedure<? super K> procedure) {
        this.map.forEachKeyValue(procedure);
    }

    public MutableObjectCharMap<K> select(ObjectCharPredicate<? super K> predicate) {
        return this.map.select(predicate);
    }

    public MutableObjectCharMap<K> reject(ObjectCharPredicate<? super K> predicate) {
        return this.map.reject(predicate);
    }

    public MutableCharIterator charIterator() {
        return new UnmodifiableCharIterator((CharIterator)this.map.charIterator());
    }

    public void forEach(CharProcedure procedure) {
        this.each(procedure);
    }

    public void each(CharProcedure procedure) {
        this.map.forEach(procedure);
    }

    public int count(CharPredicate predicate) {
        return this.map.count(predicate);
    }

    public boolean anySatisfy(CharPredicate predicate) {
        return this.map.anySatisfy(predicate);
    }

    public boolean allSatisfy(CharPredicate predicate) {
        return this.map.allSatisfy(predicate);
    }

    public boolean noneSatisfy(CharPredicate predicate) {
        return this.map.noneSatisfy(predicate);
    }

    public MutableCharCollection select(CharPredicate predicate) {
        return this.map.select(predicate);
    }

    public MutableCharCollection reject(CharPredicate predicate) {
        return this.map.reject(predicate);
    }

    public char detectIfNone(CharPredicate predicate, char ifNone) {
        return this.map.detectIfNone(predicate, ifNone);
    }

    public <V1> MutableCollection<V1> collect(CharToObjectFunction<? extends V1> function) {
        return this.map.collect(function);
    }

    public long sum() {
        return this.map.sum();
    }

    public char max() {
        return this.map.max();
    }

    public char maxIfEmpty(char defaultValue) {
        return this.map.maxIfEmpty(defaultValue);
    }

    public char min() {
        return this.map.min();
    }

    public char minIfEmpty(char defaultValue) {
        return this.map.minIfEmpty(defaultValue);
    }

    public double average() {
        return this.map.average();
    }

    public double median() {
        return this.map.median();
    }

    public char[] toSortedArray() {
        return this.map.toSortedArray();
    }

    public MutableCharList toSortedList() {
        return this.map.toSortedList();
    }

    public char[] toArray() {
        return this.map.toArray();
    }

    public boolean contains(char value) {
        return this.map.contains(value);
    }

    public boolean containsAll(char ... source) {
        return this.map.containsAll(source);
    }

    public boolean containsAll(CharIterable source) {
        return this.map.containsAll(source);
    }

    public MutableCharList toList() {
        return this.map.toList();
    }

    public MutableCharSet toSet() {
        return this.map.toSet();
    }

    public MutableCharBag toBag() {
        return this.map.toBag();
    }

    public LazyCharIterable asLazy() {
        return this.map.asLazy();
    }

    public MutableObjectCharMap<K> withKeyValue(K key, char value) {
        throw new UnsupportedOperationException("Cannot call withKeyValue() on " + this.getClass().getSimpleName());
    }

    public MutableObjectCharMap<K> withoutKey(K key) {
        throw new UnsupportedOperationException("Cannot call withoutKey() on " + this.getClass().getSimpleName());
    }

    public MutableObjectCharMap<K> withoutAllKeys(Iterable<? extends K> keys) {
        throw new UnsupportedOperationException("Cannot call withoutAllKeys() on " + this.getClass().getSimpleName());
    }

    public MutableObjectCharMap<K> asUnmodifiable() {
        return this;
    }

    public MutableObjectCharMap<K> asSynchronized() {
        return new SynchronizedObjectCharMap(this);
    }

    public ImmutableObjectCharMap<K> toImmutable() {
        return ObjectCharMaps.immutable.withAll((ObjectCharMap)this);
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean notEmpty() {
        return this.map.notEmpty();
    }

    public Set<K> keySet() {
        return Collections.unmodifiableSet(this.map.keySet());
    }

    public MutableCharCollection values() {
        return UnmodifiableCharCollection.of(this.map.values());
    }

    public LazyIterable<K> keysView() {
        return this.map.keysView();
    }

    public RichIterable<ObjectCharPair<K>> keyValuesView() {
        return this.map.keyValuesView();
    }

    public MutableCharObjectMap<K> flipUniqueValues() {
        return this.map.flipUniqueValues().asUnmodifiable();
    }

    public boolean equals(Object obj) {
        return this.map.equals(obj);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public String toString() {
        return this.map.toString();
    }

    public String makeString() {
        return this.map.makeString();
    }

    public String makeString(String separator) {
        return this.map.makeString(separator);
    }

    public String makeString(String start, String separator, String end) {
        return this.map.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable) {
        this.map.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator) {
        this.map.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.map.appendString(appendable, start, separator, end);
    }

    public <T> T injectInto(T injectedValue, ObjectCharToObjectFunction<? super T, ? extends T> function) {
        return (T)this.map.injectInto(injectedValue, function);
    }
}

