/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.stack.mutable;

import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Optional;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.bag.sorted.MutableSortedBag;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function0;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.function.primitive.BooleanFunction;
import org.eclipse.collections.api.block.function.primitive.ByteFunction;
import org.eclipse.collections.api.block.function.primitive.CharFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleObjectToDoubleFunction;
import org.eclipse.collections.api.block.function.primitive.FloatFunction;
import org.eclipse.collections.api.block.function.primitive.FloatObjectToFloatFunction;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.block.function.primitive.IntObjectToIntFunction;
import org.eclipse.collections.api.block.function.primitive.LongFunction;
import org.eclipse.collections.api.block.function.primitive.LongObjectToLongFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ShortFunction;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.collection.primitive.MutableBooleanCollection;
import org.eclipse.collections.api.collection.primitive.MutableByteCollection;
import org.eclipse.collections.api.collection.primitive.MutableCharCollection;
import org.eclipse.collections.api.collection.primitive.MutableDoubleCollection;
import org.eclipse.collections.api.collection.primitive.MutableFloatCollection;
import org.eclipse.collections.api.collection.primitive.MutableIntCollection;
import org.eclipse.collections.api.collection.primitive.MutableLongCollection;
import org.eclipse.collections.api.collection.primitive.MutableShortCollection;
import org.eclipse.collections.api.list.ListIterable;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.api.map.primitive.MutableObjectDoubleMap;
import org.eclipse.collections.api.map.primitive.MutableObjectLongMap;
import org.eclipse.collections.api.map.sorted.MutableSortedMap;
import org.eclipse.collections.api.multimap.MutableMultimap;
import org.eclipse.collections.api.multimap.list.MutableListMultimap;
import org.eclipse.collections.api.ordered.OrderedIterable;
import org.eclipse.collections.api.partition.stack.PartitionMutableStack;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.api.set.sorted.MutableSortedSet;
import org.eclipse.collections.api.stack.ImmutableStack;
import org.eclipse.collections.api.stack.MutableStack;
import org.eclipse.collections.api.stack.primitive.MutableBooleanStack;
import org.eclipse.collections.api.stack.primitive.MutableByteStack;
import org.eclipse.collections.api.stack.primitive.MutableCharStack;
import org.eclipse.collections.api.stack.primitive.MutableDoubleStack;
import org.eclipse.collections.api.stack.primitive.MutableFloatStack;
import org.eclipse.collections.api.stack.primitive.MutableIntStack;
import org.eclipse.collections.api.stack.primitive.MutableLongStack;
import org.eclipse.collections.api.stack.primitive.MutableShortStack;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.impl.UnmodifiableIteratorAdapter;

public final class SynchronizedStack<T>
implements MutableStack<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Object lock;
    private final MutableStack<T> delegate;

    public SynchronizedStack(MutableStack<T> newStack) {
        this(newStack, null);
    }

    public SynchronizedStack(MutableStack<T> newStack, Object newLock) {
        if (newStack == null) {
            throw new IllegalArgumentException("Cannot create a SynchronizedStack on a null stack");
        }
        this.delegate = newStack;
        this.lock = newLock == null ? this : newLock;
    }

    public static <T, S extends MutableStack<T>> SynchronizedStack<T> of(S stack) {
        return new SynchronizedStack<T>(stack);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T pop() {
        Object object = this.lock;
        synchronized (object) {
            return (T)this.delegate.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListIterable<T> pop(int count) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.pop(count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R extends Collection<T>> R pop(int count, R targetCollection) {
        Object object = this.lock;
        synchronized (object) {
            return (R)this.delegate.pop(count, targetCollection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R extends MutableStack<T>> R pop(int count, R targetStack) {
        Object object = this.lock;
        synchronized (object) {
            return (R)this.delegate.pop(count, targetStack);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            this.delegate.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void push(T item) {
        Object object = this.lock;
        synchronized (object) {
            this.delegate.push(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T peek() {
        Object object = this.lock;
        synchronized (object) {
            return (T)this.delegate.peek();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListIterable<T> peek(int count) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.peek(count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T peekAt(int index) {
        Object object = this.lock;
        synchronized (object) {
            return (T)this.delegate.peekAt(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableStack<T> select(Predicate<? super T> predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.select(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P> MutableStack<T> selectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.selectWith(predicate, parameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R extends Collection<T>> R select(Predicate<? super T> predicate, R target) {
        Object object = this.lock;
        synchronized (object) {
            return (R)this.delegate.select(predicate, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P, R extends Collection<T>> R selectWith(Predicate2<? super T, ? super P> predicate, P parameter, R targetCollection) {
        Object object = this.lock;
        synchronized (object) {
            return (R)this.delegate.selectWith(predicate, parameter, targetCollection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableStack<T> reject(Predicate<? super T> predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.reject(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P> MutableStack<T> rejectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.rejectWith(predicate, parameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R extends Collection<T>> R reject(Predicate<? super T> predicate, R target) {
        Object object = this.lock;
        synchronized (object) {
            return (R)this.delegate.reject(predicate, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P, R extends Collection<T>> R rejectWith(Predicate2<? super T, ? super P> predicate, P parameter, R targetCollection) {
        Object object = this.lock;
        synchronized (object) {
            return (R)this.delegate.rejectWith(predicate, parameter, targetCollection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PartitionMutableStack<T> partition(Predicate<? super T> predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.partition(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P> PartitionMutableStack<T> partitionWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.partitionWith(predicate, parameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <S> MutableStack<S> selectInstancesOf(Class<S> clazz) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.selectInstancesOf(clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> MutableStack<V> collect(Function<? super T, ? extends V> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.collect(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableBooleanStack collectBoolean(BooleanFunction<? super T> booleanFunction) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.collectBoolean(booleanFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R extends MutableBooleanCollection> R collectBoolean(BooleanFunction<? super T> booleanFunction, R target) {
        Object object = this.lock;
        synchronized (object) {
            return (R)this.delegate.collectBoolean(booleanFunction, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableByteStack collectByte(ByteFunction<? super T> byteFunction) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.collectByte(byteFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R extends MutableByteCollection> R collectByte(ByteFunction<? super T> byteFunction, R target) {
        Object object = this.lock;
        synchronized (object) {
            return (R)this.delegate.collectByte(byteFunction, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableCharStack collectChar(CharFunction<? super T> charFunction) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.collectChar(charFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R extends MutableCharCollection> R collectChar(CharFunction<? super T> charFunction, R target) {
        Object object = this.lock;
        synchronized (object) {
            return (R)this.delegate.collectChar(charFunction, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableDoubleStack collectDouble(DoubleFunction<? super T> doubleFunction) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.collectDouble(doubleFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R extends MutableDoubleCollection> R collectDouble(DoubleFunction<? super T> doubleFunction, R target) {
        Object object = this.lock;
        synchronized (object) {
            return (R)this.delegate.collectDouble(doubleFunction, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableFloatStack collectFloat(FloatFunction<? super T> floatFunction) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.collectFloat(floatFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R extends MutableFloatCollection> R collectFloat(FloatFunction<? super T> floatFunction, R target) {
        Object object = this.lock;
        synchronized (object) {
            return (R)this.delegate.collectFloat(floatFunction, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableIntStack collectInt(IntFunction<? super T> intFunction) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.collectInt(intFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R extends MutableIntCollection> R collectInt(IntFunction<? super T> intFunction, R target) {
        Object object = this.lock;
        synchronized (object) {
            return (R)this.delegate.collectInt(intFunction, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableLongStack collectLong(LongFunction<? super T> longFunction) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.collectLong(longFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R extends MutableLongCollection> R collectLong(LongFunction<? super T> longFunction, R target) {
        Object object = this.lock;
        synchronized (object) {
            return (R)this.delegate.collectLong(longFunction, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableShortStack collectShort(ShortFunction<? super T> shortFunction) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.collectShort(shortFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R extends MutableShortCollection> R collectShort(ShortFunction<? super T> shortFunction, R target) {
        Object object = this.lock;
        synchronized (object) {
            return (R)this.delegate.collectShort(shortFunction, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V, R extends Collection<V>> R collect(Function<? super T, ? extends V> function, R target) {
        Object object = this.lock;
        synchronized (object) {
            return (R)this.delegate.collect(function, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P, V> MutableStack<V> collectWith(Function2<? super T, ? super P, ? extends V> function, P parameter) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.collectWith(function, parameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P, V, R extends Collection<V>> R collectWith(Function2<? super T, ? super P, ? extends V> function, P parameter, R targetCollection) {
        Object object = this.lock;
        synchronized (object) {
            return (R)this.delegate.collectWith(function, parameter, targetCollection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> MutableStack<V> collectIf(Predicate<? super T> predicate, Function<? super T, ? extends V> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.collectIf(predicate, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V, R extends Collection<V>> R collectIf(Predicate<? super T> predicate, Function<? super T, ? extends V> function, R target) {
        Object object = this.lock;
        synchronized (object) {
            return (R)this.delegate.collectIf(predicate, function, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> MutableStack<V> flatCollect(Function<? super T, ? extends Iterable<V>> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.flatCollect(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V, R extends Collection<V>> R flatCollect(Function<? super T, ? extends Iterable<V>> function, R target) {
        Object object = this.lock;
        synchronized (object) {
            return (R)this.delegate.flatCollect(function, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <S, R extends Collection<Pair<T, S>>> R zip(Iterable<S> that, R target) {
        Object object = this.lock;
        synchronized (object) {
            return (R)this.delegate.zip(that, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <S> MutableStack<Pair<T, S>> zip(Iterable<S> that) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.zip(that);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R extends Collection<Pair<T, Integer>>> R zipWithIndex(R target) {
        Object object = this.lock;
        synchronized (object) {
            return (R)this.delegate.zipWithIndex(target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableStack<Pair<T, Integer>> zipWithIndex() {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.zipWithIndex();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean notEmpty() {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.notEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getFirst() {
        Object object = this.lock;
        synchronized (object) {
            return (T)this.delegate.getFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<T> getFirstOptional() {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.getFirstOptional();
        }
    }

    public T getLast() {
        return (T)this.delegate.getLast();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<T> getLastOptional() {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.getLastOptional();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getOnly() {
        Object object = this.lock;
        synchronized (object) {
            return (T)this.delegate.getOnly();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Object object) {
        Object object2 = this.lock;
        synchronized (object2) {
            return this.delegate.contains(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAllIterable(Iterable<?> source) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.containsAllIterable(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAll(Collection<?> source) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.containsAll(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAllArguments(Object ... elements) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.containsAllArguments(elements);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T detect(Predicate<? super T> predicate) {
        Object object = this.lock;
        synchronized (object) {
            return (T)this.delegate.detect(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P> T detectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        Object object = this.lock;
        synchronized (object) {
            return (T)this.delegate.detectWith(predicate, parameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<T> detectOptional(Predicate<? super T> predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.detectOptional(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P> Optional<T> detectWithOptional(Predicate2<? super T, ? super P> predicate, P parameter) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.detectWithOptional(predicate, parameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T detectIfNone(Predicate<? super T> predicate, Function0<? extends T> function) {
        Object object = this.lock;
        synchronized (object) {
            return (T)this.delegate.detectIfNone(predicate, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P> T detectWithIfNone(Predicate2<? super T, ? super P> predicate, P parameter, Function0<? extends T> function) {
        Object object = this.lock;
        synchronized (object) {
            return (T)this.delegate.detectWithIfNone(predicate, parameter, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int count(Predicate<? super T> predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.count(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P> int countWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.countWith(predicate, parameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean anySatisfy(Predicate<? super T> predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.anySatisfy(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P> boolean anySatisfyWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.anySatisfyWith(predicate, parameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean allSatisfy(Predicate<? super T> predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.allSatisfy(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P> boolean allSatisfyWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.allSatisfyWith(predicate, parameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean noneSatisfy(Predicate<? super T> predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.noneSatisfy(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P> boolean noneSatisfyWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.noneSatisfyWith(predicate, parameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <IV> IV injectInto(IV injectedValue, Function2<? super IV, ? super T, ? extends IV> function) {
        Object object = this.lock;
        synchronized (object) {
            return (IV)this.delegate.injectInto(injectedValue, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int injectInto(int injectedValue, IntObjectToIntFunction<? super T> intObjectToIntFunction) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.injectInto(injectedValue, intObjectToIntFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long injectInto(long injectedValue, LongObjectToLongFunction<? super T> longObjectToLongFunction) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.injectInto(injectedValue, longObjectToLongFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float injectInto(float injectedValue, FloatObjectToFloatFunction<? super T> floatObjectToFloatFunction) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.injectInto(injectedValue, floatObjectToFloatFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double injectInto(double injectedValue, DoubleObjectToDoubleFunction<? super T> doubleObjectToDoubleFunction) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.injectInto(injectedValue, doubleObjectToDoubleFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R extends Collection<T>> R into(R target) {
        Object object = this.lock;
        synchronized (object) {
            return (R)this.delegate.into(target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableList<T> toList() {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.toList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableList<T> toSortedList() {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.toSortedList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableList<T> toSortedList(Comparator<? super T> comparator) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.toSortedList(comparator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V extends Comparable<? super V>> MutableList<T> toSortedListBy(Function<? super T, ? extends V> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.toSortedListBy(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableSet<T> toSet() {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.toSet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableSortedSet<T> toSortedSet() {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.toSortedSet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableSortedSet<T> toSortedSet(Comparator<? super T> comparator) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.toSortedSet(comparator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableStack<T> toStack() {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.toStack();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImmutableStack<T> toImmutable() {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.toImmutable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V extends Comparable<? super V>> MutableSortedSet<T> toSortedSetBy(Function<? super T, ? extends V> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.toSortedSetBy(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableBag<T> toBag() {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.toBag();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableSortedBag<T> toSortedBag() {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.toSortedBag();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableSortedBag<T> toSortedBag(Comparator<? super T> comparator) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.toSortedBag(comparator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V extends Comparable<? super V>> MutableSortedBag<T> toSortedBagBy(Function<? super T, ? extends V> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.toSortedBagBy(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <NK, NV> MutableMap<NK, NV> toMap(Function<? super T, ? extends NK> keyFunction, Function<? super T, ? extends NV> valueFunction) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.toMap(keyFunction, valueFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <NK, NV> MutableSortedMap<NK, NV> toSortedMap(Function<? super T, ? extends NK> keyFunction, Function<? super T, ? extends NV> valueFunction) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.toSortedMap(keyFunction, valueFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <NK, NV> MutableSortedMap<NK, NV> toSortedMap(Comparator<? super NK> comparator, Function<? super T, ? extends NK> keyFunction, Function<? super T, ? extends NV> valueFunction) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.toSortedMap(comparator, keyFunction, valueFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LazyIterable<T> asLazy() {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.asLazy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] toArray() {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.toArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T[] toArray(T[] a) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.toArray((Object[])a);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T min(Comparator<? super T> comparator) {
        Object object = this.lock;
        synchronized (object) {
            return (T)this.delegate.min(comparator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T max(Comparator<? super T> comparator) {
        Object object = this.lock;
        synchronized (object) {
            return (T)this.delegate.max(comparator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T min() {
        Object object = this.lock;
        synchronized (object) {
            return (T)this.delegate.min();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T max() {
        Object object = this.lock;
        synchronized (object) {
            return (T)this.delegate.max();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V extends Comparable<? super V>> T minBy(Function<? super T, ? extends V> function) {
        Object object = this.lock;
        synchronized (object) {
            return (T)this.delegate.minBy(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V extends Comparable<? super V>> T maxBy(Function<? super T, ? extends V> function) {
        Object object = this.lock;
        synchronized (object) {
            return (T)this.delegate.maxBy(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long sumOfInt(IntFunction<? super T> intFunction) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.sumOfInt(intFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double sumOfFloat(FloatFunction<? super T> floatFunction) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.sumOfFloat(floatFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long sumOfLong(LongFunction<? super T> longFunction) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.sumOfLong(longFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double sumOfDouble(DoubleFunction<? super T> doubleFunction) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.sumOfDouble(doubleFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> MutableObjectLongMap<V> sumByInt(Function<? super T, ? extends V> groupBy, IntFunction<? super T> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.sumByInt(groupBy, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> MutableObjectDoubleMap<V> sumByFloat(Function<? super T, ? extends V> groupBy, FloatFunction<? super T> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.sumByFloat(groupBy, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> MutableObjectLongMap<V> sumByLong(Function<? super T, ? extends V> groupBy, LongFunction<? super T> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.sumByLong(groupBy, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> MutableObjectDoubleMap<V> sumByDouble(Function<? super T, ? extends V> groupBy, DoubleFunction<? super T> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.sumByDouble(groupBy, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String makeString() {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.makeString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String makeString(String separator) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.makeString(separator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String makeString(String start, String separator, String end) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.makeString(start, separator, end);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendString(Appendable appendable) {
        Object object = this.lock;
        synchronized (object) {
            this.delegate.appendString(appendable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendString(Appendable appendable, String separator) {
        Object object = this.lock;
        synchronized (object) {
            this.delegate.appendString(appendable, separator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendString(Appendable appendable, String start, String separator, String end) {
        Object object = this.lock;
        synchronized (object) {
            this.delegate.appendString(appendable, start, separator, end);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> MutableListMultimap<V, T> groupBy(Function<? super T, ? extends V> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.groupBy(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V, R extends MutableMultimap<V, T>> R groupBy(Function<? super T, ? extends V> function, R target) {
        Object object = this.lock;
        synchronized (object) {
            return (R)this.delegate.groupBy(function, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> MutableListMultimap<V, T> groupByEach(Function<? super T, ? extends Iterable<V>> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.groupByEach(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V, R extends MutableMultimap<V, T>> R groupByEach(Function<? super T, ? extends Iterable<V>> function, R target) {
        Object object = this.lock;
        synchronized (object) {
            return (R)this.delegate.groupByEach(function, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> MutableMap<V, T> groupByUniqueKey(Function<? super T, ? extends V> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.groupByUniqueKey(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V, R extends MutableMap<V, T>> R groupByUniqueKey(Function<? super T, ? extends V> function, R target) {
        Object object = this.lock;
        synchronized (object) {
            return (R)this.delegate.groupByUniqueKey(function, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RichIterable<RichIterable<T>> chunk(int size) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.chunk(size);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableStack<T> tap(Procedure<? super T> procedure) {
        Object object = this.lock;
        synchronized (object) {
            this.delegate.forEach(procedure);
            return this;
        }
    }

    public void forEach(Procedure<? super T> procedure) {
        this.each(procedure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void each(Procedure<? super T> procedure) {
        Object object = this.lock;
        synchronized (object) {
            this.delegate.forEach(procedure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEachWithIndex(ObjectIntProcedure<? super T> objectIntProcedure) {
        Object object = this.lock;
        synchronized (object) {
            this.delegate.forEachWithIndex(objectIntProcedure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P> void forEachWith(Procedure2<? super T, ? super P> procedure, P parameter) {
        Object object = this.lock;
        synchronized (object) {
            this.delegate.forEachWith(procedure, parameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableStack<T> asUnmodifiable() {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.asUnmodifiable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object obj) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.equals(obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.hashCode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableStack<T> asSynchronized() {
        Object object = this.lock;
        synchronized (object) {
            return this;
        }
    }

    public Iterator<T> iterator() {
        return new UnmodifiableIteratorAdapter(this.delegate.iterator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V> MutableMap<K, V> aggregateInPlaceBy(Function<? super T, ? extends K> groupBy, Function0<? extends V> zeroValueFactory, Procedure2<? super V, ? super T> mutatingAggregator) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.aggregateInPlaceBy(groupBy, zeroValueFactory, mutatingAggregator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V> MutableMap<K, V> aggregateBy(Function<? super T, ? extends K> groupBy, Function0<? extends V> zeroValueFactory, Function2<? super V, ? super T, ? extends V> nonMutatingAggregator) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.aggregateBy(groupBy, zeroValueFactory, nonMutatingAggregator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableStack<T> takeWhile(Predicate<? super T> predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.takeWhile(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableStack<T> dropWhile(Predicate<? super T> predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.dropWhile(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PartitionMutableStack<T> partitionWhile(Predicate<? super T> predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.partitionWhile(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableStack<T> distinct() {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.distinct();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> MutableStack<V> collectWithIndex(ObjectIntToObjectFunction<? super T, ? extends V> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.collectWithIndex(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V, R extends Collection<V>> R collectWithIndex(ObjectIntToObjectFunction<? super T, ? extends V> function, R target) {
        Object object = this.lock;
        synchronized (object) {
            return (R)this.delegate.collectWithIndex(function, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int indexOf(Object object) {
        Object object2 = this.lock;
        synchronized (object2) {
            return this.delegate.indexOf(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <S> boolean corresponds(OrderedIterable<S> other, Predicate2<? super T, ? super S> predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.corresponds(other, predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEach(int startIndex, int endIndex, Procedure<? super T> procedure) {
        Object object = this.lock;
        synchronized (object) {
            this.delegate.forEach(startIndex, endIndex, procedure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEachWithIndex(int fromIndex, int toIndex, ObjectIntProcedure<? super T> objectIntProcedure) {
        Object object = this.lock;
        synchronized (object) {
            this.delegate.forEachWithIndex(fromIndex, toIndex, objectIntProcedure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int detectIndex(Predicate<? super T> predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.detectIndex(predicate);
        }
    }
}

