/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.mutable.primitive;

import java.io.Serializable;
import org.eclipse.collections.api.ByteIterable;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.LazyByteIterable;
import org.eclipse.collections.api.LazyIntIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.bag.primitive.MutableByteBag;
import org.eclipse.collections.api.block.function.primitive.ByteFunction;
import org.eclipse.collections.api.block.function.primitive.ByteFunction0;
import org.eclipse.collections.api.block.function.primitive.ByteToByteFunction;
import org.eclipse.collections.api.block.function.primitive.ByteToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.IntToByteFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectByteToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.BytePredicate;
import org.eclipse.collections.api.block.predicate.primitive.IntBytePredicate;
import org.eclipse.collections.api.block.procedure.primitive.ByteProcedure;
import org.eclipse.collections.api.block.procedure.primitive.IntByteProcedure;
import org.eclipse.collections.api.block.procedure.primitive.IntProcedure;
import org.eclipse.collections.api.collection.primitive.MutableByteCollection;
import org.eclipse.collections.api.iterator.ByteIterator;
import org.eclipse.collections.api.iterator.MutableByteIterator;
import org.eclipse.collections.api.list.primitive.MutableByteList;
import org.eclipse.collections.api.map.primitive.ImmutableIntByteMap;
import org.eclipse.collections.api.map.primitive.IntByteMap;
import org.eclipse.collections.api.map.primitive.MutableByteIntMap;
import org.eclipse.collections.api.map.primitive.MutableIntByteMap;
import org.eclipse.collections.api.set.primitive.MutableByteSet;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.api.tuple.primitive.IntBytePair;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableByteCollection;
import org.eclipse.collections.impl.factory.primitive.IntByteMaps;
import org.eclipse.collections.impl.iterator.UnmodifiableByteIterator;
import org.eclipse.collections.impl.map.mutable.primitive.SynchronizedIntByteMap;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableIntSet;

public final class UnmodifiableIntByteMap
implements MutableIntByteMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableIntByteMap map;

    public UnmodifiableIntByteMap(MutableIntByteMap map) {
        if (map == null) {
            throw new IllegalArgumentException("Cannot create a UnmodifiableIntByteMap on a null map");
        }
        this.map = map;
    }

    public void clear() {
        throw new UnsupportedOperationException("Cannot call clear() on " + this.getClass().getSimpleName());
    }

    public void put(int key, byte value) {
        throw new UnsupportedOperationException("Cannot call put() on " + this.getClass().getSimpleName());
    }

    public void putPair(IntBytePair keyValuePair) {
        throw new UnsupportedOperationException("Cannot call putPair() on " + this.getClass().getSimpleName());
    }

    public void putAll(IntByteMap map) {
        throw new UnsupportedOperationException("Cannot call putAll() on " + this.getClass().getSimpleName());
    }

    public void removeKey(int key) {
        throw new UnsupportedOperationException("Cannot call removeKey() on " + this.getClass().getSimpleName());
    }

    public void remove(int key) {
        throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
    }

    public byte removeKeyIfAbsent(int key, byte value) {
        if (this.map.containsKey(key)) {
            throw new UnsupportedOperationException("Cannot call removeKey() on " + this.getClass().getSimpleName());
        }
        return value;
    }

    public byte getIfAbsentPut(int key, byte value) {
        return this.map.getIfAbsentPut(key, (ByteFunction0 & Serializable)() -> {
            throw new UnsupportedOperationException();
        });
    }

    public byte getIfAbsentPut(int key, ByteFunction0 function) {
        return this.map.getIfAbsentPut(key, (ByteFunction0 & Serializable)() -> {
            throw new UnsupportedOperationException();
        });
    }

    public byte getIfAbsentPutWithKey(int key, IntToByteFunction function) {
        return this.map.getIfAbsentPut(key, (ByteFunction0 & Serializable)() -> {
            throw new UnsupportedOperationException();
        });
    }

    public <P> byte getIfAbsentPutWith(int key, ByteFunction<? super P> function, P parameter) {
        return this.map.getIfAbsentPut(key, (ByteFunction0 & Serializable)() -> {
            throw new UnsupportedOperationException();
        });
    }

    public byte updateValue(int key, byte initialValueIfAbsent, ByteToByteFunction function) {
        throw new UnsupportedOperationException("Cannot call updateValue() on " + this.getClass().getSimpleName());
    }

    public byte get(int key) {
        return this.map.get(key);
    }

    public byte getIfAbsent(int key, byte ifAbsent) {
        return this.map.getIfAbsent(key, ifAbsent);
    }

    public byte getOrThrow(int key) {
        return this.map.getOrThrow(key);
    }

    public boolean containsKey(int key) {
        return this.map.containsKey(key);
    }

    public boolean containsValue(byte value) {
        return this.map.containsValue(value);
    }

    public void forEachValue(ByteProcedure procedure) {
        this.map.forEachValue(procedure);
    }

    public void forEachKey(IntProcedure procedure) {
        this.map.forEachKey(procedure);
    }

    public void forEachKeyValue(IntByteProcedure procedure) {
        this.map.forEachKeyValue(procedure);
    }

    public LazyIntIterable keysView() {
        return this.map.keysView();
    }

    public RichIterable<IntBytePair> keyValuesView() {
        return this.map.keyValuesView();
    }

    public MutableByteIntMap flipUniqueValues() {
        return this.map.flipUniqueValues().asUnmodifiable();
    }

    public MutableIntByteMap select(IntBytePredicate predicate) {
        return this.map.select(predicate);
    }

    public MutableIntByteMap reject(IntBytePredicate predicate) {
        return this.map.reject(predicate);
    }

    public MutableByteIterator byteIterator() {
        return new UnmodifiableByteIterator((ByteIterator)this.map.byteIterator());
    }

    public void forEach(ByteProcedure procedure) {
        this.each(procedure);
    }

    public void each(ByteProcedure procedure) {
        this.map.forEach(procedure);
    }

    public int count(BytePredicate predicate) {
        return this.map.count(predicate);
    }

    public boolean anySatisfy(BytePredicate predicate) {
        return this.map.anySatisfy(predicate);
    }

    public boolean allSatisfy(BytePredicate predicate) {
        return this.map.allSatisfy(predicate);
    }

    public boolean noneSatisfy(BytePredicate predicate) {
        return this.map.noneSatisfy(predicate);
    }

    public MutableByteBag select(BytePredicate predicate) {
        return this.map.select(predicate);
    }

    public MutableByteBag reject(BytePredicate predicate) {
        return this.map.reject(predicate);
    }

    public <V> MutableBag<V> collect(ByteToObjectFunction<? extends V> function) {
        return this.map.collect(function);
    }

    public byte detectIfNone(BytePredicate predicate, byte ifNone) {
        return this.map.detectIfNone(predicate, ifNone);
    }

    public long sum() {
        return this.map.sum();
    }

    public byte max() {
        return this.map.max();
    }

    public byte maxIfEmpty(byte defaultValue) {
        return this.map.maxIfEmpty(defaultValue);
    }

    public byte min() {
        return this.map.min();
    }

    public byte minIfEmpty(byte defaultValue) {
        return this.map.minIfEmpty(defaultValue);
    }

    public double average() {
        return this.map.average();
    }

    public double median() {
        return this.map.median();
    }

    public byte addToValue(int key, byte toBeAdded) {
        throw new UnsupportedOperationException("Cannot call addToValue() on " + this.getClass().getSimpleName());
    }

    public byte[] toSortedArray() {
        return this.map.toSortedArray();
    }

    public MutableByteList toSortedList() {
        return this.map.toSortedList();
    }

    public byte[] toArray() {
        return this.map.toArray();
    }

    public boolean contains(byte value) {
        return this.map.contains(value);
    }

    public boolean containsAll(byte ... source) {
        return this.map.containsAll(source);
    }

    public boolean containsAll(ByteIterable source) {
        return this.map.containsAll(source);
    }

    public MutableByteList toList() {
        return this.map.toList();
    }

    public MutableByteSet toSet() {
        return this.map.toSet();
    }

    public MutableByteBag toBag() {
        return this.map.toBag();
    }

    public LazyByteIterable asLazy() {
        return this.map.asLazy();
    }

    public MutableIntByteMap withKeyValue(int key, byte value) {
        throw new UnsupportedOperationException("Cannot call withKeyValue() on " + this.getClass().getSimpleName());
    }

    public MutableIntByteMap withoutKey(int key) {
        throw new UnsupportedOperationException("Cannot call withoutKey() on " + this.getClass().getSimpleName());
    }

    public MutableIntByteMap withoutAllKeys(IntIterable keys) {
        throw new UnsupportedOperationException("Cannot call withoutAllKeys() on " + this.getClass().getSimpleName());
    }

    public MutableIntByteMap asUnmodifiable() {
        return this;
    }

    public MutableIntByteMap asSynchronized() {
        return new SynchronizedIntByteMap(this);
    }

    public ImmutableIntByteMap toImmutable() {
        return IntByteMaps.immutable.withAll((IntByteMap)this);
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean notEmpty() {
        return this.map.notEmpty();
    }

    public MutableIntSet keySet() {
        return UnmodifiableIntSet.of(this.map.keySet());
    }

    public MutableByteCollection values() {
        return UnmodifiableByteCollection.of(this.map.values());
    }

    public boolean equals(Object otherMap) {
        return this.map.equals(otherMap);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public String toString() {
        return this.map.toString();
    }

    public String makeString() {
        return this.map.makeString();
    }

    public String makeString(String separator) {
        return this.map.makeString(separator);
    }

    public String makeString(String start, String separator, String end) {
        return this.map.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable) {
        this.map.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator) {
        this.map.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.map.appendString(appendable, start, separator, end);
    }

    public <T> T injectInto(T injectedValue, ObjectByteToObjectFunction<? super T, ? extends T> function) {
        return (T)this.map.injectInto(injectedValue, function);
    }
}

