/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.bag.immutable;

import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.eclipse.collections.api.bag.Bag;
import org.eclipse.collections.api.bag.ImmutableBag;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function0;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.api.multimap.MutableMultimap;
import org.eclipse.collections.api.multimap.bag.ImmutableBagMultimap;
import org.eclipse.collections.api.set.ImmutableSet;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.impl.bag.immutable.AbstractImmutableBag;
import org.eclipse.collections.impl.bag.immutable.ImmutableBagSerializationProxy;
import org.eclipse.collections.impl.bag.mutable.HashBag;
import org.eclipse.collections.impl.block.factory.Comparators;
import org.eclipse.collections.impl.block.factory.Predicates;
import org.eclipse.collections.impl.block.procedure.MultimapEachPutProcedure;
import org.eclipse.collections.impl.factory.Bags;
import org.eclipse.collections.impl.factory.Sets;
import org.eclipse.collections.impl.map.mutable.UnifiedMap;
import org.eclipse.collections.impl.multimap.bag.HashBagMultimap;
import org.eclipse.collections.impl.tuple.Tuples;
import org.eclipse.collections.impl.utility.ArrayIterate;
import org.eclipse.collections.impl.utility.Iterate;

final class ImmutableSingletonBag<T>
extends AbstractImmutableBag<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final T value;

    ImmutableSingletonBag(T object) {
        this.value = object;
    }

    @Override
    public boolean allSatisfy(Predicate<? super T> predicate) {
        return predicate.accept(this.value);
    }

    @Override
    public boolean noneSatisfy(Predicate<? super T> predicate) {
        return !predicate.accept(this.value);
    }

    @Override
    public <IV> IV injectInto(IV injectedValue, Function2<? super IV, ? super T, ? extends IV> function) {
        return (IV)function.value(injectedValue, this.value);
    }

    @Override
    public T min(Comparator<? super T> comparator) {
        return this.value;
    }

    @Override
    public T max(Comparator<? super T> comparator) {
        return this.value;
    }

    @Override
    public T min() {
        return this.value;
    }

    @Override
    public T max() {
        return this.value;
    }

    @Override
    public <V extends Comparable<? super V>> T minBy(Function<? super T, ? extends V> function) {
        return this.value;
    }

    @Override
    public <V extends Comparable<? super V>> T maxBy(Function<? super T, ? extends V> function) {
        return this.value;
    }

    public ImmutableBag<T> newWith(T element) {
        return Bags.immutable.with(new Object[]{this.value, element});
    }

    public ImmutableBag<T> newWithout(T element) {
        return this.emptyIfMatchesOrThis(Predicates.equal(element));
    }

    private ImmutableBag<T> emptyIfMatchesOrThis(Predicate<Object> predicate) {
        return predicate.accept(this.value) ? Bags.immutable.empty() : this;
    }

    public ImmutableBag<T> newWithAll(Iterable<? extends T> elements) {
        HashBag<? extends T> bag = HashBag.newBag(elements);
        return bag.with(this.value).toImmutable();
    }

    @Override
    public ImmutableBag<T> newWithoutAll(Iterable<? extends T> elements) {
        return this.emptyIfMatchesOrThis(Predicates.in(elements));
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    public boolean notEmpty() {
        return true;
    }

    public T getFirst() {
        return this.value;
    }

    public T getLast() {
        return this.value;
    }

    public T getOnly() {
        return this.value;
    }

    @Override
    public boolean contains(Object object) {
        return Comparators.nullSafeEquals(this.value, object);
    }

    @Override
    public boolean containsAllIterable(Iterable<?> source) {
        return Iterate.allSatisfy(source, Predicates.equal(this.value));
    }

    @Override
    public boolean containsAllArguments(Object ... elements) {
        return ArrayIterate.allSatisfy(elements, Predicates.equal(this.value));
    }

    public ImmutableBag<T> selectByOccurrences(IntPredicate predicate) {
        return predicate.accept(1) ? this : Bags.immutable.empty();
    }

    public ImmutableBag<T> select(Predicate<? super T> predicate) {
        return predicate.accept(this.value) ? this : Bags.immutable.empty();
    }

    @Override
    public <R extends Collection<T>> R select(Predicate<? super T> predicate, R target) {
        if (predicate.accept(this.value)) {
            target.add(this.value);
        }
        return target;
    }

    @Override
    public <P, R extends Collection<T>> R selectWith(Predicate2<? super T, ? super P> predicate, P parameter, R target) {
        if (predicate.accept(this.value, parameter)) {
            target.add(this.value);
        }
        return target;
    }

    public ImmutableBag<T> reject(Predicate<? super T> predicate) {
        return predicate.accept(this.value) ? Bags.immutable.empty() : this;
    }

    @Override
    public <R extends Collection<T>> R reject(Predicate<? super T> predicate, R target) {
        if (!predicate.accept(this.value)) {
            target.add(this.value);
        }
        return target;
    }

    @Override
    public <P, R extends Collection<T>> R rejectWith(Predicate2<? super T, ? super P> predicate, P parameter, R target) {
        if (!predicate.accept(this.value, parameter)) {
            target.add(this.value);
        }
        return target;
    }

    public <S> ImmutableBag<S> selectInstancesOf(Class<S> clazz) {
        return clazz.isInstance(this.value) ? this : Bags.immutable.empty();
    }

    public <V> ImmutableBag<V> collect(Function<? super T, ? extends V> function) {
        return Bags.immutable.with(function.valueOf(this.value));
    }

    public <V> ImmutableBag<V> collectIf(Predicate<? super T> predicate, Function<? super T, ? extends V> function) {
        return predicate.accept(this.value) ? Bags.immutable.with(function.valueOf(this.value)) : Bags.immutable.empty();
    }

    @Override
    public <V, R extends Collection<V>> R collectIf(Predicate<? super T> predicate, Function<? super T, ? extends V> function, R target) {
        if (predicate.accept(this.value)) {
            target.add((Object)function.valueOf(this.value));
        }
        return target;
    }

    public <V> ImmutableBag<V> flatCollect(Function<? super T, ? extends Iterable<V>> function) {
        return this.flatCollect(function, HashBag.newBag()).toImmutable();
    }

    @Override
    public <V, R extends Collection<V>> R flatCollect(Function<? super T, ? extends Iterable<V>> function, R target) {
        Iterate.addAllTo((Iterable)function.valueOf(this.value), target);
        return target;
    }

    @Override
    public T detect(Predicate<? super T> predicate) {
        return predicate.accept(this.value) ? (T)this.value : null;
    }

    @Override
    public Optional<T> detectOptional(Predicate<? super T> predicate) {
        return predicate.accept(this.value) ? Optional.of(this.value) : Optional.empty();
    }

    public T detectIfNone(Predicate<? super T> predicate, Function0<? extends T> function) {
        return (T)(predicate.accept(this.value) ? this.value : function.value());
    }

    @Override
    public int count(Predicate<? super T> predicate) {
        return predicate.accept(this.value) ? 1 : 0;
    }

    @Override
    public boolean anySatisfy(Predicate<? super T> predicate) {
        return predicate.accept(this.value);
    }

    public <V> ImmutableBagMultimap<V, T> groupBy(Function<? super T, ? extends V> function) {
        return this.groupBy(function, HashBagMultimap.newMultimap()).toImmutable();
    }

    @Override
    public <V, R extends MutableMultimap<V, T>> R groupBy(Function<? super T, ? extends V> function, R target) {
        target.putAll(function.valueOf(this.value), (Iterable)this);
        return target;
    }

    public <V> ImmutableBagMultimap<V, T> groupByEach(Function<? super T, ? extends Iterable<V>> function) {
        return this.groupByEach(function, HashBagMultimap.newMultimap()).toImmutable();
    }

    @Override
    public <V, R extends MutableMultimap<V, T>> R groupByEach(Function<? super T, ? extends Iterable<V>> function, R target) {
        this.forEach(MultimapEachPutProcedure.on(target, function));
        return target;
    }

    public int sizeDistinct() {
        return 1;
    }

    public int occurrencesOf(Object item) {
        return Comparators.nullSafeEquals(this.value, item) ? 1 : 0;
    }

    public void forEachWithOccurrences(ObjectIntProcedure<? super T> objectIntProcedure) {
        objectIntProcedure.value(this.value, 1);
    }

    public <V, R extends Collection<V>> R collectWithOccurrences(ObjectIntToObjectFunction<? super T, ? extends V> function, R target) {
        target.add((Object)function.valueOf(this.value, 1));
        return target;
    }

    public MutableMap<T, Integer> toMapOfItemToCount() {
        return UnifiedMap.newWithKeysValues(this.value, 1);
    }

    @Override
    public ImmutableBag<T> toImmutable() {
        return this;
    }

    public void each(Procedure<? super T> procedure) {
        procedure.value(this.value);
    }

    @Override
    public void forEachWithIndex(ObjectIntProcedure<? super T> objectIntProcedure) {
        objectIntProcedure.value(this.value, 0);
    }

    @Override
    public <P> void forEachWith(Procedure2<? super T, ? super P> procedure, P parameter) {
        procedure.value(this.value, parameter);
    }

    @Deprecated
    public <S> ImmutableBag<Pair<T, S>> zip(Iterable<S> that) {
        Iterator<S> iterator = that.iterator();
        if (!iterator.hasNext()) {
            return Bags.immutable.empty();
        }
        return Bags.immutable.with(Tuples.pair(this.value, iterator.next()));
    }

    @Deprecated
    public ImmutableSet<Pair<T, Integer>> zipWithIndex() {
        return Sets.immutable.with(Tuples.pair(this.value, 0));
    }

    @Override
    public Iterator<T> iterator() {
        return new SingletonIterator();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Bag)) {
            return false;
        }
        Bag bag = (Bag)obj;
        if (this.size() != bag.size()) {
            return false;
        }
        return this.occurrencesOf(this.value) == bag.occurrencesOf(this.value);
    }

    @Override
    public String toString() {
        return '[' + this.makeString() + ']';
    }

    @Override
    public int hashCode() {
        return (this.value == null ? 0 : this.value.hashCode()) ^ 1;
    }

    private Object writeReplace() {
        return new ImmutableBagSerializationProxy(this);
    }

    @Override
    public ImmutableSet<T> selectUnique() {
        return Sets.immutable.of(this.value);
    }

    private class SingletonIterator
    implements Iterator<T> {
        private boolean next = true;

        private SingletonIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.next;
        }

        @Override
        public T next() {
            if (this.next) {
                this.next = false;
                return ImmutableSingletonBag.this.value;
            }
            throw new NoSuchElementException("i=" + this.next);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cannot remove from an ImmutableBag");
        }
    }
}

